/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlEndpointResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetMlEndpointResponse.Builder, GetMlEndpointResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMlEndpointResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetMlEndpointResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MlResourceDefinition> ENDPOINT_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("endpoint")
            .getter(getter(GetMlEndpointResponse::endpoint)).setter(setter(Builder::endpoint))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<MlConfigDefinition> ENDPOINT_CONFIG_FIELD = SdkField
            .<MlConfigDefinition> builder(MarshallingType.SDK_POJO).memberName("endpointConfig")
            .getter(getter(GetMlEndpointResponse::endpointConfig)).setter(setter(Builder::endpointConfig))
            .constructor(MlConfigDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD,
            ENDPOINT_FIELD, ENDPOINT_CONFIG_FIELD));

    private final String status;

    private final String id;

    private final MlResourceDefinition endpoint;

    private final MlConfigDefinition endpointConfig;

    private GetMlEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.endpoint = builder.endpoint;
        this.endpointConfig = builder.endpointConfig;
    }

    /**
     * <p>
     * The status of the inference endpoint.
     * </p>
     * 
     * @return The status of the inference endpoint.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The unique identifier of the inference endpoint.
     * </p>
     * 
     * @return The unique identifier of the inference endpoint.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The endpoint definition.
     * </p>
     * 
     * @return The endpoint definition.
     */
    public final MlResourceDefinition endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The endpoint configuration
     * </p>
     * 
     * @return The endpoint configuration
     */
    public final MlConfigDefinition endpointConfig() {
        return endpointConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(endpointConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlEndpointResponse)) {
            return false;
        }
        GetMlEndpointResponse other = (GetMlEndpointResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(id(), other.id())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(endpointConfig(), other.endpointConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlEndpointResponse").add("Status", status()).add("Id", id()).add("Endpoint", endpoint())
                .add("EndpointConfig", endpointConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "endpointConfig":
            return Optional.ofNullable(clazz.cast(endpointConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlEndpointResponse, T> g) {
        return obj -> g.apply((GetMlEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMlEndpointResponse> {
        /**
         * <p>
         * The status of the inference endpoint.
         * </p>
         * 
         * @param status
         *        The status of the inference endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The unique identifier of the inference endpoint.
         * </p>
         * 
         * @param id
         *        The unique identifier of the inference endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The endpoint definition.
         * </p>
         * 
         * @param endpoint
         *        The endpoint definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(MlResourceDefinition endpoint);

        /**
         * <p>
         * The endpoint definition.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #endpoint(MlResourceDefinition)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(MlResourceDefinition)
         */
        default Builder endpoint(Consumer<MlResourceDefinition.Builder> endpoint) {
            return endpoint(MlResourceDefinition.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * The endpoint configuration
         * </p>
         * 
         * @param endpointConfig
         *        The endpoint configuration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointConfig(MlConfigDefinition endpointConfig);

        /**
         * <p>
         * The endpoint configuration
         * </p>
         * This is a convenience method that creates an instance of the {@link MlConfigDefinition.Builder} avoiding the
         * need to create one manually via {@link MlConfigDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlConfigDefinition.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointConfig(MlConfigDefinition)}.
         * 
         * @param endpointConfig
         *        a consumer that will call methods on {@link MlConfigDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointConfig(MlConfigDefinition)
         */
        default Builder endpointConfig(Consumer<MlConfigDefinition.Builder> endpointConfig) {
            return endpointConfig(MlConfigDefinition.builder().applyMutation(endpointConfig).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private String id;

        private MlResourceDefinition endpoint;

        private MlConfigDefinition endpointConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlEndpointResponse model) {
            super(model);
            status(model.status);
            id(model.id);
            endpoint(model.endpoint);
            endpointConfig(model.endpointConfig);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(MlResourceDefinition.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(MlResourceDefinition endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final MlConfigDefinition.Builder getEndpointConfig() {
            return endpointConfig != null ? endpointConfig.toBuilder() : null;
        }

        public final void setEndpointConfig(MlConfigDefinition.BuilderImpl endpointConfig) {
            this.endpointConfig = endpointConfig != null ? endpointConfig.build() : null;
        }

        @Override
        public final Builder endpointConfig(MlConfigDefinition endpointConfig) {
            this.endpointConfig = endpointConfig;
            return this;
        }

        @Override
        public GetMlEndpointResponse build() {
            return new GetMlEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
