/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteOpenCypherExplainQueryResponse extends NeptunedataResponse implements
        ToCopyableBuilder<ExecuteOpenCypherExplainQueryResponse.Builder, ExecuteOpenCypherExplainQueryResponse> {
    private static final SdkField<SdkBytes> RESULTS_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("results")
            .getter(getter(ExecuteOpenCypherExplainQueryResponse::results))
            .setter(setter(Builder::results))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("results").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULTS_FIELD));

    private final SdkBytes results;

    private ExecuteOpenCypherExplainQueryResponse(BuilderImpl builder) {
        super(builder);
        this.results = builder.results;
    }

    /**
     * <p>
     * A text blob containing the openCypher <code>explain</code> results.
     * </p>
     * 
     * @return A text blob containing the openCypher <code>explain</code> results.
     */
    public final SdkBytes results() {
        return results;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(results());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteOpenCypherExplainQueryResponse)) {
            return false;
        }
        ExecuteOpenCypherExplainQueryResponse other = (ExecuteOpenCypherExplainQueryResponse) obj;
        return Objects.equals(results(), other.results());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteOpenCypherExplainQueryResponse").add("Results", results()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "results":
            return Optional.ofNullable(clazz.cast(results()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteOpenCypherExplainQueryResponse, T> g) {
        return obj -> g.apply((ExecuteOpenCypherExplainQueryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ExecuteOpenCypherExplainQueryResponse> {
        /**
         * <p>
         * A text blob containing the openCypher <code>explain</code> results.
         * </p>
         * 
         * @param results
         *        A text blob containing the openCypher <code>explain</code> results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder results(SdkBytes results);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private SdkBytes results;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteOpenCypherExplainQueryResponse model) {
            super(model);
            results(model.results);
        }

        public final ByteBuffer getResults() {
            return results == null ? null : results.asByteBuffer();
        }

        public final void setResults(ByteBuffer results) {
            results(results == null ? null : SdkBytes.fromByteBuffer(results));
        }

        @Override
        public final Builder results(SdkBytes results) {
            this.results = results;
            return this;
        }

        @Override
        public ExecuteOpenCypherExplainQueryResponse build() {
            return new ExecuteOpenCypherExplainQueryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
