/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMlModelTransformJobResponse extends NeptunedataResponse implements
        ToCopyableBuilder<GetMlModelTransformJobResponse.Builder, GetMlModelTransformJobResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetMlModelTransformJobResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetMlModelTransformJobResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<MlResourceDefinition> BASE_PROCESSING_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("baseProcessingJob")
            .getter(getter(GetMlModelTransformJobResponse::baseProcessingJob)).setter(setter(Builder::baseProcessingJob))
            .constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseProcessingJob").build()).build();

    private static final SdkField<MlResourceDefinition> REMOTE_MODEL_TRANSFORM_JOB_FIELD = SdkField
            .<MlResourceDefinition> builder(MarshallingType.SDK_POJO).memberName("remoteModelTransformJob")
            .getter(getter(GetMlModelTransformJobResponse::remoteModelTransformJob))
            .setter(setter(Builder::remoteModelTransformJob)).constructor(MlResourceDefinition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("remoteModelTransformJob").build())
            .build();

    private static final SdkField<List<MlConfigDefinition>> MODELS_FIELD = SdkField
            .<List<MlConfigDefinition>> builder(MarshallingType.LIST)
            .memberName("models")
            .getter(getter(GetMlModelTransformJobResponse::models))
            .setter(setter(Builder::models))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("models").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MlConfigDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(MlConfigDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ID_FIELD,
            BASE_PROCESSING_JOB_FIELD, REMOTE_MODEL_TRANSFORM_JOB_FIELD, MODELS_FIELD));

    private final String status;

    private final String id;

    private final MlResourceDefinition baseProcessingJob;

    private final MlResourceDefinition remoteModelTransformJob;

    private final List<MlConfigDefinition> models;

    private GetMlModelTransformJobResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.id = builder.id;
        this.baseProcessingJob = builder.baseProcessingJob;
        this.remoteModelTransformJob = builder.remoteModelTransformJob;
        this.models = builder.models;
    }

    /**
     * <p>
     * The status of the model-transform job.
     * </p>
     * 
     * @return The status of the model-transform job.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The unique identifier of the model-transform job to be retrieved.
     * </p>
     * 
     * @return The unique identifier of the model-transform job to be retrieved.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The base data processing job.
     * </p>
     * 
     * @return The base data processing job.
     */
    public final MlResourceDefinition baseProcessingJob() {
        return baseProcessingJob;
    }

    /**
     * <p>
     * The remote model transform job.
     * </p>
     * 
     * @return The remote model transform job.
     */
    public final MlResourceDefinition remoteModelTransformJob() {
        return remoteModelTransformJob;
    }

    /**
     * For responses, this returns true if the service returned a value for the Models property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasModels() {
        return models != null && !(models instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the configuration information for the models being used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModels} method.
     * </p>
     * 
     * @return A list of the configuration information for the models being used.
     */
    public final List<MlConfigDefinition> models() {
        return models;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(baseProcessingJob());
        hashCode = 31 * hashCode + Objects.hashCode(remoteModelTransformJob());
        hashCode = 31 * hashCode + Objects.hashCode(hasModels() ? models() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMlModelTransformJobResponse)) {
            return false;
        }
        GetMlModelTransformJobResponse other = (GetMlModelTransformJobResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(id(), other.id())
                && Objects.equals(baseProcessingJob(), other.baseProcessingJob())
                && Objects.equals(remoteModelTransformJob(), other.remoteModelTransformJob()) && hasModels() == other.hasModels()
                && Objects.equals(models(), other.models());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMlModelTransformJobResponse").add("Status", status()).add("Id", id())
                .add("BaseProcessingJob", baseProcessingJob()).add("RemoteModelTransformJob", remoteModelTransformJob())
                .add("Models", hasModels() ? models() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "baseProcessingJob":
            return Optional.ofNullable(clazz.cast(baseProcessingJob()));
        case "remoteModelTransformJob":
            return Optional.ofNullable(clazz.cast(remoteModelTransformJob()));
        case "models":
            return Optional.ofNullable(clazz.cast(models()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMlModelTransformJobResponse, T> g) {
        return obj -> g.apply((GetMlModelTransformJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetMlModelTransformJobResponse> {
        /**
         * <p>
         * The status of the model-transform job.
         * </p>
         * 
         * @param status
         *        The status of the model-transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The unique identifier of the model-transform job to be retrieved.
         * </p>
         * 
         * @param id
         *        The unique identifier of the model-transform job to be retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The base data processing job.
         * </p>
         * 
         * @param baseProcessingJob
         *        The base data processing job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseProcessingJob(MlResourceDefinition baseProcessingJob);

        /**
         * <p>
         * The base data processing job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #baseProcessingJob(MlResourceDefinition)}.
         * 
         * @param baseProcessingJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #baseProcessingJob(MlResourceDefinition)
         */
        default Builder baseProcessingJob(Consumer<MlResourceDefinition.Builder> baseProcessingJob) {
            return baseProcessingJob(MlResourceDefinition.builder().applyMutation(baseProcessingJob).build());
        }

        /**
         * <p>
         * The remote model transform job.
         * </p>
         * 
         * @param remoteModelTransformJob
         *        The remote model transform job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder remoteModelTransformJob(MlResourceDefinition remoteModelTransformJob);

        /**
         * <p>
         * The remote model transform job.
         * </p>
         * This is a convenience method that creates an instance of the {@link MlResourceDefinition.Builder} avoiding
         * the need to create one manually via {@link MlResourceDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MlResourceDefinition.Builder#build()} is called immediately and
         * its result is passed to {@link #remoteModelTransformJob(MlResourceDefinition)}.
         * 
         * @param remoteModelTransformJob
         *        a consumer that will call methods on {@link MlResourceDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #remoteModelTransformJob(MlResourceDefinition)
         */
        default Builder remoteModelTransformJob(Consumer<MlResourceDefinition.Builder> remoteModelTransformJob) {
            return remoteModelTransformJob(MlResourceDefinition.builder().applyMutation(remoteModelTransformJob).build());
        }

        /**
         * <p>
         * A list of the configuration information for the models being used.
         * </p>
         * 
         * @param models
         *        A list of the configuration information for the models being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(Collection<MlConfigDefinition> models);

        /**
         * <p>
         * A list of the configuration information for the models being used.
         * </p>
         * 
         * @param models
         *        A list of the configuration information for the models being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder models(MlConfigDefinition... models);

        /**
         * <p>
         * A list of the configuration information for the models being used.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #models(List<MlConfigDefinition>)}.
         * 
         * @param models
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunedata.model.MlConfigDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #models(java.util.Collection<MlConfigDefinition>)
         */
        Builder models(Consumer<MlConfigDefinition.Builder>... models);
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private String status;

        private String id;

        private MlResourceDefinition baseProcessingJob;

        private MlResourceDefinition remoteModelTransformJob;

        private List<MlConfigDefinition> models = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMlModelTransformJobResponse model) {
            super(model);
            status(model.status);
            id(model.id);
            baseProcessingJob(model.baseProcessingJob);
            remoteModelTransformJob(model.remoteModelTransformJob);
            models(model.models);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final MlResourceDefinition.Builder getBaseProcessingJob() {
            return baseProcessingJob != null ? baseProcessingJob.toBuilder() : null;
        }

        public final void setBaseProcessingJob(MlResourceDefinition.BuilderImpl baseProcessingJob) {
            this.baseProcessingJob = baseProcessingJob != null ? baseProcessingJob.build() : null;
        }

        @Override
        public final Builder baseProcessingJob(MlResourceDefinition baseProcessingJob) {
            this.baseProcessingJob = baseProcessingJob;
            return this;
        }

        public final MlResourceDefinition.Builder getRemoteModelTransformJob() {
            return remoteModelTransformJob != null ? remoteModelTransformJob.toBuilder() : null;
        }

        public final void setRemoteModelTransformJob(MlResourceDefinition.BuilderImpl remoteModelTransformJob) {
            this.remoteModelTransformJob = remoteModelTransformJob != null ? remoteModelTransformJob.build() : null;
        }

        @Override
        public final Builder remoteModelTransformJob(MlResourceDefinition remoteModelTransformJob) {
            this.remoteModelTransformJob = remoteModelTransformJob;
            return this;
        }

        public final List<MlConfigDefinition.Builder> getModels() {
            List<MlConfigDefinition.Builder> result = ModelsCopier.copyToBuilder(this.models);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModels(Collection<MlConfigDefinition.BuilderImpl> models) {
            this.models = ModelsCopier.copyFromBuilder(models);
        }

        @Override
        public final Builder models(Collection<MlConfigDefinition> models) {
            this.models = ModelsCopier.copy(models);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(MlConfigDefinition... models) {
            models(Arrays.asList(models));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder models(Consumer<MlConfigDefinition.Builder>... models) {
            models(Stream.of(models).map(c -> MlConfigDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMlModelTransformJobResponse build() {
            return new GetMlModelTransformJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
