/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMlModelTransformJobsRequest
extends NeptunedataRequest
implements ToCopyableBuilder<Builder, ListMlModelTransformJobsRequest> {
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxItems").getter(ListMlModelTransformJobsRequest.getter(ListMlModelTransformJobsRequest::maxItems)).setter(ListMlModelTransformJobsRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxItems").build()}).build();
    private static final SdkField<String> NEPTUNE_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("neptuneIamRoleArn").getter(ListMlModelTransformJobsRequest.getter(ListMlModelTransformJobsRequest::neptuneIamRoleArn)).setter(ListMlModelTransformJobsRequest.setter(Builder::neptuneIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("neptuneIamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_ITEMS_FIELD, NEPTUNE_IAM_ROLE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("maxItems", MAX_ITEMS_FIELD);
            this.put("neptuneIamRoleArn", NEPTUNE_IAM_ROLE_ARN_FIELD);
        }
    });
    private final Integer maxItems;
    private final String neptuneIamRoleArn;

    private ListMlModelTransformJobsRequest(BuilderImpl builder) {
        super(builder);
        this.maxItems = builder.maxItems;
        this.neptuneIamRoleArn = builder.neptuneIamRoleArn;
    }

    public final Integer maxItems() {
        return this.maxItems;
    }

    public final String neptuneIamRoleArn() {
        return this.neptuneIamRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        hashCode = 31 * hashCode + Objects.hashCode(this.neptuneIamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMlModelTransformJobsRequest)) {
            return false;
        }
        ListMlModelTransformJobsRequest other = (ListMlModelTransformJobsRequest)((Object)obj);
        return Objects.equals(this.maxItems(), other.maxItems()) && Objects.equals(this.neptuneIamRoleArn(), other.neptuneIamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"ListMlModelTransformJobsRequest").add("MaxItems", (Object)this.maxItems()).add("NeptuneIamRoleArn", (Object)this.neptuneIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
            case "neptuneIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.neptuneIamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListMlModelTransformJobsRequest, T> g) {
        return obj -> g.apply((ListMlModelTransformJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptunedataRequest.BuilderImpl
    implements Builder {
        private Integer maxItems;
        private String neptuneIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMlModelTransformJobsRequest model) {
            super(model);
            this.maxItems(model.maxItems);
            this.neptuneIamRoleArn(model.neptuneIamRoleArn);
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final String getNeptuneIamRoleArn() {
            return this.neptuneIamRoleArn;
        }

        public final void setNeptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
        }

        @Override
        public final Builder neptuneIamRoleArn(String neptuneIamRoleArn) {
            this.neptuneIamRoleArn = neptuneIamRoleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListMlModelTransformJobsRequest build() {
            return new ListMlModelTransformJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptunedataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMlModelTransformJobsRequest> {
        public Builder maxItems(Integer var1);

        public Builder neptuneIamRoleArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

