/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletePropertygraphStatisticsResponse extends NeptunedataResponse implements
        ToCopyableBuilder<DeletePropertygraphStatisticsResponse.Builder, DeletePropertygraphStatisticsResponse> {
    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("statusCode").getter(getter(DeletePropertygraphStatisticsResponse::statusCode))
            .setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("statusCode").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(DeletePropertygraphStatisticsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<DeleteStatisticsValueMap> PAYLOAD_FIELD = SdkField
            .<DeleteStatisticsValueMap> builder(MarshallingType.SDK_POJO).memberName("payload")
            .getter(getter(DeletePropertygraphStatisticsResponse::payload)).setter(setter(Builder::payload))
            .constructor(DeleteStatisticsValueMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_CODE_FIELD,
            STATUS_FIELD, PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer statusCodeValue;

    private final String status;

    private final DeleteStatisticsValueMap payload;

    private DeletePropertygraphStatisticsResponse(BuilderImpl builder) {
        super(builder);
        this.statusCodeValue = builder.statusCodeValue;
        this.status = builder.status;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to delete.
     * </p>
     * 
     * @return The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to delete.
     */
    public final Integer statusCode() {
        return statusCodeValue;
    }

    /**
     * <p>
     * The cancel status.
     * </p>
     * 
     * @return The cancel status.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The deletion payload.
     * </p>
     * 
     * @return The deletion payload.
     */
    public final DeleteStatisticsValueMap payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletePropertygraphStatisticsResponse)) {
            return false;
        }
        DeletePropertygraphStatisticsResponse other = (DeletePropertygraphStatisticsResponse) obj;
        return Objects.equals(statusCode(), other.statusCode()) && Objects.equals(status(), other.status())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeletePropertygraphStatisticsResponse").add("StatusCode", statusCode()).add("Status", status())
                .add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "statusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("statusCode", STATUS_CODE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeletePropertygraphStatisticsResponse, T> g) {
        return obj -> g.apply((DeletePropertygraphStatisticsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptunedataResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeletePropertygraphStatisticsResponse> {
        /**
         * <p>
         * The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to delete.
         * </p>
         * 
         * @param statusCodeValue
         *        The HTTP response code: 200 if the delete was successful, or 204 if there were no statistics to
         *        delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCodeValue);

        /**
         * <p>
         * The cancel status.
         * </p>
         * 
         * @param status
         *        The cancel status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The deletion payload.
         * </p>
         * 
         * @param payload
         *        The deletion payload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(DeleteStatisticsValueMap payload);

        /**
         * <p>
         * The deletion payload.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteStatisticsValueMap.Builder}
         * avoiding the need to create one manually via {@link DeleteStatisticsValueMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteStatisticsValueMap.Builder#build()} is called immediately
         * and its result is passed to {@link #payload(DeleteStatisticsValueMap)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link DeleteStatisticsValueMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(DeleteStatisticsValueMap)
         */
        default Builder payload(Consumer<DeleteStatisticsValueMap.Builder> payload) {
            return payload(DeleteStatisticsValueMap.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl extends NeptunedataResponse.BuilderImpl implements Builder {
        private Integer statusCodeValue;

        private String status;

        private DeleteStatisticsValueMap payload;

        private BuilderImpl() {
        }

        private BuilderImpl(DeletePropertygraphStatisticsResponse model) {
            super(model);
            statusCode(model.statusCodeValue);
            status(model.status);
            payload(model.payload);
        }

        public final Integer getStatusCode() {
            return statusCodeValue;
        }

        public final void setStatusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
        }

        @Override
        public final Builder statusCode(Integer statusCodeValue) {
            this.statusCodeValue = statusCodeValue;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final DeleteStatisticsValueMap.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(DeleteStatisticsValueMap.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(DeleteStatisticsValueMap payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public DeletePropertygraphStatisticsResponse build() {
            return new DeletePropertygraphStatisticsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
