/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Structure to capture query statistics such as how many queries are running, accepted or waiting and their details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueryEvalStats implements SdkPojo, Serializable, ToCopyableBuilder<QueryEvalStats.Builder, QueryEvalStats> {
    private static final SdkField<Integer> WAITED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("waited").getter(getter(QueryEvalStats::waited)).setter(setter(Builder::waited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waited").build()).build();

    private static final SdkField<Integer> ELAPSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("elapsed").getter(getter(QueryEvalStats::elapsed)).setter(setter(Builder::elapsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsed").build()).build();

    private static final SdkField<Boolean> CANCELLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("cancelled").getter(getter(QueryEvalStats::cancelled)).setter(setter(Builder::cancelled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelled").build()).build();

    private static final SdkField<Document> SUBQUERIES_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("subqueries").getter(getter(QueryEvalStats::subqueries)).setter(setter(Builder::subqueries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subqueries").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WAITED_FIELD, ELAPSED_FIELD,
            CANCELLED_FIELD, SUBQUERIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer waited;

    private final Integer elapsed;

    private final Boolean cancelled;

    private final Document subqueries;

    private QueryEvalStats(BuilderImpl builder) {
        this.waited = builder.waited;
        this.elapsed = builder.elapsed;
        this.cancelled = builder.cancelled;
        this.subqueries = builder.subqueries;
    }

    /**
     * <p>
     * Indicates how long the query waited, in milliseconds.
     * </p>
     * 
     * @return Indicates how long the query waited, in milliseconds.
     */
    public final Integer waited() {
        return waited;
    }

    /**
     * <p>
     * The number of milliseconds the query has been running so far.
     * </p>
     * 
     * @return The number of milliseconds the query has been running so far.
     */
    public final Integer elapsed() {
        return elapsed;
    }

    /**
     * <p>
     * Set to <code>TRUE</code> if the query was cancelled, or FALSE otherwise.
     * </p>
     * 
     * @return Set to <code>TRUE</code> if the query was cancelled, or FALSE otherwise.
     */
    public final Boolean cancelled() {
        return cancelled;
    }

    /**
     * <p>
     * The number of subqueries in this query.
     * </p>
     * 
     * @return The number of subqueries in this query.
     */
    public final Document subqueries() {
        return subqueries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(waited());
        hashCode = 31 * hashCode + Objects.hashCode(elapsed());
        hashCode = 31 * hashCode + Objects.hashCode(cancelled());
        hashCode = 31 * hashCode + Objects.hashCode(subqueries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryEvalStats)) {
            return false;
        }
        QueryEvalStats other = (QueryEvalStats) obj;
        return Objects.equals(waited(), other.waited()) && Objects.equals(elapsed(), other.elapsed())
                && Objects.equals(cancelled(), other.cancelled()) && Objects.equals(subqueries(), other.subqueries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueryEvalStats").add("Waited", waited()).add("Elapsed", elapsed()).add("Cancelled", cancelled())
                .add("Subqueries", subqueries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "waited":
            return Optional.ofNullable(clazz.cast(waited()));
        case "elapsed":
            return Optional.ofNullable(clazz.cast(elapsed()));
        case "cancelled":
            return Optional.ofNullable(clazz.cast(cancelled()));
        case "subqueries":
            return Optional.ofNullable(clazz.cast(subqueries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("waited", WAITED_FIELD);
        map.put("elapsed", ELAPSED_FIELD);
        map.put("cancelled", CANCELLED_FIELD);
        map.put("subqueries", SUBQUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryEvalStats, T> g) {
        return obj -> g.apply((QueryEvalStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueryEvalStats> {
        /**
         * <p>
         * Indicates how long the query waited, in milliseconds.
         * </p>
         * 
         * @param waited
         *        Indicates how long the query waited, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waited(Integer waited);

        /**
         * <p>
         * The number of milliseconds the query has been running so far.
         * </p>
         * 
         * @param elapsed
         *        The number of milliseconds the query has been running so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsed(Integer elapsed);

        /**
         * <p>
         * Set to <code>TRUE</code> if the query was cancelled, or FALSE otherwise.
         * </p>
         * 
         * @param cancelled
         *        Set to <code>TRUE</code> if the query was cancelled, or FALSE otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelled(Boolean cancelled);

        /**
         * <p>
         * The number of subqueries in this query.
         * </p>
         * 
         * @param subqueries
         *        The number of subqueries in this query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subqueries(Document subqueries);
    }

    static final class BuilderImpl implements Builder {
        private Integer waited;

        private Integer elapsed;

        private Boolean cancelled;

        private Document subqueries;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryEvalStats model) {
            waited(model.waited);
            elapsed(model.elapsed);
            cancelled(model.cancelled);
            subqueries(model.subqueries);
        }

        public final Integer getWaited() {
            return waited;
        }

        public final void setWaited(Integer waited) {
            this.waited = waited;
        }

        @Override
        public final Builder waited(Integer waited) {
            this.waited = waited;
            return this;
        }

        public final Integer getElapsed() {
            return elapsed;
        }

        public final void setElapsed(Integer elapsed) {
            this.elapsed = elapsed;
        }

        @Override
        public final Builder elapsed(Integer elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public final Boolean getCancelled() {
            return cancelled;
        }

        public final void setCancelled(Boolean cancelled) {
            this.cancelled = cancelled;
        }

        @Override
        public final Builder cancelled(Boolean cancelled) {
            this.cancelled = cancelled;
            return this;
        }

        public final Document getSubqueries() {
            return subqueries;
        }

        public final void setSubqueries(Document subqueries) {
            this.subqueries = subqueries;
        }

        @Override
        public final Builder subqueries(Document subqueries) {
            this.subqueries = subqueries;
            return this;
        }

        @Override
        public QueryEvalStats build() {
            return new QueryEvalStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
