/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The RDF graph summary API returns a read-only list of classes and predicate keys, along with counts of quads,
 * subjects, and predicates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RDFGraphSummary implements SdkPojo, Serializable, ToCopyableBuilder<RDFGraphSummary.Builder, RDFGraphSummary> {
    private static final SdkField<Long> NUM_DISTINCT_SUBJECTS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numDistinctSubjects").getter(getter(RDFGraphSummary::numDistinctSubjects))
            .setter(setter(Builder::numDistinctSubjects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDistinctSubjects").build())
            .build();

    private static final SdkField<Long> NUM_DISTINCT_PREDICATES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numDistinctPredicates").getter(getter(RDFGraphSummary::numDistinctPredicates))
            .setter(setter(Builder::numDistinctPredicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numDistinctPredicates").build())
            .build();

    private static final SdkField<Long> NUM_QUADS_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("numQuads")
            .getter(getter(RDFGraphSummary::numQuads)).setter(setter(Builder::numQuads))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numQuads").build()).build();

    private static final SdkField<Long> NUM_CLASSES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numClasses").getter(getter(RDFGraphSummary::numClasses)).setter(setter(Builder::numClasses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numClasses").build()).build();

    private static final SdkField<List<String>> CLASSES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("classes")
            .getter(getter(RDFGraphSummary::classes))
            .setter(setter(Builder::classes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("classes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, Long>>> PREDICATES_FIELD = SdkField
            .<List<Map<String, Long>>> builder(MarshallingType.LIST)
            .memberName("predicates")
            .getter(getter(RDFGraphSummary::predicates))
            .setter(setter(Builder::predicates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, Long>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<Long> builder(MarshallingType.LONG)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<List<SubjectStructure>> SUBJECT_STRUCTURES_FIELD = SdkField
            .<List<SubjectStructure>> builder(MarshallingType.LIST)
            .memberName("subjectStructures")
            .getter(getter(RDFGraphSummary::subjectStructures))
            .setter(setter(Builder::subjectStructures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectStructures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SubjectStructure> builder(MarshallingType.SDK_POJO)
                                            .constructor(SubjectStructure::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUM_DISTINCT_SUBJECTS_FIELD,
            NUM_DISTINCT_PREDICATES_FIELD, NUM_QUADS_FIELD, NUM_CLASSES_FIELD, CLASSES_FIELD, PREDICATES_FIELD,
            SUBJECT_STRUCTURES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long numDistinctSubjects;

    private final Long numDistinctPredicates;

    private final Long numQuads;

    private final Long numClasses;

    private final List<String> classes;

    private final List<Map<String, Long>> predicates;

    private final List<SubjectStructure> subjectStructures;

    private RDFGraphSummary(BuilderImpl builder) {
        this.numDistinctSubjects = builder.numDistinctSubjects;
        this.numDistinctPredicates = builder.numDistinctPredicates;
        this.numQuads = builder.numQuads;
        this.numClasses = builder.numClasses;
        this.classes = builder.classes;
        this.predicates = builder.predicates;
        this.subjectStructures = builder.subjectStructures;
    }

    /**
     * <p>
     * The number of distinct subjects in the graph.
     * </p>
     * 
     * @return The number of distinct subjects in the graph.
     */
    public final Long numDistinctSubjects() {
        return numDistinctSubjects;
    }

    /**
     * <p>
     * The number of distinct predicates in the graph.
     * </p>
     * 
     * @return The number of distinct predicates in the graph.
     */
    public final Long numDistinctPredicates() {
        return numDistinctPredicates;
    }

    /**
     * <p>
     * The number of quads in the graph.
     * </p>
     * 
     * @return The number of quads in the graph.
     */
    public final Long numQuads() {
        return numQuads;
    }

    /**
     * <p>
     * The number of classes in the graph.
     * </p>
     * 
     * @return The number of classes in the graph.
     */
    public final Long numClasses() {
        return numClasses;
    }

    /**
     * For responses, this returns true if the service returned a value for the Classes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasClasses() {
        return classes != null && !(classes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the classes in the graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClasses} method.
     * </p>
     * 
     * @return A list of the classes in the graph.
     */
    public final List<String> classes() {
        return classes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Predicates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPredicates() {
        return predicates != null && !(predicates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * "A list of predicates in the graph, along with the predicate counts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPredicates} method.
     * </p>
     * 
     * @return "A list of predicates in the graph, along with the predicate counts.
     */
    public final List<Map<String, Long>> predicates() {
        return predicates;
    }

    /**
     * For responses, this returns true if the service returned a value for the SubjectStructures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSubjectStructures() {
        return subjectStructures != null && !(subjectStructures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject
     * structures.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSubjectStructures} method.
     * </p>
     * 
     * @return This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject
     *         structures.
     */
    public final List<SubjectStructure> subjectStructures() {
        return subjectStructures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numDistinctSubjects());
        hashCode = 31 * hashCode + Objects.hashCode(numDistinctPredicates());
        hashCode = 31 * hashCode + Objects.hashCode(numQuads());
        hashCode = 31 * hashCode + Objects.hashCode(numClasses());
        hashCode = 31 * hashCode + Objects.hashCode(hasClasses() ? classes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPredicates() ? predicates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubjectStructures() ? subjectStructures() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RDFGraphSummary)) {
            return false;
        }
        RDFGraphSummary other = (RDFGraphSummary) obj;
        return Objects.equals(numDistinctSubjects(), other.numDistinctSubjects())
                && Objects.equals(numDistinctPredicates(), other.numDistinctPredicates())
                && Objects.equals(numQuads(), other.numQuads()) && Objects.equals(numClasses(), other.numClasses())
                && hasClasses() == other.hasClasses() && Objects.equals(classes(), other.classes())
                && hasPredicates() == other.hasPredicates() && Objects.equals(predicates(), other.predicates())
                && hasSubjectStructures() == other.hasSubjectStructures()
                && Objects.equals(subjectStructures(), other.subjectStructures());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RDFGraphSummary").add("NumDistinctSubjects", numDistinctSubjects())
                .add("NumDistinctPredicates", numDistinctPredicates()).add("NumQuads", numQuads())
                .add("NumClasses", numClasses()).add("Classes", hasClasses() ? classes() : null)
                .add("Predicates", hasPredicates() ? predicates() : null)
                .add("SubjectStructures", hasSubjectStructures() ? subjectStructures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numDistinctSubjects":
            return Optional.ofNullable(clazz.cast(numDistinctSubjects()));
        case "numDistinctPredicates":
            return Optional.ofNullable(clazz.cast(numDistinctPredicates()));
        case "numQuads":
            return Optional.ofNullable(clazz.cast(numQuads()));
        case "numClasses":
            return Optional.ofNullable(clazz.cast(numClasses()));
        case "classes":
            return Optional.ofNullable(clazz.cast(classes()));
        case "predicates":
            return Optional.ofNullable(clazz.cast(predicates()));
        case "subjectStructures":
            return Optional.ofNullable(clazz.cast(subjectStructures()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numDistinctSubjects", NUM_DISTINCT_SUBJECTS_FIELD);
        map.put("numDistinctPredicates", NUM_DISTINCT_PREDICATES_FIELD);
        map.put("numQuads", NUM_QUADS_FIELD);
        map.put("numClasses", NUM_CLASSES_FIELD);
        map.put("classes", CLASSES_FIELD);
        map.put("predicates", PREDICATES_FIELD);
        map.put("subjectStructures", SUBJECT_STRUCTURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RDFGraphSummary, T> g) {
        return obj -> g.apply((RDFGraphSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RDFGraphSummary> {
        /**
         * <p>
         * The number of distinct subjects in the graph.
         * </p>
         * 
         * @param numDistinctSubjects
         *        The number of distinct subjects in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numDistinctSubjects(Long numDistinctSubjects);

        /**
         * <p>
         * The number of distinct predicates in the graph.
         * </p>
         * 
         * @param numDistinctPredicates
         *        The number of distinct predicates in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numDistinctPredicates(Long numDistinctPredicates);

        /**
         * <p>
         * The number of quads in the graph.
         * </p>
         * 
         * @param numQuads
         *        The number of quads in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numQuads(Long numQuads);

        /**
         * <p>
         * The number of classes in the graph.
         * </p>
         * 
         * @param numClasses
         *        The number of classes in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numClasses(Long numClasses);

        /**
         * <p>
         * A list of the classes in the graph.
         * </p>
         * 
         * @param classes
         *        A list of the classes in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(Collection<String> classes);

        /**
         * <p>
         * A list of the classes in the graph.
         * </p>
         * 
         * @param classes
         *        A list of the classes in the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classes(String... classes);

        /**
         * <p>
         * "A list of predicates in the graph, along with the predicate counts.
         * </p>
         * 
         * @param predicates
         *        "A list of predicates in the graph, along with the predicate counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(Collection<? extends Map<String, Long>> predicates);

        /**
         * <p>
         * "A list of predicates in the graph, along with the predicate counts.
         * </p>
         * 
         * @param predicates
         *        "A list of predicates in the graph, along with the predicate counts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicates(Map<String, Long>... predicates);

        /**
         * <p>
         * This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject
         * structures.
         * </p>
         * 
         * @param subjectStructures
         *        This field is only present when the request mode is <code>DETAILED</code>. It contains a list of
         *        subject structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectStructures(Collection<SubjectStructure> subjectStructures);

        /**
         * <p>
         * This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject
         * structures.
         * </p>
         * 
         * @param subjectStructures
         *        This field is only present when the request mode is <code>DETAILED</code>. It contains a list of
         *        subject structures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectStructures(SubjectStructure... subjectStructures);

        /**
         * <p>
         * This field is only present when the request mode is <code>DETAILED</code>. It contains a list of subject
         * structures.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunedata.model.SubjectStructure.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.neptunedata.model.SubjectStructure#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunedata.model.SubjectStructure.Builder#build()} is called
         * immediately and its result is passed to {@link #subjectStructures(List<SubjectStructure>)}.
         * 
         * @param subjectStructures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunedata.model.SubjectStructure.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectStructures(java.util.Collection<SubjectStructure>)
         */
        Builder subjectStructures(Consumer<SubjectStructure.Builder>... subjectStructures);
    }

    static final class BuilderImpl implements Builder {
        private Long numDistinctSubjects;

        private Long numDistinctPredicates;

        private Long numQuads;

        private Long numClasses;

        private List<String> classes = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, Long>> predicates = DefaultSdkAutoConstructList.getInstance();

        private List<SubjectStructure> subjectStructures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RDFGraphSummary model) {
            numDistinctSubjects(model.numDistinctSubjects);
            numDistinctPredicates(model.numDistinctPredicates);
            numQuads(model.numQuads);
            numClasses(model.numClasses);
            classes(model.classes);
            predicates(model.predicates);
            subjectStructures(model.subjectStructures);
        }

        public final Long getNumDistinctSubjects() {
            return numDistinctSubjects;
        }

        public final void setNumDistinctSubjects(Long numDistinctSubjects) {
            this.numDistinctSubjects = numDistinctSubjects;
        }

        @Override
        public final Builder numDistinctSubjects(Long numDistinctSubjects) {
            this.numDistinctSubjects = numDistinctSubjects;
            return this;
        }

        public final Long getNumDistinctPredicates() {
            return numDistinctPredicates;
        }

        public final void setNumDistinctPredicates(Long numDistinctPredicates) {
            this.numDistinctPredicates = numDistinctPredicates;
        }

        @Override
        public final Builder numDistinctPredicates(Long numDistinctPredicates) {
            this.numDistinctPredicates = numDistinctPredicates;
            return this;
        }

        public final Long getNumQuads() {
            return numQuads;
        }

        public final void setNumQuads(Long numQuads) {
            this.numQuads = numQuads;
        }

        @Override
        public final Builder numQuads(Long numQuads) {
            this.numQuads = numQuads;
            return this;
        }

        public final Long getNumClasses() {
            return numClasses;
        }

        public final void setNumClasses(Long numClasses) {
            this.numClasses = numClasses;
        }

        @Override
        public final Builder numClasses(Long numClasses) {
            this.numClasses = numClasses;
            return this;
        }

        public final Collection<String> getClasses() {
            if (classes instanceof SdkAutoConstructList) {
                return null;
            }
            return classes;
        }

        public final void setClasses(Collection<String> classes) {
            this.classes = ClassesCopier.copy(classes);
        }

        @Override
        public final Builder classes(Collection<String> classes) {
            this.classes = ClassesCopier.copy(classes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder classes(String... classes) {
            classes(Arrays.asList(classes));
            return this;
        }

        public final Collection<? extends Map<String, Long>> getPredicates() {
            if (predicates instanceof SdkAutoConstructList) {
                return null;
            }
            return predicates;
        }

        public final void setPredicates(Collection<? extends Map<String, Long>> predicates) {
            this.predicates = LongValuedMapListCopier.copy(predicates);
        }

        @Override
        public final Builder predicates(Collection<? extends Map<String, Long>> predicates) {
            this.predicates = LongValuedMapListCopier.copy(predicates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder predicates(Map<String, Long>... predicates) {
            predicates(Arrays.asList(predicates));
            return this;
        }

        public final List<SubjectStructure.Builder> getSubjectStructures() {
            List<SubjectStructure.Builder> result = SubjectStructuresCopier.copyToBuilder(this.subjectStructures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubjectStructures(Collection<SubjectStructure.BuilderImpl> subjectStructures) {
            this.subjectStructures = SubjectStructuresCopier.copyFromBuilder(subjectStructures);
        }

        @Override
        public final Builder subjectStructures(Collection<SubjectStructure> subjectStructures) {
            this.subjectStructures = SubjectStructuresCopier.copy(subjectStructures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectStructures(SubjectStructure... subjectStructures) {
            subjectStructures(Arrays.asList(subjectStructures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subjectStructures(Consumer<SubjectStructure.Builder>... subjectStructures) {
            subjectStructures(Stream.of(subjectStructures).map(c -> SubjectStructure.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RDFGraphSummary build() {
            return new RDFGraphSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
