/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the characteristic sets generated in the statistics.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticsSummary.Builder, StatisticsSummary> {
    private static final SdkField<Integer> SIGNATURE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("signatureCount").getter(getter(StatisticsSummary::signatureCount))
            .setter(setter(Builder::signatureCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signatureCount").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("instanceCount").getter(getter(StatisticsSummary::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCount").build()).build();

    private static final SdkField<Integer> PREDICATE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("predicateCount").getter(getter(StatisticsSummary::predicateCount))
            .setter(setter(Builder::predicateCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predicateCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNATURE_COUNT_FIELD,
            INSTANCE_COUNT_FIELD, PREDICATE_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer signatureCount;

    private final Integer instanceCount;

    private final Integer predicateCount;

    private StatisticsSummary(BuilderImpl builder) {
        this.signatureCount = builder.signatureCount;
        this.instanceCount = builder.instanceCount;
        this.predicateCount = builder.predicateCount;
    }

    /**
     * <p>
     * The total number of signatures across all characteristic sets.
     * </p>
     * 
     * @return The total number of signatures across all characteristic sets.
     */
    public final Integer signatureCount() {
        return signatureCount;
    }

    /**
     * <p>
     * The total number of characteristic-set instances.
     * </p>
     * 
     * @return The total number of characteristic-set instances.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * The total number of unique predicates.
     * </p>
     * 
     * @return The total number of unique predicates.
     */
    public final Integer predicateCount() {
        return predicateCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signatureCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(predicateCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticsSummary)) {
            return false;
        }
        StatisticsSummary other = (StatisticsSummary) obj;
        return Objects.equals(signatureCount(), other.signatureCount()) && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(predicateCount(), other.predicateCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticsSummary").add("SignatureCount", signatureCount())
                .add("InstanceCount", instanceCount()).add("PredicateCount", predicateCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signatureCount":
            return Optional.ofNullable(clazz.cast(signatureCount()));
        case "instanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "predicateCount":
            return Optional.ofNullable(clazz.cast(predicateCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signatureCount", SIGNATURE_COUNT_FIELD);
        map.put("instanceCount", INSTANCE_COUNT_FIELD);
        map.put("predicateCount", PREDICATE_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticsSummary, T> g) {
        return obj -> g.apply((StatisticsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticsSummary> {
        /**
         * <p>
         * The total number of signatures across all characteristic sets.
         * </p>
         * 
         * @param signatureCount
         *        The total number of signatures across all characteristic sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signatureCount(Integer signatureCount);

        /**
         * <p>
         * The total number of characteristic-set instances.
         * </p>
         * 
         * @param instanceCount
         *        The total number of characteristic-set instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * The total number of unique predicates.
         * </p>
         * 
         * @param predicateCount
         *        The total number of unique predicates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predicateCount(Integer predicateCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer signatureCount;

        private Integer instanceCount;

        private Integer predicateCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticsSummary model) {
            signatureCount(model.signatureCount);
            instanceCount(model.instanceCount);
            predicateCount(model.predicateCount);
        }

        public final Integer getSignatureCount() {
            return signatureCount;
        }

        public final void setSignatureCount(Integer signatureCount) {
            this.signatureCount = signatureCount;
        }

        @Override
        public final Builder signatureCount(Integer signatureCount) {
            this.signatureCount = signatureCount;
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final Integer getPredicateCount() {
            return predicateCount;
        }

        public final void setPredicateCount(Integer predicateCount) {
            this.predicateCount = predicateCount;
        }

        @Override
        public final Builder predicateCount(Integer predicateCount) {
            this.predicateCount = predicateCount;
            return this;
        }

        @Override
        public StatisticsSummary build() {
            return new StatisticsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
