/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.neptunedata.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.BadRequestException;
import software.amazon.awssdk.services.neptunedata.model.BulkLoadIdNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.CancelledByUserException;
import software.amazon.awssdk.services.neptunedata.model.ClientTimeoutException;
import software.amazon.awssdk.services.neptunedata.model.ConcurrentModificationException;
import software.amazon.awssdk.services.neptunedata.model.ConstraintViolationException;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest;
import software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryResponse;
import software.amazon.awssdk.services.neptunedata.model.ExpiredStreamException;
import software.amazon.awssdk.services.neptunedata.model.FailureByQueryException;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetEngineStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlEndpointResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest;
import software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest;
import software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest;
import software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamResponse;
import software.amazon.awssdk.services.neptunedata.model.IllegalArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InternalFailureException;
import software.amazon.awssdk.services.neptunedata.model.InvalidArgumentException;
import software.amazon.awssdk.services.neptunedata.model.InvalidNumericDataException;
import software.amazon.awssdk.services.neptunedata.model.InvalidParameterException;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest;
import software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsResponse;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest;
import software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesResponse;
import software.amazon.awssdk.services.neptunedata.model.LoadUrlAccessDeniedException;
import software.amazon.awssdk.services.neptunedata.model.MalformedQueryException;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest;
import software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsResponse;
import software.amazon.awssdk.services.neptunedata.model.MemoryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.MethodNotAllowedException;
import software.amazon.awssdk.services.neptunedata.model.MissingParameterException;
import software.amazon.awssdk.services.neptunedata.model.MlResourceNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.NeptunedataException;
import software.amazon.awssdk.services.neptunedata.model.ParsingException;
import software.amazon.awssdk.services.neptunedata.model.PreconditionsFailedException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.QueryLimitException;
import software.amazon.awssdk.services.neptunedata.model.QueryTooLargeException;
import software.amazon.awssdk.services.neptunedata.model.ReadOnlyViolationException;
import software.amazon.awssdk.services.neptunedata.model.S3Exception;
import software.amazon.awssdk.services.neptunedata.model.ServerShutdownException;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartLoaderJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest;
import software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobResponse;
import software.amazon.awssdk.services.neptunedata.model.StatisticsNotAvailableException;
import software.amazon.awssdk.services.neptunedata.model.StreamRecordsNotFoundException;
import software.amazon.awssdk.services.neptunedata.model.ThrottlingException;
import software.amazon.awssdk.services.neptunedata.model.TimeLimitExceededException;
import software.amazon.awssdk.services.neptunedata.model.TooManyRequestsException;
import software.amazon.awssdk.services.neptunedata.model.UnsupportedOperationException;

/**
 * Service client for accessing Amazon NeptuneData. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * <fullname>Neptune Data API</fullname>
 * <p>
 * The Amazon Neptune data API provides SDK support for more than 40 of Neptune's data operations, including data
 * loading, query execution, data inquiry, and machine learning. It supports the Gremlin and openCypher query languages,
 * and is available in all SDK languages. It automatically signs API requests and greatly simplifies integrating Neptune
 * into your applications.
 * </p>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NeptunedataClient extends AwsClient {
    String SERVICE_NAME = "neptune-db";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "neptune-db";

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelGremlinQueryRequest
     * @return Result of the CancelGremlinQuery operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelGremlinQueryResponse cancelGremlinQuery(CancelGremlinQueryRequest cancelGremlinQueryRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException,
            ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException,
            ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException,
            NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Gremlin query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status-cancel.html">Gremlin query
     * cancellation</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelGremlinQueryRequest.Builder} avoiding the
     * need to create one manually via {@link CancelGremlinQueryRequest#builder()}
     * </p>
     *
     * @param cancelGremlinQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelGremlinQueryRequest.Builder} to create a
     *        request.
     * @return Result of the CancelGremlinQuery operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelGremlinQueryResponse cancelGremlinQuery(Consumer<CancelGremlinQueryRequest.Builder> cancelGremlinQueryRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException,
            ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException,
            ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException,
            NeptunedataException {
        return cancelGremlinQuery(CancelGremlinQueryRequest.builder().applyMutation(cancelGremlinQueryRequest).build());
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob"
     * >neptune-db:CancelLoaderJob</a> IAM action in that cluster..
     * </p>
     *
     * @param cancelLoaderJobRequest
     * @return Result of the CancelLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelLoaderJobResponse cancelLoaderJob(CancelLoaderJobRequest cancelLoaderJobRequest) throws BadRequestException,
            InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified load job. This is an HTTP <code>DELETE</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelloaderjob"
     * >neptune-db:CancelLoaderJob</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelLoaderJobRequest.Builder} avoiding the need
     * to create one manually via {@link CancelLoaderJobRequest#builder()}
     * </p>
     *
     * @param cancelLoaderJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelLoaderJobRequest.Builder} to create a
     *        request.
     * @return Result of the CancelLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CancelLoaderJobResponse cancelLoaderJob(Consumer<CancelLoaderJobRequest.Builder> cancelLoaderJobRequest)
            throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException,
            LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return cancelLoaderJob(CancelLoaderJobRequest.builder().applyMutation(cancelLoaderJobRequest).build());
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob"
     * >neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     * @return Result of the CancelMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlDataProcessingJobResponse cancelMLDataProcessingJob(
            CancelMlDataProcessingJobRequest cancelMlDataProcessingJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Neptune ML data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmldataprocessingjob"
     * >neptune-db:CancelMLDataProcessingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlDataProcessingJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param cancelMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlDataProcessingJobRequest.Builder} to
     *        create a request.
     * @return Result of the CancelMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlDataProcessingJobResponse cancelMLDataProcessingJob(
            Consumer<CancelMlDataProcessingJobRequest.Builder> cancelMlDataProcessingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return cancelMLDataProcessingJob(CancelMlDataProcessingJobRequest.builder()
                .applyMutation(cancelMlDataProcessingJobRequest).build());
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob"
     * >neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     * @return Result of the CancelMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlModelTrainingJobResponse cancelMLModelTrainingJob(
            CancelMlModelTrainingJobRequest cancelMlModelTrainingJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltrainingjob"
     * >neptune-db:CancelMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlModelTrainingJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param cancelMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlModelTrainingJobRequest.Builder} to
     *        create a request.
     * @return Result of the CancelMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlModelTrainingJobResponse cancelMLModelTrainingJob(
            Consumer<CancelMlModelTrainingJobRequest.Builder> cancelMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return cancelMLModelTrainingJob(CancelMlModelTrainingJobRequest.builder().applyMutation(cancelMlModelTrainingJobRequest)
                .build());
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob"
     * >neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     * @return Result of the CancelMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlModelTransformJobResponse cancelMLModelTransformJob(
            CancelMlModelTransformJobRequest cancelMlModelTransformJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelmlmodeltransformjob"
     * >neptune-db:CancelMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMlModelTransformJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param cancelMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelMlModelTransformJobRequest.Builder} to
     *        create a request.
     * @return Result of the CancelMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMlModelTransformJobResponse cancelMLModelTransformJob(
            Consumer<CancelMlModelTransformJobRequest.Builder> cancelMlModelTransformJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return cancelMLModelTransformJob(CancelMlModelTransformJobRequest.builder()
                .applyMutation(cancelMlModelTransformJobRequest).build());
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     * @return Result of the CancelOpenCypherQuery operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelOpenCypherQueryResponse cancelOpenCypherQuery(CancelOpenCypherQueryRequest cancelOpenCypherQueryRequest)
            throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#cancelquery"
     * >neptune-db:CancelQuery</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelOpenCypherQueryRequest.Builder} avoiding the
     * need to create one manually via {@link CancelOpenCypherQueryRequest#builder()}
     * </p>
     *
     * @param cancelOpenCypherQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CancelOpenCypherQueryRequest.Builder} to create a
     *        request.
     * @return Result of the CancelOpenCypherQuery operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CancelOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CancelOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelOpenCypherQueryResponse cancelOpenCypherQuery(
            Consumer<CancelOpenCypherQueryRequest.Builder> cancelOpenCypherQueryRequest) throws InvalidNumericDataException,
            BadRequestException, InvalidParameterException, ClientTimeoutException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException,
            ParsingException, ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException,
            ConcurrentModificationException, MissingParameterException, AwsServiceException, SdkClientException,
            NeptunedataException {
        return cancelOpenCypherQuery(CancelOpenCypherQueryRequest.builder().applyMutation(cancelOpenCypherQueryRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint"
     * >neptune-db:CreateMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param createMlEndpointRequest
     * @return Result of the CreateMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMlEndpointResponse createMLEndpoint(CreateMlEndpointRequest createMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML inference endpoint that lets you query one specific model that the model-training
     * process constructed. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#createmlendpoint"
     * >neptune-db:CreateMLEndpoint</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMlEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateMlEndpointRequest#builder()}
     * </p>
     *
     * @param createMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.CreateMlEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.CreateMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/CreateMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMlEndpointResponse createMLEndpoint(Consumer<CreateMlEndpointRequest.Builder> createMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return createMLEndpoint(CreateMlEndpointRequest.builder().applyMutation(createMlEndpointRequest).build());
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint"
     * >neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteMlEndpointRequest
     * @return Result of the DeleteMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMlEndpointResponse deleteMLEndpoint(DeleteMlEndpointRequest deleteMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels the creation of a Neptune ML inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletemlendpoint"
     * >neptune-db:DeleteMLEndpoint</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMlEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteMlEndpointRequest#builder()}
     * </p>
     *
     * @param deleteMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeleteMlEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteMLEndpoint" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMlEndpointResponse deleteMLEndpoint(Consumer<DeleteMlEndpointRequest.Builder> deleteMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return deleteMLEndpoint(DeleteMlEndpointRequest.builder().applyMutation(deleteMlEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     * @return Result of the DeletePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePropertygraphStatisticsResponse deletePropertygraphStatistics(
            DeletePropertygraphStatisticsRequest deletePropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes statistics for Gremlin and openCypher (property graph) data.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePropertygraphStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link DeletePropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param deletePropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeletePropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return Result of the DeletePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeletePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeletePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePropertygraphStatisticsResponse deletePropertygraphStatistics(
            Consumer<DeletePropertygraphStatisticsRequest.Builder> deletePropertygraphStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return deletePropertygraphStatistics(DeletePropertygraphStatisticsRequest.builder()
                .applyMutation(deletePropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     * @return Result of the DeleteSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSparqlStatisticsResponse deleteSparqlStatistics(DeleteSparqlStatisticsRequest deleteSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes SPARQL statistics
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletestatistics"
     * >neptune-db:DeleteStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param deleteSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.DeleteSparqlStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the DeleteSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.DeleteSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/DeleteSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSparqlStatisticsResponse deleteSparqlStatistics(
            Consumer<DeleteSparqlStatisticsRequest.Builder> deleteSparqlStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return deleteSparqlStatistics(DeleteSparqlStatisticsRequest.builder().applyMutation(deleteSparqlStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase"
     * >neptune-db:ResetDatabase</a> IAM action in that cluster.
     * </p>
     *
     * @param executeFastResetRequest
     * @return Result of the ExecuteFastReset operation returned by the service.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws MethodNotAllowedException
     *         Raised when the HTTP method used by a request is not supported by the endpoint being used.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ServerShutdownException
     *         Raised when the server shuts down while processing a request.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    default ExecuteFastResetResponse executeFastReset(ExecuteFastResetRequest executeFastResetRequest)
            throws InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, MethodNotAllowedException, PreconditionsFailedException,
            ServerShutdownException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * The fast reset REST API lets you reset a Neptune graph quicky and easily, removing all of its data.
     * </p>
     * <p>
     * Neptune fast reset is a two-step process. First you call <code>ExecuteFastReset</code> with <code>action</code>
     * set to <code>initiateDatabaseReset</code>. This returns a UUID token which you then include when calling
     * <code>ExecuteFastReset</code> again with <code>action</code> set to <code>performDatabaseReset</code>. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/manage-console-fast-reset.html">Empty an Amazon
     * Neptune DB cluster using the fast reset API</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#resetdatabase"
     * >neptune-db:ResetDatabase</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteFastResetRequest.Builder} avoiding the need
     * to create one manually via {@link ExecuteFastResetRequest#builder()}
     * </p>
     *
     * @param executeFastResetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteFastResetRequest.Builder} to create a
     *        request.
     * @return Result of the ExecuteFastReset operation returned by the service.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws MethodNotAllowedException
     *         Raised when the HTTP method used by a request is not supported by the endpoint being used.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ServerShutdownException
     *         Raised when the server shuts down while processing a request.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteFastReset
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteFastReset" target="_top">AWS
     *      API Documentation</a>
     */
    default ExecuteFastResetResponse executeFastReset(Consumer<ExecuteFastResetRequest.Builder> executeFastResetRequest)
            throws InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, MethodNotAllowedException, PreconditionsFailedException,
            ServerShutdownException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return executeFastReset(ExecuteFastResetRequest.builder().applyMutation(executeFastResetRequest).build());
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     * @return Result of the ExecuteGremlinExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinExplainQueryResponse executeGremlinExplainQuery(
            ExecuteGremlinExplainQueryRequest executeGremlinExplainQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a Gremlin Explain query.
     * </p>
     * <p>
     * Amazon Neptune has added a Gremlin feature named <code>explain</code> that provides is a self-service tool for
     * understanding the execution approach being taken by the Neptune engine for the query. You invoke it by adding an
     * <code>explain</code> parameter to an HTTP call that submits a Gremlin query.
     * </p>
     * <p>
     * The explain feature provides information about the logical structure of query execution plans. You can use this
     * information to identify potential evaluation and execution bottlenecks and to tune your query, as explained in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-traversal-tuning.html">Tuning Gremlin
     * queries</a>. You can also use query hints to improve query execution plans.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinExplainQueryRequest.Builder} avoiding
     * the need to create one manually via {@link ExecuteGremlinExplainQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinExplainQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinExplainQueryRequest.Builder} to
     *        create a request.
     * @return Result of the ExecuteGremlinExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinExplainQueryResponse executeGremlinExplainQuery(
            Consumer<ExecuteGremlinExplainQueryRequest.Builder> executeGremlinExplainQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return executeGremlinExplainQuery(ExecuteGremlinExplainQueryRequest.builder()
                .applyMutation(executeGremlinExplainQueryRequest).build());
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     * @return Result of the ExecuteGremlinProfileQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinProfileQueryResponse executeGremlinProfileQuery(
            ExecuteGremlinProfileQueryRequest executeGremlinProfileQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes a Gremlin Profile query, which runs a specified traversal, collects various metrics about the run, and
     * produces a profile report as output. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-profile-api.html">Gremlin profile API in
     * Neptune</a> for details.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinProfileQueryRequest.Builder} avoiding
     * the need to create one manually via {@link ExecuteGremlinProfileQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinProfileQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinProfileQueryRequest.Builder} to
     *        create a request.
     * @return Result of the ExecuteGremlinProfileQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinProfileQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinProfileQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinProfileQueryResponse executeGremlinProfileQuery(
            Consumer<ExecuteGremlinProfileQueryRequest.Builder> executeGremlinProfileQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return executeGremlinProfileQuery(ExecuteGremlinProfileQueryRequest.builder()
                .applyMutation(executeGremlinProfileQueryRequest).build());
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeGremlinQueryRequest
     * @return Result of the ExecuteGremlinQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinQueryResponse executeGremlinQuery(ExecuteGremlinQueryRequest executeGremlinQueryRequest)
            throws QueryTooLargeException, BadRequestException, QueryLimitExceededException, InvalidParameterException,
            QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException,
            PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * This commands executes a Gremlin query. Amazon Neptune is compatible with Apache TinkerPop3 and Gremlin, so you
     * can use the Gremlin traversal language to query the graph, as described under <a
     * href="https://tinkerpop.apache.org/docs/current/reference/#graph">The Graph</a> in the Apache TinkerPop3
     * documentation. More details can also be found in <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-gremlin.html">Accessing a Neptune graph
     * with Gremlin</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteGremlinQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteGremlinQueryRequest#builder()}
     * </p>
     *
     * @param executeGremlinQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteGremlinQueryRequest.Builder} to create a
     *        request.
     * @return Result of the ExecuteGremlinQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteGremlinQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteGremlinQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteGremlinQueryResponse executeGremlinQuery(
            Consumer<ExecuteGremlinQueryRequest.Builder> executeGremlinQueryRequest) throws QueryTooLargeException,
            BadRequestException, QueryLimitExceededException, InvalidParameterException, QueryLimitException,
            ClientTimeoutException, CancelledByUserException, IllegalArgumentException, TooManyRequestsException,
            UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException, PreconditionsFailedException,
            MalformedQueryException, ParsingException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return executeGremlinQuery(ExecuteGremlinQueryRequest.builder().applyMutation(executeGremlinQueryRequest).build());
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     * @return Result of the ExecuteOpenCypherExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteOpenCypherExplainQueryResponse executeOpenCypherExplainQuery(
            ExecuteOpenCypherExplainQueryRequest executeOpenCypherExplainQueryRequest) throws QueryTooLargeException,
            InvalidNumericDataException, BadRequestException, QueryLimitExceededException, InvalidParameterException,
            QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException,
            PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes an openCypher <code>explain</code> request. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-explain.html">The openCypher
     * explain feature</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery"
     * >neptune-db:ReadDataViaQuery</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteOpenCypherExplainQueryRequest.Builder}
     * avoiding the need to create one manually via {@link ExecuteOpenCypherExplainQueryRequest#builder()}
     * </p>
     *
     * @param executeOpenCypherExplainQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherExplainQueryRequest.Builder} to
     *        create a request.
     * @return Result of the ExecuteOpenCypherExplainQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherExplainQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherExplainQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteOpenCypherExplainQueryResponse executeOpenCypherExplainQuery(
            Consumer<ExecuteOpenCypherExplainQueryRequest.Builder> executeOpenCypherExplainQueryRequest)
            throws QueryTooLargeException, InvalidNumericDataException, BadRequestException, QueryLimitExceededException,
            InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return executeOpenCypherExplainQuery(ExecuteOpenCypherExplainQueryRequest.builder()
                .applyMutation(executeOpenCypherExplainQueryRequest).build());
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     * <p>
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or
     * role making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note also that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     * @return Result of the ExecuteOpenCypherQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteOpenCypherQueryResponse executeOpenCypherQuery(ExecuteOpenCypherQueryRequest executeOpenCypherQueryRequest)
            throws QueryTooLargeException, InvalidNumericDataException, BadRequestException, QueryLimitExceededException,
            InvalidParameterException, QueryLimitException, ClientTimeoutException, CancelledByUserException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            MemoryLimitExceededException, PreconditionsFailedException, MalformedQueryException, ParsingException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Executes an openCypher query. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher.html">Accessing the Neptune
     * Graph with openCypher</a> for more information.
     * </p>
     * <p>
     * Neptune supports building graph applications using openCypher, which is currently one of the most popular query
     * languages among developers working with graph databases. Developers, business analysts, and data scientists like
     * openCypher's declarative, SQL-inspired syntax because it provides a familiar structure in which to querying
     * property graphs.
     * </p>
     * <p>
     * The openCypher language was originally developed by Neo4j, then open-sourced in 2015 and contributed to the <a
     * href="https://opencypher.org/">openCypher project</a> under an Apache 2 open-source license.
     * </p>
     * <p>
     * Note that when invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or
     * role making the request must have a policy attached that allows one of the following IAM actions in that cluster,
     * depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#readdataviaquery">neptune-db:
     * ReadDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#writedataviaquery">neptune-db:
     * WriteDataViaQuery</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#deletedataviaquery">neptune-db:
     * DeleteDataViaQuery</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Note also that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteOpenCypherQueryRequest.Builder} avoiding the
     * need to create one manually via {@link ExecuteOpenCypherQueryRequest#builder()}
     * </p>
     *
     * @param executeOpenCypherQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ExecuteOpenCypherQueryRequest.Builder} to create
     *        a request.
     * @return Result of the ExecuteOpenCypherQuery operation returned by the service.
     * @throws QueryTooLargeException
     *         Raised when the body of a query is too large.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws QueryLimitExceededException
     *         Raised when the number of active queries exceeds what the server can process. The query in question can
     *         be retried when the system is less busy.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws QueryLimitException
     *         Raised when the size of a query exceeds the system limit.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws CancelledByUserException
     *         Raised when a user cancelled a request.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws MalformedQueryException
     *         Raised when a query is submitted that is syntactically incorrect or does not pass additional validation.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ExecuteOpenCypherQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ExecuteOpenCypherQuery"
     *      target="_top">AWS API Documentation</a>
     */
    default ExecuteOpenCypherQueryResponse executeOpenCypherQuery(
            Consumer<ExecuteOpenCypherQueryRequest.Builder> executeOpenCypherQueryRequest) throws QueryTooLargeException,
            InvalidNumericDataException, BadRequestException, QueryLimitExceededException, InvalidParameterException,
            QueryLimitException, ClientTimeoutException, CancelledByUserException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, MemoryLimitExceededException,
            PreconditionsFailedException, MalformedQueryException, ParsingException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return executeOpenCypherQuery(ExecuteOpenCypherQueryRequest.builder().applyMutation(executeOpenCypherQueryRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of the graph database on the host.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus"
     * >neptune-db:GetEngineStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getEngineStatusRequest
     * @return Result of the GetEngineStatus operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEngineStatusResponse getEngineStatus(GetEngineStatusRequest getEngineStatusRequest)
            throws UnsupportedOperationException, InternalFailureException, ClientTimeoutException, PreconditionsFailedException,
            ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of the graph database on the host.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getenginestatus"
     * >neptune-db:GetEngineStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEngineStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetEngineStatusRequest#builder()}
     * </p>
     *
     * @param getEngineStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetEngineStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetEngineStatus operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetEngineStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetEngineStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetEngineStatusResponse getEngineStatus(Consumer<GetEngineStatusRequest.Builder> getEngineStatusRequest)
            throws UnsupportedOperationException, InternalFailureException, ClientTimeoutException, PreconditionsFailedException,
            ConstraintViolationException, InvalidArgumentException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return getEngineStatus(GetEngineStatusRequest.builder().applyMutation(getEngineStatusRequest).build());
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     * @return Result of the GetGremlinQueryStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGremlinQueryStatusResponse getGremlinQueryStatus(GetGremlinQueryStatusRequest getGremlinQueryStatusRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a specified Gremlin query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGremlinQueryStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetGremlinQueryStatusRequest#builder()}
     * </p>
     *
     * @param getGremlinQueryStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetGremlinQueryStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetGremlinQueryStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetGremlinQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetGremlinQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGremlinQueryStatusResponse getGremlinQueryStatus(
            Consumer<GetGremlinQueryStatusRequest.Builder> getGremlinQueryStatusRequest) throws BadRequestException,
            InvalidParameterException, ClientTimeoutException, AccessDeniedException, IllegalArgumentException,
            TooManyRequestsException, UnsupportedOperationException, FailureByQueryException, PreconditionsFailedException,
            ParsingException, ReadOnlyViolationException, ConstraintViolationException, TimeLimitExceededException,
            InvalidArgumentException, ConcurrentModificationException, MissingParameterException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return getGremlinQueryStatus(GetGremlinQueryStatusRequest.builder().applyMutation(getGremlinQueryStatusRequest).build());
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus"
     * >neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..
     * </p>
     *
     * @param getLoaderJobStatusRequest
     * @return Result of the GetLoaderJobStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoaderJobStatusResponse getLoaderJobStatus(GetLoaderJobStatusRequest getLoaderJobStatusRequest)
            throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException,
            LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets status information about a specified load job. Neptune keeps track of the most recent 1,024 bulk load jobs,
     * and stores the last 10,000 error details per job.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/load-api-reference-status.htm">Neptune Loader
     * Get-Status API</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getloaderjobstatus"
     * >neptune-db:GetLoaderJobStatus</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLoaderJobStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetLoaderJobStatusRequest#builder()}
     * </p>
     *
     * @param getLoaderJobStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetLoaderJobStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetLoaderJobStatus operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetLoaderJobStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetLoaderJobStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetLoaderJobStatusResponse getLoaderJobStatus(Consumer<GetLoaderJobStatusRequest.Builder> getLoaderJobStatusRequest)
            throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException,
            LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            InternalFailureException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return getLoaderJobStatus(GetLoaderJobStatusRequest.builder().applyMutation(getLoaderJobStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus"
     * >neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     * @return Result of the GetMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlDataProcessingJobResponse getMLDataProcessingJob(GetMlDataProcessingJobRequest getMlDataProcessingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified data processing job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmldataprocessingjobstatus"
     * >neptune-db:neptune-db:GetMLDataProcessingJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlDataProcessingJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param getMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlDataProcessingJobRequest.Builder} to create
     *        a request.
     * @return Result of the GetMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlDataProcessingJobResponse getMLDataProcessingJob(
            Consumer<GetMlDataProcessingJobRequest.Builder> getMlDataProcessingJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        return getMLDataProcessingJob(GetMlDataProcessingJobRequest.builder().applyMutation(getMlDataProcessingJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus"
     * >neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlEndpointRequest
     * @return Result of the GetMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlEndpointResponse getMLEndpoint(GetMlEndpointRequest getMlEndpointRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an inference endpoint. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlendpointstatus"
     * >neptune-db:GetMLEndpointStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlEndpointRequest.Builder} avoiding the need to
     * create one manually via {@link GetMlEndpointRequest#builder()}
     * </p>
     *
     * @param getMlEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlEndpointRequest.Builder} to create a
     *        request.
     * @return Result of the GetMLEndpoint operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLEndpoint" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMlEndpointResponse getMLEndpoint(Consumer<GetMlEndpointRequest.Builder> getMlEndpointRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return getMLEndpoint(GetMlEndpointRequest.builder().applyMutation(getMlEndpointRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus"
     * >neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     * @return Result of the GetMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlModelTrainingJobResponse getMLModelTrainingJob(GetMlModelTrainingJobRequest getMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltrainingjobstatus"
     * >neptune-db:GetMLModelTrainingJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlModelTrainingJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param getMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlModelTrainingJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlModelTrainingJobResponse getMLModelTrainingJob(
            Consumer<GetMlModelTrainingJobRequest.Builder> getMlModelTrainingJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        return getMLModelTrainingJob(GetMlModelTrainingJobRequest.builder().applyMutation(getMlModelTrainingJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus"
     * >neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getMlModelTransformJobRequest
     * @return Result of the GetMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlModelTransformJobResponse getMLModelTransformJob(GetMlModelTransformJobRequest getMlModelTransformJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getmlmodeltransformjobstatus"
     * >neptune-db:GetMLModelTransformJobStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMlModelTransformJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param getMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetMlModelTransformJobRequest.Builder} to create
     *        a request.
     * @return Result of the GetMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMlModelTransformJobResponse getMLModelTransformJob(
            Consumer<GetMlModelTransformJobRequest.Builder> getMlModelTransformJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        return getMLModelTransformJob(GetMlModelTransformJobRequest.builder().applyMutation(getMlModelTransformJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     * @return Result of the GetOpenCypherQueryStatus operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOpenCypherQueryStatusResponse getOpenCypherQueryStatus(
            GetOpenCypherQueryStatusRequest getOpenCypherQueryStatusRequest) throws InvalidNumericDataException,
            BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a specified openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpenCypherQueryStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetOpenCypherQueryStatusRequest#builder()}
     * </p>
     *
     * @param getOpenCypherQueryStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetOpenCypherQueryStatusRequest.Builder} to
     *        create a request.
     * @return Result of the GetOpenCypherQueryStatus operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetOpenCypherQueryStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetOpenCypherQueryStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOpenCypherQueryStatusResponse getOpenCypherQueryStatus(
            Consumer<GetOpenCypherQueryStatusRequest.Builder> getOpenCypherQueryStatusRequest)
            throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return getOpenCypherQueryStatus(GetOpenCypherQueryStatusRequest.builder().applyMutation(getOpenCypherQueryStatusRequest)
                .build());
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus"
     * >neptune-db:GetStatisticsStatus</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     * @return Result of the GetPropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphStatisticsResponse getPropertygraphStatistics(
            GetPropertygraphStatisticsRequest getPropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets property graph statistics (Gremlin and openCypher).
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstatisticsstatus"
     * >neptune-db:GetStatisticsStatus</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphStatisticsRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param getPropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return Result of the GetPropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphStatisticsResponse getPropertygraphStatistics(
            Consumer<GetPropertygraphStatisticsRequest.Builder> getPropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return getPropertygraphStatistics(GetPropertygraphStatisticsRequest.builder()
                .applyMutation(getPropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions, depending on the
     * query:
     * </p>
     * <p>
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys
     * available in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getPropertygraphStreamRequest
     * @return Result of the GetPropertygraphStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphStreamResponse getPropertygraphStream(GetPropertygraphStreamRequest getPropertygraphStreamRequest)
            throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException,
            MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException,
            ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException,
            TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a stream for a property graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetPropertygraphStream</code> lets you collect these
     * change-log entries for a property graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that enables one of the following IAM actions, depending on the
     * query:
     * </p>
     * <p>
     * Note that you can restrict property-graph queries using the following IAM context keys:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys
     * available in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphStreamRequest.Builder} avoiding the
     * need to create one manually via {@link GetPropertygraphStreamRequest#builder()}
     * </p>
     *
     * @param getPropertygraphStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphStreamRequest.Builder} to create
     *        a request.
     * @return Result of the GetPropertygraphStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphStreamResponse getPropertygraphStream(
            Consumer<GetPropertygraphStreamRequest.Builder> getPropertygraphStreamRequest) throws UnsupportedOperationException,
            ExpiredStreamException, InvalidParameterException, MemoryLimitExceededException, StreamRecordsNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ThrottlingException, ConstraintViolationException,
            InvalidArgumentException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return getPropertygraphStream(GetPropertygraphStreamRequest.builder().applyMutation(getPropertygraphStreamRequest)
                .build());
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     * @return Result of the GetPropertygraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphSummaryResponse getPropertygraphSummary(GetPropertygraphSummaryRequest getPropertygraphSummaryRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPropertygraphSummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetPropertygraphSummaryRequest#builder()}
     * </p>
     *
     * @param getPropertygraphSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetPropertygraphSummaryRequest.Builder} to create
     *        a request.
     * @return Result of the GetPropertygraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetPropertygraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetPropertygraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPropertygraphSummaryResponse getPropertygraphSummary(
            Consumer<GetPropertygraphSummaryRequest.Builder> getPropertygraphSummaryRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return getPropertygraphSummary(GetPropertygraphSummaryRequest.builder().applyMutation(getPropertygraphSummaryRequest)
                .build());
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     * @return Result of the GetRDFGraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRdfGraphSummaryResponse getRDFGraphSummary(GetRdfGraphSummaryRequest getRdfGraphSummaryRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a graph summary for an RDF graph.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getgraphsummary"
     * >neptune-db:GetGraphSummary</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRdfGraphSummaryRequest.Builder} avoiding the
     * need to create one manually via {@link GetRdfGraphSummaryRequest#builder()}
     * </p>
     *
     * @param getRdfGraphSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetRdfGraphSummaryRequest.Builder} to create a
     *        request.
     * @return Result of the GetRDFGraphSummary operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetRDFGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetRDFGraphSummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRdfGraphSummaryResponse getRDFGraphSummary(Consumer<GetRdfGraphSummaryRequest.Builder> getRdfGraphSummaryRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return getRDFGraphSummary(GetRdfGraphSummaryRequest.builder().applyMutation(getRdfGraphSummaryRequest).build());
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     *
     * @param getSparqlStatisticsRequest
     * @return Result of the GetSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSparqlStatisticsResponse getSparqlStatistics(GetSparqlStatisticsRequest getSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets RDF statistics (SPARQL).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link GetSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param getSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetSparqlStatisticsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSparqlStatisticsResponse getSparqlStatistics(
            Consumer<GetSparqlStatisticsRequest.Builder> getSparqlStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return getSparqlStatistics(GetSparqlStatisticsRequest.builder().applyMutation(getSparqlStatisticsRequest).build());
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of
     * SPARQL queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param getSparqlStreamRequest
     * @return Result of the GetSparqlStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSparqlStreamResponse getSparqlStream(GetSparqlStreamRequest getSparqlStreamRequest)
            throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException,
            MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException,
            ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException,
            TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a stream for an RDF graph.
     * </p>
     * <p>
     * With the Neptune Streams feature, you can generate a complete sequence of change-log entries that record every
     * change made to your graph data as it happens. <code>GetSparqlStream</code> lets you collect these change-log
     * entries for an RDF graph.
     * </p>
     * <p>
     * The Neptune streams feature needs to be enabled on your Neptune DBcluster. To enable streams, set the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/parameters.html#parameters-db-cluster-parameters-neptune_streams"
     * >neptune_streams</a> DB cluster parameter to <code>1</code>.
     * </p>
     * <p>
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/streams.html">Capturing graph changes in real
     * time using Neptune streams</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getstreamrecords"
     * >neptune-db:GetStreamRecords</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Sparql</a> IAM condition key can be used in the policy document to restrict the use of
     * SPARQL queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSparqlStreamRequest.Builder} avoiding the need
     * to create one manually via {@link GetSparqlStreamRequest#builder()}
     * </p>
     *
     * @param getSparqlStreamRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.GetSparqlStreamRequest.Builder} to create a
     *        request.
     * @return Result of the GetSparqlStream operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws ExpiredStreamException
     *         Raised when a request attempts to access an stream that has expired.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MemoryLimitExceededException
     *         Raised when a request fails because of insufficient memory resources. The request can be retried.
     * @throws StreamRecordsNotFoundException
     *         Raised when stream records requested by a query cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ThrottlingException
     *         Raised when the rate of requests exceeds the maximum throughput. Requests can be retried after
     *         encountering this exception.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.GetSparqlStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/GetSparqlStream" target="_top">AWS
     *      API Documentation</a>
     */
    default GetSparqlStreamResponse getSparqlStream(Consumer<GetSparqlStreamRequest.Builder> getSparqlStreamRequest)
            throws UnsupportedOperationException, ExpiredStreamException, InvalidParameterException,
            MemoryLimitExceededException, StreamRecordsNotFoundException, ClientTimeoutException, PreconditionsFailedException,
            ThrottlingException, ConstraintViolationException, InvalidArgumentException, IllegalArgumentException,
            TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        return getSparqlStream(GetSparqlStreamRequest.builder().applyMutation(getSparqlStreamRequest).build());
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listGremlinQueriesRequest
     * @return Result of the ListGremlinQueries operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGremlinQueriesResponse listGremlinQueries(ListGremlinQueriesRequest listGremlinQueriesRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists active Gremlin queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/gremlin-api-status.html">Gremlin query status API</a>
     * for details about the output.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:Gremlin</a> IAM condition key can be used in the policy document to restrict the use of
     * Gremlin queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGremlinQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListGremlinQueriesRequest#builder()}
     * </p>
     *
     * @param listGremlinQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListGremlinQueriesRequest.Builder} to create a
     *        request.
     * @return Result of the ListGremlinQueries operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListGremlinQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListGremlinQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGremlinQueriesResponse listGremlinQueries(Consumer<ListGremlinQueriesRequest.Builder> listGremlinQueriesRequest)
            throws BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return listGremlinQueries(ListGremlinQueriesRequest.builder().applyMutation(listGremlinQueriesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs"
     * >neptune-db:ListLoaderJobs</a> IAM action in that cluster..
     * </p>
     *
     * @param listLoaderJobsRequest
     * @return Result of the ListLoaderJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLoaderJobsResponse listLoaderJobs(ListLoaderJobsRequest listLoaderJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException,
            InternalFailureException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException,
            InvalidArgumentException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of the <code>loadIds</code> for all active loader jobs.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listloaderjobs"
     * >neptune-db:ListLoaderJobs</a> IAM action in that cluster..
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLoaderJobsRequest.Builder} avoiding the need to
     * create one manually via {@link ListLoaderJobsRequest#builder()}
     * </p>
     *
     * @param listLoaderJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListLoaderJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListLoaderJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListLoaderJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListLoaderJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListLoaderJobsResponse listLoaderJobs(Consumer<ListLoaderJobsRequest.Builder> listLoaderJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException,
            InternalFailureException, ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException,
            InvalidArgumentException, LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return listLoaderJobs(ListLoaderJobsRequest.builder().applyMutation(listLoaderJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs"
     * >neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     * @return Result of the ListMLDataProcessingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlDataProcessingJobsResponse listMLDataProcessingJobs(
            ListMlDataProcessingJobsRequest listMlDataProcessingJobsRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Neptune ML data processing jobs. See <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html#machine-learning-api-dataprocessing-list-jobs"
     * >Listing active data-processing jobs using the Neptune ML dataprocessing command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmldataprocessingjobs"
     * >neptune-db:ListMLDataProcessingJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlDataProcessingJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlDataProcessingJobsRequest#builder()}
     * </p>
     *
     * @param listMlDataProcessingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlDataProcessingJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListMLDataProcessingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLDataProcessingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLDataProcessingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlDataProcessingJobsResponse listMLDataProcessingJobs(
            Consumer<ListMlDataProcessingJobsRequest.Builder> listMlDataProcessingJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return listMLDataProcessingJobs(ListMlDataProcessingJobsRequest.builder().applyMutation(listMlDataProcessingJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints"
     * >neptune-db:ListMLEndpoints</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlEndpointsRequest
     * @return Result of the ListMLEndpoints operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMlEndpointsResponse listMLEndpoints(ListMlEndpointsRequest listMlEndpointsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists existing inference endpoints. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-endpoints.html">Managing
     * inference endpoints using the endpoints command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlendpoints"
     * >neptune-db:ListMLEndpoints</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListMlEndpointsRequest#builder()}
     * </p>
     *
     * @param listMlEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlEndpointsRequest.Builder} to create a
     *        request.
     * @return Result of the ListMLEndpoints operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLEndpoints" target="_top">AWS
     *      API Documentation</a>
     */
    default ListMlEndpointsResponse listMLEndpoints(Consumer<ListMlEndpointsRequest.Builder> listMlEndpointsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return listMLEndpoints(ListMlEndpointsRequest.builder().applyMutation(listMlEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs"
     * >neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     * @return Result of the ListMLModelTrainingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlModelTrainingJobsResponse listMLModelTrainingJobs(ListMlModelTrainingJobsRequest listMlModelTrainingJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists Neptune ML model-training jobs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#neptune-db:listmlmodeltrainingjobs"
     * >neptune-db:neptune-db:ListMLModelTrainingJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlModelTrainingJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlModelTrainingJobsRequest#builder()}
     * </p>
     *
     * @param listMlModelTrainingJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlModelTrainingJobsRequest.Builder} to create
     *        a request.
     * @return Result of the ListMLModelTrainingJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTrainingJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTrainingJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlModelTrainingJobsResponse listMLModelTrainingJobs(
            Consumer<ListMlModelTrainingJobsRequest.Builder> listMlModelTrainingJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return listMLModelTrainingJobs(ListMlModelTrainingJobsRequest.builder().applyMutation(listMlModelTrainingJobsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs"
     * >neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     * @return Result of the ListMLModelTransformJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlModelTransformJobsResponse listMLModelTransformJobs(
            ListMlModelTransformJobsRequest listMlModelTransformJobsRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of model transform job IDs. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#listmlmodeltransformjobs"
     * >neptune-db:ListMLModelTransformJobs</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMlModelTransformJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListMlModelTransformJobsRequest#builder()}
     * </p>
     *
     * @param listMlModelTransformJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListMlModelTransformJobsRequest.Builder} to
     *        create a request.
     * @return Result of the ListMLModelTransformJobs operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListMLModelTransformJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListMLModelTransformJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMlModelTransformJobsResponse listMLModelTransformJobs(
            Consumer<ListMlModelTransformJobsRequest.Builder> listMlModelTransformJobsRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return listMLModelTransformJobs(ListMlModelTransformJobsRequest.builder().applyMutation(listMlModelTransformJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     * @return Result of the ListOpenCypherQueries operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenCypherQueriesResponse listOpenCypherQueries(ListOpenCypherQueriesRequest listOpenCypherQueriesRequest)
            throws InvalidNumericDataException, BadRequestException, InvalidParameterException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            FailureByQueryException, PreconditionsFailedException, ParsingException, ReadOnlyViolationException,
            ConstraintViolationException, TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists active openCypher queries. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/access-graph-opencypher-status.html">Neptune
     * openCypher status endpoint</a> for more information.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#getquerystatus"
     * >neptune-db:GetQueryStatus</a> IAM action in that cluster.
     * </p>
     * <p>
     * Note that the <a href=
     * "https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html#iam-neptune-condition-keys"
     * >neptune-db:QueryLanguage:OpenCypher</a> IAM condition key can be used in the policy document to restrict the use
     * of openCypher queries (see <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-data-condition-keys.html">Condition keys available
     * in Neptune IAM data-access policy statements</a>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpenCypherQueriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListOpenCypherQueriesRequest#builder()}
     * </p>
     *
     * @param listOpenCypherQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ListOpenCypherQueriesRequest.Builder} to create a
     *        request.
     * @return Result of the ListOpenCypherQueries operation returned by the service.
     * @throws InvalidNumericDataException
     *         Raised when invalid numerical data is encountered when servicing a request.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws FailureByQueryException
     *         Raised when a request fails.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ParsingException
     *         Raised when a parsing issue is encountered.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws TimeLimitExceededException
     *         Raised when the an operation exceeds the time limit allowed for it.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws ConcurrentModificationException
     *         Raised when a request attempts to modify data that is concurrently being modified by another process.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ListOpenCypherQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ListOpenCypherQueries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpenCypherQueriesResponse listOpenCypherQueries(
            Consumer<ListOpenCypherQueriesRequest.Builder> listOpenCypherQueriesRequest) throws InvalidNumericDataException,
            BadRequestException, InvalidParameterException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, FailureByQueryException,
            PreconditionsFailedException, ParsingException, ReadOnlyViolationException, ConstraintViolationException,
            TimeLimitExceededException, InvalidArgumentException, ConcurrentModificationException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return listOpenCypherQueries(ListOpenCypherQueriesRequest.builder().applyMutation(listOpenCypherQueriesRequest).build());
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     * @return Result of the ManagePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ManagePropertygraphStatisticsResponse managePropertygraphStatistics(
            ManagePropertygraphStatisticsRequest managePropertygraphStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Manages the generation and use of property graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ManagePropertygraphStatisticsRequest.Builder}
     * avoiding the need to create one manually via {@link ManagePropertygraphStatisticsRequest#builder()}
     * </p>
     *
     * @param managePropertygraphStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ManagePropertygraphStatisticsRequest.Builder} to
     *        create a request.
     * @return Result of the ManagePropertygraphStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManagePropertygraphStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManagePropertygraphStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ManagePropertygraphStatisticsResponse managePropertygraphStatistics(
            Consumer<ManagePropertygraphStatisticsRequest.Builder> managePropertygraphStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return managePropertygraphStatistics(ManagePropertygraphStatisticsRequest.builder()
                .applyMutation(managePropertygraphStatisticsRequest).build());
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     * @return Result of the ManageSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ManageSparqlStatisticsResponse manageSparqlStatistics(ManageSparqlStatisticsRequest manageSparqlStatisticsRequest)
            throws BadRequestException, InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException,
            AccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            PreconditionsFailedException, ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Manages the generation and use of RDF graph statistics.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#managestatistics"
     * >neptune-db:ManageStatistics</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ManageSparqlStatisticsRequest.Builder} avoiding the
     * need to create one manually via {@link ManageSparqlStatisticsRequest#builder()}
     * </p>
     *
     * @param manageSparqlStatisticsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.ManageSparqlStatisticsRequest.Builder} to create
     *        a request.
     * @return Result of the ManageSparqlStatistics operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws StatisticsNotAvailableException
     *         Raised when statistics needed to satisfy a request are not available.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ReadOnlyViolationException
     *         Raised when a request attempts to write to a read-only resource.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.ManageSparqlStatistics
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/ManageSparqlStatistics"
     *      target="_top">AWS API Documentation</a>
     */
    default ManageSparqlStatisticsResponse manageSparqlStatistics(
            Consumer<ManageSparqlStatisticsRequest.Builder> manageSparqlStatisticsRequest) throws BadRequestException,
            InvalidParameterException, StatisticsNotAvailableException, ClientTimeoutException, AccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, PreconditionsFailedException,
            ReadOnlyViolationException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            AwsServiceException, SdkClientException, NeptunedataException {
        return manageSparqlStatistics(ManageSparqlStatisticsRequest.builder().applyMutation(manageSparqlStatisticsRequest)
                .build());
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob"
     * >neptune-db:StartLoaderJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startLoaderJobRequest
     * @return Result of the StartLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws S3Exception
     *         Raised when there is a problem accessing Amazon S3.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StartLoaderJobResponse startLoaderJob(StartLoaderJobRequest startLoaderJobRequest) throws BadRequestException,
            InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException, LoadUrlAccessDeniedException,
            IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException, InternalFailureException,
            PreconditionsFailedException, S3Exception, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a Neptune bulk loader job to load data from an Amazon S3 bucket into a Neptune DB instance. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load.html">Using the Amazon Neptune Bulk Loader
     * to Ingest Data</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startloaderjob"
     * >neptune-db:StartLoaderJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartLoaderJobRequest.Builder} avoiding the need to
     * create one manually via {@link StartLoaderJobRequest#builder()}
     * </p>
     *
     * @param startLoaderJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartLoaderJobRequest.Builder} to create a
     *        request.
     * @return Result of the StartLoaderJob operation returned by the service.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws BulkLoadIdNotFoundException
     *         Raised when a specified bulk-load job ID cannot be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws LoadUrlAccessDeniedException
     *         Raised when access is denied to a specified load URL.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws InternalFailureException
     *         Raised when the processing of the request failed unexpectedly.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws S3Exception
     *         Raised when there is a problem accessing Amazon S3.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartLoaderJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartLoaderJob" target="_top">AWS
     *      API Documentation</a>
     */
    default StartLoaderJobResponse startLoaderJob(Consumer<StartLoaderJobRequest.Builder> startLoaderJobRequest)
            throws BadRequestException, InvalidParameterException, BulkLoadIdNotFoundException, ClientTimeoutException,
            LoadUrlAccessDeniedException, IllegalArgumentException, TooManyRequestsException, UnsupportedOperationException,
            InternalFailureException, PreconditionsFailedException, S3Exception, ConstraintViolationException,
            InvalidArgumentException, MissingParameterException, AwsServiceException, SdkClientException, NeptunedataException {
        return startLoaderJob(StartLoaderJobRequest.builder().applyMutation(startLoaderJobRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob"
     * >neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     * @return Result of the StartMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlDataProcessingJobResponse startMLDataProcessingJob(
            StartMlDataProcessingJobRequest startMlDataProcessingJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML data processing job for processing the graph data exported from Neptune for training.
     * See <a href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-dataprocessing.html">The
     * <code>dataprocessing</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeldataprocessingjob"
     * >neptune-db:StartMLModelDataProcessingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlDataProcessingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlDataProcessingJobRequest#builder()}
     * </p>
     *
     * @param startMlDataProcessingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlDataProcessingJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartMLDataProcessingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLDataProcessingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLDataProcessingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlDataProcessingJobResponse startMLDataProcessingJob(
            Consumer<StartMlDataProcessingJobRequest.Builder> startMlDataProcessingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return startMLDataProcessingJob(StartMlDataProcessingJobRequest.builder().applyMutation(startMlDataProcessingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob"
     * >neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     * @return Result of the StartMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlModelTrainingJobResponse startMLModelTrainingJob(StartMlModelTrainingJobRequest startMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune ML model training job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-api-modeltraining.html">Model
     * training using the <code>modeltraining</code> command</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltrainingjob"
     * >neptune-db:StartMLModelTrainingJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlModelTrainingJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlModelTrainingJobRequest#builder()}
     * </p>
     *
     * @param startMlModelTrainingJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlModelTrainingJobRequest.Builder} to create
     *        a request.
     * @return Result of the StartMLModelTrainingJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTrainingJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTrainingJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlModelTrainingJobResponse startMLModelTrainingJob(
            Consumer<StartMlModelTrainingJobRequest.Builder> startMlModelTrainingJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return startMLModelTrainingJob(StartMlModelTrainingJobRequest.builder().applyMutation(startMlModelTrainingJobRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob"
     * >neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     *
     * @param startMlModelTransformJobRequest
     * @return Result of the StartMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlModelTransformJobResponse startMLModelTransformJob(
            StartMlModelTransformJobRequest startMlModelTransformJobRequest) throws UnsupportedOperationException,
            BadRequestException, InvalidParameterException, MlResourceNotFoundException, ClientTimeoutException,
            PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException, MissingParameterException,
            IllegalArgumentException, TooManyRequestsException, AwsServiceException, SdkClientException, NeptunedataException {
        throw new java.lang.UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new model transform job. See <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/machine-learning-model-transform.html">Use a trained
     * model to generate new model artifacts</a>.
     * </p>
     * <p>
     * When invoking this operation in a Neptune cluster that has IAM authentication enabled, the IAM user or role
     * making the request must have a policy attached that allows the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/iam-dp-actions.html#startmlmodeltransformjob"
     * >neptune-db:StartMLModelTransformJob</a> IAM action in that cluster.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartMlModelTransformJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartMlModelTransformJobRequest#builder()}
     * </p>
     *
     * @param startMlModelTransformJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunedata.model.StartMlModelTransformJobRequest.Builder} to
     *        create a request.
     * @return Result of the StartMLModelTransformJob operation returned by the service.
     * @throws UnsupportedOperationException
     *         Raised when a request attempts to initiate an operation that is not supported.
     * @throws BadRequestException
     *         Raised when a request is submitted that cannot be processed.
     * @throws InvalidParameterException
     *         Raised when a parameter value is not valid.
     * @throws MlResourceNotFoundException
     *         Raised when a specified machine-learning resource could not be found.
     * @throws ClientTimeoutException
     *         Raised when a request timed out in the client.
     * @throws PreconditionsFailedException
     *         Raised when a precondition for processing a request is not satisfied.
     * @throws ConstraintViolationException
     *         Raised when a value in a request field did not satisfy required constraints.
     * @throws InvalidArgumentException
     *         Raised when an argument in a request has an invalid value.
     * @throws MissingParameterException
     *         Raised when a required parameter is missing.
     * @throws IllegalArgumentException
     *         Raised when an argument in a request is not supported.
     * @throws TooManyRequestsException
     *         Raised when the number of requests being processed exceeds the limit.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptunedataException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptunedataClient.StartMLModelTransformJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptunedata-2023-08-01/StartMLModelTransformJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartMlModelTransformJobResponse startMLModelTransformJob(
            Consumer<StartMlModelTransformJobRequest.Builder> startMlModelTransformJobRequest)
            throws UnsupportedOperationException, BadRequestException, InvalidParameterException, MlResourceNotFoundException,
            ClientTimeoutException, PreconditionsFailedException, ConstraintViolationException, InvalidArgumentException,
            MissingParameterException, IllegalArgumentException, TooManyRequestsException, AwsServiceException,
            SdkClientException, NeptunedataException {
        return startMLModelTransformJob(StartMlModelTransformJobRequest.builder().applyMutation(startMlModelTransformJobRequest)
                .build());
    }

    /**
     * Create a {@link NeptunedataClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptunedataClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptunedataClient}.
     */
    static NeptunedataClientBuilder builder() {
        return new DefaultNeptunedataClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NeptunedataServiceClientConfiguration serviceClientConfiguration() {
        throw new java.lang.UnsupportedOperationException();
    }
}
