/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunedata.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Payload for the property graph summary response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertygraphSummaryValueMap implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertygraphSummaryValueMap.Builder, PropertygraphSummaryValueMap> {
    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(PropertygraphSummaryValueMap::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> LAST_STATISTICS_COMPUTATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastStatisticsComputationTime")
            .getter(getter(PropertygraphSummaryValueMap::lastStatisticsComputationTime))
            .setter(setter(Builder::lastStatisticsComputationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastStatisticsComputationTime")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<PropertygraphSummary> GRAPH_SUMMARY_FIELD = SdkField
            .<PropertygraphSummary> builder(MarshallingType.SDK_POJO).memberName("graphSummary")
            .getter(getter(PropertygraphSummaryValueMap::graphSummary)).setter(setter(Builder::graphSummary))
            .constructor(PropertygraphSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERSION_FIELD,
            LAST_STATISTICS_COMPUTATION_TIME_FIELD, GRAPH_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String version;

    private final Instant lastStatisticsComputationTime;

    private final PropertygraphSummary graphSummary;

    private PropertygraphSummaryValueMap(BuilderImpl builder) {
        this.version = builder.version;
        this.lastStatisticsComputationTime = builder.lastStatisticsComputationTime;
        this.graphSummary = builder.graphSummary;
    }

    /**
     * <p>
     * The version of this graph summary response.
     * </p>
     * 
     * @return The version of this graph summary response.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.
     * </p>
     * 
     * @return The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.
     */
    public final Instant lastStatisticsComputationTime() {
        return lastStatisticsComputationTime;
    }

    /**
     * <p>
     * The graph summary.
     * </p>
     * 
     * @return The graph summary.
     */
    public final PropertygraphSummary graphSummary() {
        return graphSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(lastStatisticsComputationTime());
        hashCode = 31 * hashCode + Objects.hashCode(graphSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertygraphSummaryValueMap)) {
            return false;
        }
        PropertygraphSummaryValueMap other = (PropertygraphSummaryValueMap) obj;
        return Objects.equals(version(), other.version())
                && Objects.equals(lastStatisticsComputationTime(), other.lastStatisticsComputationTime())
                && Objects.equals(graphSummary(), other.graphSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertygraphSummaryValueMap").add("Version", version())
                .add("LastStatisticsComputationTime", lastStatisticsComputationTime()).add("GraphSummary", graphSummary())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "lastStatisticsComputationTime":
            return Optional.ofNullable(clazz.cast(lastStatisticsComputationTime()));
        case "graphSummary":
            return Optional.ofNullable(clazz.cast(graphSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("version", VERSION_FIELD);
        map.put("lastStatisticsComputationTime", LAST_STATISTICS_COMPUTATION_TIME_FIELD);
        map.put("graphSummary", GRAPH_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertygraphSummaryValueMap, T> g) {
        return obj -> g.apply((PropertygraphSummaryValueMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertygraphSummaryValueMap> {
        /**
         * <p>
         * The version of this graph summary response.
         * </p>
         * 
         * @param version
         *        The version of this graph summary response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.
         * </p>
         * 
         * @param lastStatisticsComputationTime
         *        The timestamp, in ISO 8601 format, of the time at which Neptune last computed statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastStatisticsComputationTime(Instant lastStatisticsComputationTime);

        /**
         * <p>
         * The graph summary.
         * </p>
         * 
         * @param graphSummary
         *        The graph summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphSummary(PropertygraphSummary graphSummary);

        /**
         * <p>
         * The graph summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link PropertygraphSummary.Builder} avoiding
         * the need to create one manually via {@link PropertygraphSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PropertygraphSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #graphSummary(PropertygraphSummary)}.
         * 
         * @param graphSummary
         *        a consumer that will call methods on {@link PropertygraphSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #graphSummary(PropertygraphSummary)
         */
        default Builder graphSummary(Consumer<PropertygraphSummary.Builder> graphSummary) {
            return graphSummary(PropertygraphSummary.builder().applyMutation(graphSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String version;

        private Instant lastStatisticsComputationTime;

        private PropertygraphSummary graphSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertygraphSummaryValueMap model) {
            version(model.version);
            lastStatisticsComputationTime(model.lastStatisticsComputationTime);
            graphSummary(model.graphSummary);
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getLastStatisticsComputationTime() {
            return lastStatisticsComputationTime;
        }

        public final void setLastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
        }

        @Override
        public final Builder lastStatisticsComputationTime(Instant lastStatisticsComputationTime) {
            this.lastStatisticsComputationTime = lastStatisticsComputationTime;
            return this;
        }

        public final PropertygraphSummary.Builder getGraphSummary() {
            return graphSummary != null ? graphSummary.toBuilder() : null;
        }

        public final void setGraphSummary(PropertygraphSummary.BuilderImpl graphSummary) {
            this.graphSummary = graphSummary != null ? graphSummary.build() : null;
        }

        @Override
        public final Builder graphSummary(PropertygraphSummary graphSummary) {
            this.graphSummary = graphSummary;
            return this;
        }

        @Override
        public PropertygraphSummaryValueMap build() {
            return new PropertygraphSummaryValueMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
