/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsPublisher;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsPublisher;
import software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksPublisher;
import software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsPublisher;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphAsyncWaiter;

/**
 * Service client for accessing Neptune Graph asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Neptune Analytics is a serverless in-memory graph database service for analytics that delivers high-performance
 * analytics and real-time queries for any graph type. It complements the Amazon Neptune Database, an industry-leading
 * managed graph database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NeptuneGraphAsyncClient extends AwsClient {
    String SERVICE_NAME = "neptune-graph";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "neptune-graph";

    /**
     * <p>
     * Deletes the specified import task
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelImportTaskResponse> cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified import task
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelImportTaskRequest#builder()}
     * </p>
     *
     * @param cancelImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelImportTaskResponse> cancelImportTask(
            Consumer<CancelImportTaskRequest.Builder> cancelImportTaskRequest) {
        return cancelImportTask(CancelImportTaskRequest.builder().applyMutation(cancelImportTaskRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph.
     * </p>
     *
     * @param createGraphRequest
     * @return A Java Future containing the result of the CreateGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGraphResponse> createGraph(CreateGraphRequest createGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGraphRequest#builder()}
     * </p>
     *
     * @param createGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateGraphResponse> createGraph(Consumer<CreateGraphRequest.Builder> createGraphRequest) {
        return createGraph(CreateGraphRequest.builder().applyMutation(createGraphRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the specific graph.
     * </p>
     *
     * @param createGraphSnapshotRequest
     * @return A Java Future containing the result of the CreateGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGraphSnapshotResponse> createGraphSnapshot(
            CreateGraphSnapshotRequest createGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the specific graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param createGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGraphSnapshotResponse> createGraphSnapshot(
            Consumer<CreateGraphSnapshotRequest.Builder> createGraphSnapshotRequest) {
        return createGraphSnapshot(CreateGraphSnapshotRequest.builder().applyMutation(createGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or
     * from a Neptune database or a Neptune database snapshot.
     * </p>
     * <p>
     * The data can be loaded from files in S3 that in either the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a> or the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>.
     * </p>
     *
     * @param createGraphUsingImportTaskRequest
     * @return A Java Future containing the result of the CreateGraphUsingImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraphUsingImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphUsingImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGraphUsingImportTaskResponse> createGraphUsingImportTask(
            CreateGraphUsingImportTaskRequest createGraphUsingImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or
     * from a Neptune database or a Neptune database snapshot.
     * </p>
     * <p>
     * The data can be loaded from files in S3 that in either the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a> or the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphUsingImportTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateGraphUsingImportTaskRequest#builder()}
     * </p>
     *
     * @param createGraphUsingImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateGraphUsingImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreateGraphUsingImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphUsingImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateGraphUsingImportTaskResponse> createGraphUsingImportTask(
            Consumer<CreateGraphUsingImportTaskRequest.Builder> createGraphUsingImportTaskRequest) {
        return createGraphUsingImportTask(CreateGraphUsingImportTaskRequest.builder()
                .applyMutation(createGraphUsingImportTaskRequest).build());
    }

    /**
     * <p>
     * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach
     * security groups to the private graph endpoint. VPC endpoint charges apply.
     * </p>
     *
     * @param createPrivateGraphEndpointRequest
     * @return A Java Future containing the result of the CreatePrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreatePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreatePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePrivateGraphEndpointResponse> createPrivateGraphEndpoint(
            CreatePrivateGraphEndpointRequest createPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach
     * security groups to the private graph endpoint. VPC endpoint charges apply.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param createPrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreatePrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.CreatePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreatePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePrivateGraphEndpointResponse> createPrivateGraphEndpoint(
            Consumer<CreatePrivateGraphEndpointRequest.Builder> createPrivateGraphEndpointRequest) {
        return createPrivateGraphEndpoint(CreatePrivateGraphEndpointRequest.builder()
                .applyMutation(createPrivateGraphEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
     * </p>
     *
     * @param deleteGraphRequest
     * @return A Java Future containing the result of the DeleteGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeleteGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGraphResponse> deleteGraph(DeleteGraphRequest deleteGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGraphRequest#builder()}
     * </p>
     *
     * @param deleteGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeleteGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteGraphResponse> deleteGraph(Consumer<DeleteGraphRequest.Builder> deleteGraphRequest) {
        return deleteGraph(DeleteGraphRequest.builder().applyMutation(deleteGraphRequest).build());
    }

    /**
     * <p>
     * Deletes the specifed graph snapshot.
     * </p>
     *
     * @param deleteGraphSnapshotRequest
     * @return A Java Future containing the result of the DeleteGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeleteGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGraphSnapshotResponse> deleteGraphSnapshot(
            DeleteGraphSnapshotRequest deleteGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specifed graph snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeleteGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteGraphSnapshotResponse> deleteGraphSnapshot(
            Consumer<DeleteGraphSnapshotRequest.Builder> deleteGraphSnapshotRequest) {
        return deleteGraphSnapshot(DeleteGraphSnapshotRequest.builder().applyMutation(deleteGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a private graph endpoint.
     * </p>
     *
     * @param deletePrivateGraphEndpointRequest
     * @return A Java Future containing the result of the DeletePrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeletePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeletePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePrivateGraphEndpointResponse> deletePrivateGraphEndpoint(
            DeletePrivateGraphEndpointRequest deletePrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a private graph endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param deletePrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeletePrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.DeletePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeletePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeletePrivateGraphEndpointResponse> deletePrivateGraphEndpoint(
            Consumer<DeletePrivateGraphEndpointRequest.Builder> deletePrivateGraphEndpointRequest) {
        return deletePrivateGraphEndpoint(DeletePrivateGraphEndpointRequest.builder()
                .applyMutation(deletePrivateGraphEndpointRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified graph.
     * </p>
     *
     * @param getGraphRequest
     * @return A Java Future containing the result of the GetGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGraphResponse> getGraph(GetGraphRequest getGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphRequest.Builder} avoiding the need to
     * create one manually via {@link GetGraphRequest#builder()}
     * </p>
     *
     * @param getGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetGraphResponse> getGraph(Consumer<GetGraphRequest.Builder> getGraphRequest) {
        return getGraph(GetGraphRequest.builder().applyMutation(getGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified graph snapshot.
     * </p>
     *
     * @param getGraphSnapshotRequest
     * @return A Java Future containing the result of the GetGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGraphSnapshotResponse> getGraphSnapshot(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified graph snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link GetGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param getGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetGraphSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetGraphSnapshotResponse> getGraphSnapshot(
            Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) {
        return getGraphSnapshot(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified import task.
     * </p>
     *
     * @param getImportTaskRequest
     * @return A Java Future containing the result of the GetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImportTaskResponse> getImportTask(GetImportTaskRequest getImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportTaskRequest#builder()}
     * </p>
     *
     * @param getImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetImportTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetImportTaskResponse> getImportTask(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) {
        return getImportTask(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified private endpoint.
     * </p>
     *
     * @param getPrivateGraphEndpointRequest
     * @return A Java Future containing the result of the GetPrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetPrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetPrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPrivateGraphEndpointResponse> getPrivateGraphEndpoint(
            GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified private endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link GetPrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param getPrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPrivateGraphEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.GetPrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetPrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPrivateGraphEndpointResponse> getPrivateGraphEndpoint(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) {
        return getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Lists available snapshots of a specified Neptune Analytics graph.
     * </p>
     *
     * @param listGraphSnapshotsRequest
     * @return A Java Future containing the result of the ListGraphSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGraphSnapshotsResponse> listGraphSnapshots(ListGraphSnapshotsRequest listGraphSnapshotsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available snapshots of a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGraphSnapshotsRequest#builder()}
     * </p>
     *
     * @param listGraphSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListGraphSnapshots operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListGraphSnapshotsResponse> listGraphSnapshots(
            Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest) {
        return listGraphSnapshots(ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsPublisher publisher = client.listGraphSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsPublisher publisher = client.listGraphSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGraphSnapshotsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsPublisher listGraphSnapshotsPaginator(ListGraphSnapshotsRequest listGraphSnapshotsRequest) {
        return new ListGraphSnapshotsPublisher(this, listGraphSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsPublisher publisher = client.listGraphSnapshotsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsPublisher publisher = client.listGraphSnapshotsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGraphSnapshotsRequest#builder()}
     * </p>
     *
     * @param listGraphSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsPublisher listGraphSnapshotsPaginator(
            Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest) {
        return listGraphSnapshotsPaginator(ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists available Neptune Analytics graphs.
     * </p>
     *
     * @param listGraphsRequest
     * @return A Java Future containing the result of the ListGraphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGraphsResponse> listGraphs(ListGraphsRequest listGraphsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available Neptune Analytics graphs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGraphsRequest#builder()}
     * </p>
     *
     * @param listGraphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListGraphs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListGraphsResponse> listGraphs(Consumer<ListGraphsRequest.Builder> listGraphsRequest) {
        return listGraphs(ListGraphsRequest.builder().applyMutation(listGraphsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsPublisher publisher = client.listGraphsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsPublisher publisher = client.listGraphsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)} operation.</b>
     * </p>
     *
     * @param listGraphsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsPublisher listGraphsPaginator(ListGraphsRequest listGraphsRequest) {
        return new ListGraphsPublisher(this, listGraphsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsPublisher publisher = client.listGraphsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsPublisher publisher = client.listGraphsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGraphsRequest#builder()}
     * </p>
     *
     * @param listGraphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsPublisher listGraphsPaginator(Consumer<ListGraphsRequest.Builder> listGraphsRequest) {
        return listGraphsPaginator(ListGraphsRequest.builder().applyMutation(listGraphsRequest).build());
    }

    /**
     * <p>
     * Lists import tasks.
     * </p>
     *
     * @param listImportTasksRequest
     * @return A Java Future containing the result of the ListImportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportTasksResponse> listImportTasks(ListImportTasksRequest listImportTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists import tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportTasksRequest#builder()}
     * </p>
     *
     * @param listImportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListImportTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListImportTasksResponse> listImportTasks(
            Consumer<ListImportTasksRequest.Builder> listImportTasksRequest) {
        return listImportTasks(ListImportTasksRequest.builder().applyMutation(listImportTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksPublisher publisher = client.listImportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksPublisher publisher = client.listImportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksPublisher listImportTasksPaginator(ListImportTasksRequest listImportTasksRequest) {
        return new ListImportTasksPublisher(this, listImportTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksPublisher publisher = client.listImportTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksPublisher publisher = client.listImportTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportTasksRequest#builder()}
     * </p>
     *
     * @param listImportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksPublisher listImportTasksPaginator(Consumer<ListImportTasksRequest.Builder> listImportTasksRequest) {
        return listImportTasksPaginator(ListImportTasksRequest.builder().applyMutation(listImportTasksRequest).build());
    }

    /**
     * <p>
     * Lists private endpoints for a specified Neptune Analytics graph.
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     * @return A Java Future containing the result of the ListPrivateGraphEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPrivateGraphEndpointsResponse> listPrivateGraphEndpoints(
            ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists private endpoints for a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrivateGraphEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrivateGraphEndpointsRequest#builder()}
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListPrivateGraphEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListPrivateGraphEndpointsResponse> listPrivateGraphEndpoints(
            Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) {
        return listPrivateGraphEndpoints(ListPrivateGraphEndpointsRequest.builder()
                .applyMutation(listPrivateGraphEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsPublisher publisher = client.listPrivateGraphEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsPublisher publisher = client.listPrivateGraphEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsPublisher listPrivateGraphEndpointsPaginator(
            ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) {
        return new ListPrivateGraphEndpointsPublisher(this, listPrivateGraphEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsPublisher publisher = client.listPrivateGraphEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsPublisher publisher = client.listPrivateGraphEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrivateGraphEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrivateGraphEndpointsRequest#builder()}
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsPublisher listPrivateGraphEndpointsPaginator(
            Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) {
        return listPrivateGraphEndpointsPaginator(ListPrivateGraphEndpointsRequest.builder()
                .applyMutation(listPrivateGraphEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Empties the data from a specified Neptune Analytics graph.
     * </p>
     *
     * @param resetGraphRequest
     * @return A Java Future containing the result of the ResetGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ResetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ResetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetGraphResponse> resetGraph(ResetGraphRequest resetGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Empties the data from a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetGraphRequest.Builder} avoiding the need to
     * create one manually via {@link ResetGraphRequest#builder()}
     * </p>
     *
     * @param resetGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResetGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.ResetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ResetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResetGraphResponse> resetGraph(Consumer<ResetGraphRequest.Builder> resetGraphRequest) {
        return resetGraph(ResetGraphRequest.builder().applyMutation(resetGraphRequest).build());
    }

    /**
     * <p>
     * Restores a graph from a snapshot.
     * </p>
     *
     * @param restoreGraphFromSnapshotRequest
     * @return A Java Future containing the result of the RestoreGraphFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.RestoreGraphFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/RestoreGraphFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreGraphFromSnapshotResponse> restoreGraphFromSnapshot(
            RestoreGraphFromSnapshotRequest restoreGraphFromSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a graph from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreGraphFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreGraphFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreGraphFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RestoreGraphFromSnapshot operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceQuotaExceededException A service quota was exceeded.</li>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.RestoreGraphFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/RestoreGraphFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RestoreGraphFromSnapshotResponse> restoreGraphFromSnapshot(
            Consumer<RestoreGraphFromSnapshotRequest.Builder> restoreGraphFromSnapshotRequest) {
        return restoreGraphFromSnapshot(RestoreGraphFromSnapshotRequest.builder().applyMutation(restoreGraphFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a specified Neptune Analytics graph
     * </p>
     *
     * @param updateGraphRequest
     * @return A Java Future containing the result of the UpdateGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.UpdateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UpdateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGraphResponse> updateGraph(UpdateGraphRequest updateGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a specified Neptune Analytics graph
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGraphRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGraphRequest#builder()}
     * </p>
     *
     * @param updateGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateGraph operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The exception was interrupted by throttling.</li>
     *         <li>ValidationException A resource could not be validated</li>
     *         <li>ConflictException Raised when a conflict is encountered.</li>
     *         <li>InternalServerException A failure occurred on the server.</li>
     *         <li>ResourceNotFoundException A specified resource could not be located.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>NeptuneGraphException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample NeptuneGraphAsyncClient.UpdateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UpdateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateGraphResponse> updateGraph(Consumer<UpdateGraphRequest.Builder> updateGraphRequest) {
        return updateGraph(UpdateGraphRequest.builder().applyMutation(updateGraphRequest).build());
    }

    /**
     * Create an instance of {@link NeptuneGraphAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NeptuneGraphAsyncWaiter}
     */
    default NeptuneGraphAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default NeptuneGraphServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NeptuneGraphAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptuneGraphAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptuneGraphAsyncClient}.
     */
    static NeptuneGraphAsyncClientBuilder builder() {
        return new DefaultNeptuneGraphAsyncClientBuilder();
    }
}
