/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.endpoints;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * The parameters object used to resolve an endpoint for the NeptuneGraph service.
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public final class NeptuneGraphEndpointParams implements
        ToCopyableBuilder<NeptuneGraphEndpointParams.Builder, NeptuneGraphEndpointParams> {
    private final Region region;

    private final Boolean useFIPS;

    private final Boolean useDualStack;

    private final String endpoint;

    private final String apiType;

    private NeptuneGraphEndpointParams(BuilderImpl builder) {
        this.region = builder.region;
        this.useFIPS = builder.useFIPS;
        this.useDualStack = builder.useDualStack;
        this.endpoint = builder.endpoint;
        this.apiType = builder.apiType;
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public Region region() {
        return region;
    }

    public Boolean useFips() {
        return useFIPS;
    }

    public Boolean useDualStack() {
        return useDualStack;
    }

    public String endpoint() {
        return endpoint;
    }

    public String apiType() {
        return apiType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public interface Builder extends CopyableBuilder<Builder, NeptuneGraphEndpointParams> {
        Builder region(Region region);

        Builder useFips(Boolean useFIPS);

        Builder useDualStack(Boolean useDualStack);

        Builder endpoint(String endpoint);

        Builder apiType(String apiType);

        NeptuneGraphEndpointParams build();
    }

    private static class BuilderImpl implements Builder {
        private Region region;

        private Boolean useFIPS = false;

        private Boolean useDualStack = false;

        private String endpoint;

        private String apiType;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneGraphEndpointParams builder) {
            this.region = builder.region;
            this.useFIPS = builder.useFIPS;
            this.useDualStack = builder.useDualStack;
            this.endpoint = builder.endpoint;
            this.apiType = builder.apiType;
        }

        @Override
        public Builder region(Region region) {
            this.region = region;
            return this;
        }

        @Override
        public Builder useFips(Boolean useFIPS) {
            this.useFIPS = useFIPS;
            if (this.useFIPS == null) {
                this.useFIPS = false;
            }
            return this;
        }

        @Override
        public Builder useDualStack(Boolean useDualStack) {
            this.useDualStack = useDualStack;
            if (this.useDualStack == null) {
                this.useDualStack = false;
            }
            return this;
        }

        @Override
        public Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        @Override
        public Builder apiType(String apiType) {
            this.apiType = apiType;
            return this;
        }

        @Override
        public NeptuneGraphEndpointParams build() {
            return new NeptuneGraphEndpointParams(this);
        }
    }
}
