/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.neptunegraph.model.AccessDeniedException;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CancelQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.CancelQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.ConflictException;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSummaryRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSummaryResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetQueryRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetQueryResponse;
import software.amazon.awssdk.services.neptunegraph.model.InternalServerException;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListQueriesRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListQueriesResponse;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphException;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.ResetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.neptunegraph.model.StartImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.StartImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.TagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.ThrottlingException;
import software.amazon.awssdk.services.neptunegraph.model.UnprocessableException;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.neptunegraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.UpdateGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.ValidationException;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable;
import software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable;
import software.amazon.awssdk.services.neptunegraph.waiters.NeptuneGraphWaiter;

/**
 * Service client for accessing Neptune Graph. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Neptune Analytics is a new analytics database engine for Amazon Neptune that helps customers get to insights faster
 * by quickly processing large amounts of graph data, invoking popular graph analytic algorithms in low-latency queries,
 * and getting analytics results in seconds.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface NeptuneGraphClient extends AwsClient {
    String SERVICE_NAME = "neptune-graph";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "neptune-graph";

    /**
     * <p>
     * Deletes the specified import task.
     * </p>
     *
     * @param cancelImportTaskRequest
     * @return Result of the CancelImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImportTaskResponse cancelImportTask(CancelImportTaskRequest cancelImportTaskRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link CancelImportTaskRequest#builder()}
     * </p>
     *
     * @param cancelImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CancelImportTaskRequest.Builder} to create a
     *        request.
     * @return Result of the CancelImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CancelImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelImportTaskResponse cancelImportTask(Consumer<CancelImportTaskRequest.Builder> cancelImportTaskRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return cancelImportTask(CancelImportTaskRequest.builder().applyMutation(cancelImportTaskRequest).build());
    }

    /**
     * <p>
     * Cancels a specified query.
     * </p>
     *
     * @param cancelQueryRequest
     * @return Result of the CancelQuery operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a specified query.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelQueryRequest.Builder} avoiding the need to
     * create one manually via {@link CancelQueryRequest#builder()}
     * </p>
     *
     * @param cancelQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CancelQueryRequest.Builder} to create a request.
     * @return Result of the CancelQuery operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CancelQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CancelQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelQueryResponse cancelQuery(Consumer<CancelQueryRequest.Builder> cancelQueryRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return cancelQuery(CancelQueryRequest.builder().applyMutation(cancelQueryRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph.
     * </p>
     *
     * @param createGraphRequest
     * @return Result of the CreateGraph operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGraphResponse createGraph(CreateGraphRequest createGraphRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphRequest.Builder} avoiding the need to
     * create one manually via {@link CreateGraphRequest#builder()}
     * </p>
     *
     * @param createGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphRequest.Builder} to create a request.
     * @return Result of the CreateGraph operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGraphResponse createGraph(Consumer<CreateGraphRequest.Builder> createGraphRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return createGraph(CreateGraphRequest.builder().applyMutation(createGraphRequest).build());
    }

    /**
     * <p>
     * Creates a snapshot of the specific graph.
     * </p>
     *
     * @param createGraphSnapshotRequest
     * @return Result of the CreateGraphSnapshot operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGraphSnapshotResponse createGraphSnapshot(CreateGraphSnapshotRequest createGraphSnapshotRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a snapshot of the specific graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param createGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the CreateGraphSnapshot operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGraphSnapshotResponse createGraphSnapshot(
            Consumer<CreateGraphSnapshotRequest.Builder> createGraphSnapshotRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return createGraphSnapshot(CreateGraphSnapshotRequest.builder().applyMutation(createGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or
     * from a Neptune database or a Neptune database snapshot.
     * </p>
     * <p>
     * The data can be loaded from files in S3 that in either the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a> or the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>.
     * </p>
     *
     * @param createGraphUsingImportTaskRequest
     * @return Result of the CreateGraphUsingImportTask operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraphUsingImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphUsingImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGraphUsingImportTaskResponse createGraphUsingImportTask(
            CreateGraphUsingImportTaskRequest createGraphUsingImportTaskRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Neptune Analytics graph and imports data into it, either from Amazon Simple Storage Service (S3) or
     * from a Neptune database or a Neptune database snapshot.
     * </p>
     * <p>
     * The data can be loaded from files in S3 that in either the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a> or the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphUsingImportTaskRequest.Builder} avoiding
     * the need to create one manually via {@link CreateGraphUsingImportTaskRequest#builder()}
     * </p>
     *
     * @param createGraphUsingImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreateGraphUsingImportTaskRequest.Builder} to
     *        create a request.
     * @return Result of the CreateGraphUsingImportTask operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreateGraphUsingImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreateGraphUsingImportTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateGraphUsingImportTaskResponse createGraphUsingImportTask(
            Consumer<CreateGraphUsingImportTaskRequest.Builder> createGraphUsingImportTaskRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return createGraphUsingImportTask(CreateGraphUsingImportTaskRequest.builder()
                .applyMutation(createGraphUsingImportTaskRequest).build());
    }

    /**
     * <p>
     * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach
     * security groups to the private graph endpoint.
     * </p>
     * <note>
     * <p>
     * VPC endpoint charges apply.
     * </p>
     * </note>
     *
     * @param createPrivateGraphEndpointRequest
     * @return Result of the CreatePrivateGraphEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreatePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreatePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateGraphEndpointResponse createPrivateGraphEndpoint(
            CreatePrivateGraphEndpointRequest createPrivateGraphEndpointRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create a private graph endpoint to allow private access from to the graph from within a VPC. You can attach
     * security groups to the private graph endpoint.
     * </p>
     * <note>
     * <p>
     * VPC endpoint charges apply.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param createPrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.CreatePrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the CreatePrivateGraphEndpoint operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.CreatePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/CreatePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateGraphEndpointResponse createPrivateGraphEndpoint(
            Consumer<CreatePrivateGraphEndpointRequest.Builder> createPrivateGraphEndpointRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return createPrivateGraphEndpoint(CreatePrivateGraphEndpointRequest.builder()
                .applyMutation(createPrivateGraphEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
     * </p>
     *
     * @param deleteGraphRequest
     * @return Result of the DeleteGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeleteGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGraphResponse deleteGraph(DeleteGraphRequest deleteGraphRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified graph. Graphs cannot be deleted if delete-protection is enabled.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteGraphRequest#builder()}
     * </p>
     *
     * @param deleteGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeleteGraphRequest.Builder} to create a request.
     * @return Result of the DeleteGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeleteGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGraphResponse deleteGraph(Consumer<DeleteGraphRequest.Builder> deleteGraphRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return deleteGraph(DeleteGraphRequest.builder().applyMutation(deleteGraphRequest).build());
    }

    /**
     * <p>
     * Deletes the specifed graph snapshot.
     * </p>
     *
     * @param deleteGraphSnapshotRequest
     * @return Result of the DeleteGraphSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeleteGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGraphSnapshotResponse deleteGraphSnapshot(DeleteGraphSnapshotRequest deleteGraphSnapshotRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specifed graph snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param deleteGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeleteGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteGraphSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeleteGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeleteGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteGraphSnapshotResponse deleteGraphSnapshot(
            Consumer<DeleteGraphSnapshotRequest.Builder> deleteGraphSnapshotRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return deleteGraphSnapshot(DeleteGraphSnapshotRequest.builder().applyMutation(deleteGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Deletes a private graph endpoint.
     * </p>
     *
     * @param deletePrivateGraphEndpointRequest
     * @return Result of the DeletePrivateGraphEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeletePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeletePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrivateGraphEndpointResponse deletePrivateGraphEndpoint(
            DeletePrivateGraphEndpointRequest deletePrivateGraphEndpointRequest) throws ThrottlingException, ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a private graph endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link DeletePrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param deletePrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.DeletePrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the DeletePrivateGraphEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.DeletePrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/DeletePrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeletePrivateGraphEndpointResponse deletePrivateGraphEndpoint(
            Consumer<DeletePrivateGraphEndpointRequest.Builder> deletePrivateGraphEndpointRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return deletePrivateGraphEndpoint(DeletePrivateGraphEndpointRequest.builder()
                .applyMutation(deletePrivateGraphEndpointRequest).build());
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     *
     * @param executeQueryRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled ExecuteQueryResponse
     *        and an InputStream to the response content are provided as parameters to the callback. The callback may
     *        return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The query results.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default <ReturnT> ReturnT executeQuery(ExecuteQueryRequest executeQueryRequest,
            ResponseTransformer<ExecuteQueryResponse, ReturnT> responseTransformer) throws UnprocessableException,
            ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled ExecuteQueryResponse
     *        and an InputStream to the response content are provided as parameters to the callback. The callback may
     *        return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The query results.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default <ReturnT> ReturnT executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest,
            ResponseTransformer<ExecuteQueryResponse, ReturnT> responseTransformer) throws UnprocessableException,
            ThrottlingException, ValidationException, ConflictException, AccessDeniedException, InternalServerException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build(), responseTransformer);
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     *
     * @param executeQueryRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The query results.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #executeQuery(ExecuteQueryRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ExecuteQueryResponse executeQuery(ExecuteQueryRequest executeQueryRequest, Path destinationPath)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(executeQueryRequest, ResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The query results.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #executeQuery(ExecuteQueryRequest, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ExecuteQueryResponse executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest, Path destinationPath)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     *
     * @param executeQueryRequest
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The query results.
     *         </p>
     *         '.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #getObject(executeQuery, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ResponseInputStream<ExecuteQueryResponse> executeQuery(ExecuteQueryRequest executeQueryRequest)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(executeQueryRequest, ResponseTransformer.toInputStream());
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseInputStream} containing data streamed from service. Note that this is an unmanaged
     *         reference to the underlying HTTP connection so great care must be taken to ensure all data if fully read
     *         from the input stream and that it is properly closed. Failure to do so may result in sub-optimal behavior
     *         and exhausting connections in the connection pool. The unmarshalled response object can be obtained via
     *         {@link ResponseInputStream#response()}. The service documentation for the response content is as follows
     *         '
     *         <p>
     *         The query results.
     *         </p>
     *         '.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #getObject(executeQuery, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ResponseInputStream<ExecuteQueryResponse> executeQuery(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     *
     * @param executeQueryRequest
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The query results.
     *         </p>
     *         '.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #getObject(executeQuery, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ResponseBytes<ExecuteQueryResponse> executeQueryAsBytes(ExecuteQueryRequest executeQueryRequest)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQuery(executeQueryRequest, ResponseTransformer.toBytes());
    }

    /**
     * <p>
     * Execute an openCypher query.
     * </p>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have a
     * policy attached that allows one of the following IAM actions in that cluster, depending on the query:
     * </p>
     * <ul>
     * <li>
     * <p>
     * neptune-graph:ReadDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:WriteDataViaQuery
     * </p>
     * </li>
     * <li>
     * <p>
     * neptune-graph:DeleteDataViaQuery
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExecuteQueryRequest.Builder} avoiding the need to
     * create one manually via {@link ExecuteQueryRequest#builder()}
     * </p>
     *
     * @param executeQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ExecuteQueryRequest.Builder} to create a
     *        request.
     * @return A {@link ResponseBytes} that loads the data streamed from the service into memory and exposes it in
     *         convenient in-memory representations like a byte buffer or string. The unmarshalled response object can
     *         be obtained via {@link ResponseBytes#response()}. The service documentation for the response content is
     *         as follows '
     *         <p>
     *         The query results.
     *         </p>
     *         '.
     * @throws UnprocessableException
     *         Request cannot be processed due to known reasons. Eg. partition full.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ExecuteQuery
     * @see #getObject(executeQuery, ResponseTransformer)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ExecuteQuery" target="_top">AWS
     *      API Documentation</a>
     */
    default ResponseBytes<ExecuteQueryResponse> executeQueryAsBytes(Consumer<ExecuteQueryRequest.Builder> executeQueryRequest)
            throws UnprocessableException, ThrottlingException, ValidationException, ConflictException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return executeQueryAsBytes(ExecuteQueryRequest.builder().applyMutation(executeQueryRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified graph.
     * </p>
     *
     * @param getGraphRequest
     * @return Result of the GetGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGraphResponse getGraph(GetGraphRequest getGraphRequest) throws ThrottlingException, ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphRequest.Builder} avoiding the need to
     * create one manually via {@link GetGraphRequest#builder()}
     * </p>
     *
     * @param getGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest.Builder} to create a request.
     * @return Result of the GetGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGraphResponse getGraph(Consumer<GetGraphRequest.Builder> getGraphRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return getGraph(GetGraphRequest.builder().applyMutation(getGraphRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified graph snapshot.
     * </p>
     *
     * @param getGraphSnapshotRequest
     * @return Result of the GetGraphSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGraphSnapshotResponse getGraphSnapshot(GetGraphSnapshotRequest getGraphSnapshotRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified graph snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphSnapshotRequest.Builder} avoiding the need
     * to create one manually via {@link GetGraphSnapshotRequest#builder()}
     * </p>
     *
     * @param getGraphSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest.Builder} to create a
     *        request.
     * @return Result of the GetGraphSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraphSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGraphSnapshotResponse getGraphSnapshot(Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return getGraphSnapshot(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build());
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     *
     * @param getGraphSummaryRequest
     * @return Result of the GetGraphSummary operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGraphSummaryResponse getGraphSummary(GetGraphSummaryRequest getGraphSummaryRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a graph summary for a property graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphSummaryRequest.Builder} avoiding the need
     * to create one manually via {@link GetGraphSummaryRequest#builder()}
     * </p>
     *
     * @param getGraphSummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetGraphSummaryRequest.Builder} to create a
     *        request.
     * @return Result of the GetGraphSummary operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetGraphSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetGraphSummary" target="_top">AWS
     *      API Documentation</a>
     */
    default GetGraphSummaryResponse getGraphSummary(Consumer<GetGraphSummaryRequest.Builder> getGraphSummaryRequest)
            throws ThrottlingException, ValidationException, AccessDeniedException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return getGraphSummary(GetGraphSummaryRequest.builder().applyMutation(getGraphSummaryRequest).build());
    }

    /**
     * <p>
     * Retrieves a specified import task.
     * </p>
     *
     * @param getImportTaskRequest
     * @return Result of the GetImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImportTaskResponse getImportTask(GetImportTaskRequest getImportTaskRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a specified import task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetImportTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetImportTaskRequest#builder()}
     * </p>
     *
     * @param getImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetImportTaskResponse getImportTask(Consumer<GetImportTaskRequest.Builder> getImportTaskRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return getImportTask(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specified private endpoint.
     * </p>
     *
     * @param getPrivateGraphEndpointRequest
     * @return Result of the GetPrivateGraphEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetPrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetPrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrivateGraphEndpointResponse getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specified private endpoint.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPrivateGraphEndpointRequest.Builder} avoiding
     * the need to create one manually via {@link GetPrivateGraphEndpointRequest#builder()}
     * </p>
     *
     * @param getPrivateGraphEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the GetPrivateGraphEndpoint operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetPrivateGraphEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetPrivateGraphEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPrivateGraphEndpointResponse getPrivateGraphEndpoint(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return getPrivateGraphEndpoint(GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the status of a specified query.
     * </p>
     * <note>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have
     * the <code>neptune-graph:GetQueryStatus</code> IAM action attached.
     * </p>
     * </note>
     *
     * @param getQueryRequest
     * @return Result of the GetQuery operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueryResponse getQuery(GetQueryRequest getQueryRequest) throws ThrottlingException, ValidationException,
            AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of a specified query.
     * </p>
     * <note>
     * <p>
     * When invoking this operation in a Neptune Analytics cluster, the IAM user or role making the request must have
     * the <code>neptune-graph:GetQueryStatus</code> IAM action attached.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetQueryRequest.Builder} avoiding the need to
     * create one manually via {@link GetQueryRequest#builder()}
     * </p>
     *
     * @param getQueryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.GetQueryRequest.Builder} to create a request.
     * @return Result of the GetQuery operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.GetQuery
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/GetQuery" target="_top">AWS API
     *      Documentation</a>
     */
    default GetQueryResponse getQuery(Consumer<GetQueryRequest.Builder> getQueryRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return getQuery(GetQueryRequest.builder().applyMutation(getQueryRequest).build());
    }

    /**
     * <p>
     * Lists available snapshots of a specified Neptune Analytics graph.
     * </p>
     *
     * @param listGraphSnapshotsRequest
     * @return Result of the ListGraphSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsResponse listGraphSnapshots(ListGraphSnapshotsRequest listGraphSnapshotsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available snapshots of a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGraphSnapshotsRequest#builder()}
     * </p>
     *
     * @param listGraphSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest.Builder} to create a
     *        request.
     * @return Result of the ListGraphSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsResponse listGraphSnapshots(Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return listGraphSnapshots(ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client.listGraphSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client
     *             .listGraphSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client.listGraphSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listGraphSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsIterable listGraphSnapshotsPaginator(ListGraphSnapshotsRequest listGraphSnapshotsRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListGraphSnapshotsIterable(this, listGraphSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client.listGraphSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client
     *             .listGraphSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphSnapshotsIterable responses = client.listGraphSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphSnapshots(software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListGraphSnapshotsRequest#builder()}
     * </p>
     *
     * @param listGraphSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphSnapshotsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListGraphSnapshotsIterable listGraphSnapshotsPaginator(
            Consumer<ListGraphSnapshotsRequest.Builder> listGraphSnapshotsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return listGraphSnapshotsPaginator(ListGraphSnapshotsRequest.builder().applyMutation(listGraphSnapshotsRequest).build());
    }

    /**
     * <p>
     * Lists available Neptune Analytics graphs.
     * </p>
     *
     * @param listGraphsRequest
     * @return Result of the ListGraphs operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsResponse listGraphs(ListGraphsRequest listGraphsRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists available Neptune Analytics graphs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGraphsRequest#builder()}
     * </p>
     *
     * @param listGraphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest.Builder} to create a request.
     * @return Result of the ListGraphs operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsResponse listGraphs(Consumer<ListGraphsRequest.Builder> listGraphsRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return listGraphs(ListGraphsRequest.builder().applyMutation(listGraphsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)} operation.</b>
     * </p>
     *
     * @param listGraphsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsIterable listGraphsPaginator(ListGraphsRequest listGraphsRequest) throws ThrottlingException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListGraphsIterable(this, listGraphsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListGraphsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListGraphsIterable responses = client.listGraphsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphs(software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphsRequest.Builder} avoiding the need to
     * create one manually via {@link ListGraphsRequest#builder()}
     * </p>
     *
     * @param listGraphsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListGraphsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListGraphs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListGraphs" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphsIterable listGraphsPaginator(Consumer<ListGraphsRequest.Builder> listGraphsRequest)
            throws ThrottlingException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return listGraphsPaginator(ListGraphsRequest.builder().applyMutation(listGraphsRequest).build());
    }

    /**
     * <p>
     * Lists import tasks.
     * </p>
     *
     * @param listImportTasksRequest
     * @return Result of the ListImportTasks operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksResponse listImportTasks(ListImportTasksRequest listImportTasksRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists import tasks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportTasksRequest#builder()}
     * </p>
     *
     * @param listImportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest.Builder} to create a
     *        request.
     * @return Result of the ListImportTasks operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksResponse listImportTasks(Consumer<ListImportTasksRequest.Builder> listImportTasksRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return listImportTasks(ListImportTasksRequest.builder().applyMutation(listImportTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client.listImportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client
     *             .listImportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client.listImportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listImportTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksIterable listImportTasksPaginator(ListImportTasksRequest listImportTasksRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListImportTasksIterable(this, listImportTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client.listImportTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client
     *             .listImportTasksPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListImportTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListImportTasksIterable responses = client.listImportTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportTasks(software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportTasksRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportTasksRequest#builder()}
     * </p>
     *
     * @param listImportTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListImportTasksRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListImportTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListImportTasks" target="_top">AWS
     *      API Documentation</a>
     */
    default ListImportTasksIterable listImportTasksPaginator(Consumer<ListImportTasksRequest.Builder> listImportTasksRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return listImportTasksPaginator(ListImportTasksRequest.builder().applyMutation(listImportTasksRequest).build());
    }

    /**
     * <p>
     * Lists private endpoints for a specified Neptune Analytics graph.
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     * @return Result of the ListPrivateGraphEndpoints operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsResponse listPrivateGraphEndpoints(
            ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists private endpoints for a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrivateGraphEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrivateGraphEndpointsRequest#builder()}
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest.Builder} to
     *        create a request.
     * @return Result of the ListPrivateGraphEndpoints operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsResponse listPrivateGraphEndpoints(
            Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return listPrivateGraphEndpoints(ListPrivateGraphEndpointsRequest.builder()
                .applyMutation(listPrivateGraphEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client.listPrivateGraphEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client
     *             .listPrivateGraphEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client.listPrivateGraphEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsIterable listPrivateGraphEndpointsPaginator(
            ListPrivateGraphEndpointsRequest listPrivateGraphEndpointsRequest) throws ThrottlingException, ValidationException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return new ListPrivateGraphEndpointsIterable(this, listPrivateGraphEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client.listPrivateGraphEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client
     *             .listPrivateGraphEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.neptunegraph.paginators.ListPrivateGraphEndpointsIterable responses = client.listPrivateGraphEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPrivateGraphEndpoints(software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListPrivateGraphEndpointsRequest.Builder} avoiding
     * the need to create one manually via {@link ListPrivateGraphEndpointsRequest#builder()}
     * </p>
     *
     * @param listPrivateGraphEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListPrivateGraphEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListPrivateGraphEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListPrivateGraphEndpointsIterable listPrivateGraphEndpointsPaginator(
            Consumer<ListPrivateGraphEndpointsRequest.Builder> listPrivateGraphEndpointsRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return listPrivateGraphEndpointsPaginator(ListPrivateGraphEndpointsRequest.builder()
                .applyMutation(listPrivateGraphEndpointsRequest).build());
    }

    /**
     * <p>
     * Lists active openCypher queries.
     * </p>
     *
     * @param listQueriesRequest
     * @return Result of the ListQueries operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesResponse listQueries(ListQueriesRequest listQueriesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists active openCypher queries.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListQueriesRequest.Builder} avoiding the need to
     * create one manually via {@link ListQueriesRequest#builder()}
     * </p>
     *
     * @param listQueriesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListQueriesRequest.Builder} to create a request.
     * @return Result of the ListQueries operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws AccessDeniedException
     *         Raised in case of an authentication or authorization failure.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListQueries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListQueries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListQueriesResponse listQueries(Consumer<ListQueriesRequest.Builder> listQueriesRequest) throws ThrottlingException,
            ValidationException, AccessDeniedException, InternalServerException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return listQueries(ListQueriesRequest.builder().applyMutation(listQueriesRequest).build());
    }

    /**
     * <p>
     * Lists tags associated with a specified resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags associated with a specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Empties the data from a specified Neptune Analytics graph.
     * </p>
     *
     * @param resetGraphRequest
     * @return Result of the ResetGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ResetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ResetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetGraphResponse resetGraph(ResetGraphRequest resetGraphRequest) throws ThrottlingException, ValidationException,
            ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Empties the data from a specified Neptune Analytics graph.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResetGraphRequest.Builder} avoiding the need to
     * create one manually via {@link ResetGraphRequest#builder()}
     * </p>
     *
     * @param resetGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.ResetGraphRequest.Builder} to create a request.
     * @return Result of the ResetGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.ResetGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/ResetGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default ResetGraphResponse resetGraph(Consumer<ResetGraphRequest.Builder> resetGraphRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return resetGraph(ResetGraphRequest.builder().applyMutation(resetGraphRequest).build());
    }

    /**
     * <p>
     * Restores a graph from a snapshot.
     * </p>
     *
     * @param restoreGraphFromSnapshotRequest
     * @return Result of the RestoreGraphFromSnapshot operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.RestoreGraphFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/RestoreGraphFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreGraphFromSnapshotResponse restoreGraphFromSnapshot(
            RestoreGraphFromSnapshotRequest restoreGraphFromSnapshotRequest) throws ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Restores a graph from a snapshot.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RestoreGraphFromSnapshotRequest.Builder} avoiding
     * the need to create one manually via {@link RestoreGraphFromSnapshotRequest#builder()}
     * </p>
     *
     * @param restoreGraphFromSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.RestoreGraphFromSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the RestoreGraphFromSnapshot operation returned by the service.
     * @throws ServiceQuotaExceededException
     *         A service quota was exceeded.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.RestoreGraphFromSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/RestoreGraphFromSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default RestoreGraphFromSnapshotResponse restoreGraphFromSnapshot(
            Consumer<RestoreGraphFromSnapshotRequest.Builder> restoreGraphFromSnapshotRequest)
            throws ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return restoreGraphFromSnapshot(RestoreGraphFromSnapshotRequest.builder().applyMutation(restoreGraphFromSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Import data into existing Neptune Analytics graph from Amazon Simple Storage Service (S3). The graph needs to be
     * empty and in the AVAILABLE state.
     * </p>
     *
     * @param startImportTaskRequest
     * @return Result of the StartImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.StartImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/StartImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImportTaskResponse startImportTask(StartImportTaskRequest startImportTaskRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Import data into existing Neptune Analytics graph from Amazon Simple Storage Service (S3). The graph needs to be
     * empty and in the AVAILABLE state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportTaskRequest.Builder} avoiding the need
     * to create one manually via {@link StartImportTaskRequest#builder()}
     * </p>
     *
     * @param startImportTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.StartImportTaskRequest.Builder} to create a
     *        request.
     * @return Result of the StartImportTask operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.StartImportTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/StartImportTask" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImportTaskResponse startImportTask(Consumer<StartImportTaskRequest.Builder> startImportTaskRequest)
            throws ThrottlingException, ValidationException, ConflictException, InternalServerException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, NeptuneGraphException {
        return startImportTask(StartImportTaskRequest.builder().applyMutation(startImportTaskRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException,
            ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the specified tags from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, NeptuneGraphException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the configuration of a specified Neptune Analytics graph
     * </p>
     *
     * @param updateGraphRequest
     * @return Result of the UpdateGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.UpdateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UpdateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGraphResponse updateGraph(UpdateGraphRequest updateGraphRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the configuration of a specified Neptune Analytics graph
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGraphRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateGraphRequest#builder()}
     * </p>
     *
     * @param updateGraphRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.neptunegraph.model.UpdateGraphRequest.Builder} to create a request.
     * @return Result of the UpdateGraph operation returned by the service.
     * @throws ThrottlingException
     *         The exception was interrupted by throttling.
     * @throws ValidationException
     *         A resource could not be validated.
     * @throws ConflictException
     *         Raised when a conflict is encountered.
     * @throws InternalServerException
     *         A failure occurred on the server.
     * @throws ResourceNotFoundException
     *         A specified resource could not be located.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws NeptuneGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample NeptuneGraphClient.UpdateGraph
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/neptune-graph-2023-11-29/UpdateGraph" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGraphResponse updateGraph(Consumer<UpdateGraphRequest.Builder> updateGraphRequest) throws ThrottlingException,
            ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, NeptuneGraphException {
        return updateGraph(UpdateGraphRequest.builder().applyMutation(updateGraphRequest).build());
    }

    /**
     * Create an instance of {@link NeptuneGraphWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link NeptuneGraphWaiter}
     */
    default NeptuneGraphWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link NeptuneGraphClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static NeptuneGraphClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptuneGraphClient}.
     */
    static NeptuneGraphClientBuilder builder() {
        return new DefaultNeptuneGraphClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default NeptuneGraphServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
