/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecuteQueryRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<ExecuteQueryRequest.Builder, ExecuteQueryRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(ExecuteQueryRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("graphIdentifier").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(ExecuteQueryRequest::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()).build();

    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(ExecuteQueryRequest::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<Map<String, Document>> PARAMETERS_FIELD = SdkField
            .<Map<String, Document>> builder(MarshallingType.MAP)
            .memberName("parameters")
            .getter(getter(ExecuteQueryRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PLAN_CACHE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planCache").getter(getter(ExecuteQueryRequest::planCacheAsString)).setter(setter(Builder::planCache))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planCache").build()).build();

    private static final SdkField<String> EXPLAIN_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("explainMode").getter(getter(ExecuteQueryRequest::explainModeAsString))
            .setter(setter(Builder::explainMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("explain").build()).build();

    private static final SdkField<Integer> QUERY_TIMEOUT_MILLISECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("queryTimeoutMilliseconds").getter(getter(ExecuteQueryRequest::queryTimeoutMilliseconds))
            .setter(setter(Builder::queryTimeoutMilliseconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryTimeoutMilliseconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD,
            QUERY_STRING_FIELD, LANGUAGE_FIELD, PARAMETERS_FIELD, PLAN_CACHE_FIELD, EXPLAIN_MODE_FIELD,
            QUERY_TIMEOUT_MILLISECONDS_FIELD));

    private final String graphIdentifier;

    private final String queryString;

    private final String language;

    private final Map<String, Document> parameters;

    private final String planCache;

    private final String explainMode;

    private final Integer queryTimeoutMilliseconds;

    private ExecuteQueryRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.queryString = builder.queryString;
        this.language = builder.language;
        this.parameters = builder.parameters;
        this.planCache = builder.planCache;
        this.explainMode = builder.explainMode;
        this.queryTimeoutMilliseconds = builder.queryTimeoutMilliseconds;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * The query string to be executed.
     * </p>
     * 
     * @return The query string to be executed.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The query language the query is written in. Currently only openCypher is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The query language the query is written in. Currently only openCypher is supported.
     * @see QueryLanguage
     */
    public final QueryLanguage language() {
        return QueryLanguage.fromValue(language);
    }

    /**
     * <p>
     * The query language the query is written in. Currently only openCypher is supported.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link QueryLanguage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The query language the query is written in. Currently only openCypher is supported.
     * @see QueryLanguage
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The data parameters the query can use in JSON format. For example: {"name": "john", "age": 20}. (optional)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The data parameters the query can use in JSON format. For example: {"name": "john", "age": 20}.
     *         (optional)
     */
    public final Map<String, Document> parameters() {
        return parameters;
    }

    /**
     * <p>
     * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same query.
     * This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code> queries. The plan cache
     * is an LRU cache with a 5 minute TTL and a capacity of 1000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planCache} will
     * return {@link PlanCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planCacheAsString}.
     * </p>
     * 
     * @return Query plan cache is a feature that saves the query plan and reuses it on successive executions of the
     *         same query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code>
     *         queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
     * @see PlanCacheType
     */
    public final PlanCacheType planCache() {
        return PlanCacheType.fromValue(planCache);
    }

    /**
     * <p>
     * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same query.
     * This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code> queries. The plan cache
     * is an LRU cache with a 5 minute TTL and a capacity of 1000.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #planCache} will
     * return {@link PlanCacheType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #planCacheAsString}.
     * </p>
     * 
     * @return Query plan cache is a feature that saves the query plan and reuses it on successive executions of the
     *         same query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code>
     *         queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
     * @see PlanCacheType
     */
    public final String planCacheAsString() {
        return planCache;
    }

    /**
     * <p>
     * The explain mode parameter returns a query explain instead of the actual query results. A query explain can be
     * used to gather insights about the query execution such as planning decisions, time spent on each operator,
     * solutions flowing etc.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #explainMode} will
     * return {@link ExplainMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #explainModeAsString}.
     * </p>
     * 
     * @return The explain mode parameter returns a query explain instead of the actual query results. A query explain
     *         can be used to gather insights about the query execution such as planning decisions, time spent on each
     *         operator, solutions flowing etc.
     * @see ExplainMode
     */
    public final ExplainMode explainMode() {
        return ExplainMode.fromValue(explainMode);
    }

    /**
     * <p>
     * The explain mode parameter returns a query explain instead of the actual query results. A query explain can be
     * used to gather insights about the query execution such as planning decisions, time spent on each operator,
     * solutions flowing etc.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #explainMode} will
     * return {@link ExplainMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #explainModeAsString}.
     * </p>
     * 
     * @return The explain mode parameter returns a query explain instead of the actual query results. A query explain
     *         can be used to gather insights about the query execution such as planning decisions, time spent on each
     *         operator, solutions flowing etc.
     * @see ExplainMode
     */
    public final String explainModeAsString() {
        return explainMode;
    }

    /**
     * <p>
     * Specifies the query timeout duration, in milliseconds. (optional)
     * </p>
     * 
     * @return Specifies the query timeout duration, in milliseconds. (optional)
     */
    public final Integer queryTimeoutMilliseconds() {
        return queryTimeoutMilliseconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(planCacheAsString());
        hashCode = 31 * hashCode + Objects.hashCode(explainModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(queryTimeoutMilliseconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecuteQueryRequest)) {
            return false;
        }
        ExecuteQueryRequest other = (ExecuteQueryRequest) obj;
        return Objects.equals(graphIdentifier(), other.graphIdentifier()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(languageAsString(), other.languageAsString()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(planCacheAsString(), other.planCacheAsString())
                && Objects.equals(explainModeAsString(), other.explainModeAsString())
                && Objects.equals(queryTimeoutMilliseconds(), other.queryTimeoutMilliseconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecuteQueryRequest").add("GraphIdentifier", graphIdentifier())
                .add("QueryString", queryString()).add("Language", languageAsString())
                .add("Parameters", hasParameters() ? parameters() : null).add("PlanCache", planCacheAsString())
                .add("ExplainMode", explainModeAsString()).add("QueryTimeoutMilliseconds", queryTimeoutMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "planCache":
            return Optional.ofNullable(clazz.cast(planCacheAsString()));
        case "explainMode":
            return Optional.ofNullable(clazz.cast(explainModeAsString()));
        case "queryTimeoutMilliseconds":
            return Optional.ofNullable(clazz.cast(queryTimeoutMilliseconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExecuteQueryRequest, T> g) {
        return obj -> g.apply((ExecuteQueryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, ExecuteQueryRequest> {
        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphIdentifier
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * The query string to be executed.
         * </p>
         * 
         * @param queryString
         *        The query string to be executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The query language the query is written in. Currently only openCypher is supported.
         * </p>
         * 
         * @param language
         *        The query language the query is written in. Currently only openCypher is supported.
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder language(String language);

        /**
         * <p>
         * The query language the query is written in. Currently only openCypher is supported.
         * </p>
         * 
         * @param language
         *        The query language the query is written in. Currently only openCypher is supported.
         * @see QueryLanguage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryLanguage
         */
        Builder language(QueryLanguage language);

        /**
         * <p>
         * The data parameters the query can use in JSON format. For example: {"name": "john", "age": 20}. (optional)
         * </p>
         * 
         * @param parameters
         *        The data parameters the query can use in JSON format. For example: {"name": "john", "age": 20}.
         *        (optional)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, Document> parameters);

        /**
         * <p>
         * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same
         * query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code> queries. The
         * plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
         * </p>
         * 
         * @param planCache
         *        Query plan cache is a feature that saves the query plan and reuses it on successive executions of the
         *        same query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code>
         *        queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
         * @see PlanCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlanCacheType
         */
        Builder planCache(String planCache);

        /**
         * <p>
         * Query plan cache is a feature that saves the query plan and reuses it on successive executions of the same
         * query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code> queries. The
         * plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
         * </p>
         * 
         * @param planCache
         *        Query plan cache is a feature that saves the query plan and reuses it on successive executions of the
         *        same query. This reduces query latency, and works for both <code>READ</code> and <code>UPDATE</code>
         *        queries. The plan cache is an LRU cache with a 5 minute TTL and a capacity of 1000.
         * @see PlanCacheType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlanCacheType
         */
        Builder planCache(PlanCacheType planCache);

        /**
         * <p>
         * The explain mode parameter returns a query explain instead of the actual query results. A query explain can
         * be used to gather insights about the query execution such as planning decisions, time spent on each operator,
         * solutions flowing etc.
         * </p>
         * 
         * @param explainMode
         *        The explain mode parameter returns a query explain instead of the actual query results. A query
         *        explain can be used to gather insights about the query execution such as planning decisions, time
         *        spent on each operator, solutions flowing etc.
         * @see ExplainMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExplainMode
         */
        Builder explainMode(String explainMode);

        /**
         * <p>
         * The explain mode parameter returns a query explain instead of the actual query results. A query explain can
         * be used to gather insights about the query execution such as planning decisions, time spent on each operator,
         * solutions flowing etc.
         * </p>
         * 
         * @param explainMode
         *        The explain mode parameter returns a query explain instead of the actual query results. A query
         *        explain can be used to gather insights about the query execution such as planning decisions, time
         *        spent on each operator, solutions flowing etc.
         * @see ExplainMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExplainMode
         */
        Builder explainMode(ExplainMode explainMode);

        /**
         * <p>
         * Specifies the query timeout duration, in milliseconds. (optional)
         * </p>
         * 
         * @param queryTimeoutMilliseconds
         *        Specifies the query timeout duration, in milliseconds. (optional)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryTimeoutMilliseconds(Integer queryTimeoutMilliseconds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphIdentifier;

        private String queryString;

        private String language;

        private Map<String, Document> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String planCache;

        private String explainMode;

        private Integer queryTimeoutMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecuteQueryRequest model) {
            super(model);
            graphIdentifier(model.graphIdentifier);
            queryString(model.queryString);
            language(model.language);
            parameters(model.parameters);
            planCache(model.planCache);
            explainMode(model.explainMode);
            queryTimeoutMilliseconds(model.queryTimeoutMilliseconds);
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final String getLanguage() {
            return language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(QueryLanguage language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final Map<String, Document> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, Document> parameters) {
            this.parameters = DocumentValuedMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, Document> parameters) {
            this.parameters = DocumentValuedMapCopier.copy(parameters);
            return this;
        }

        public final String getPlanCache() {
            return planCache;
        }

        public final void setPlanCache(String planCache) {
            this.planCache = planCache;
        }

        @Override
        public final Builder planCache(String planCache) {
            this.planCache = planCache;
            return this;
        }

        @Override
        public final Builder planCache(PlanCacheType planCache) {
            this.planCache(planCache == null ? null : planCache.toString());
            return this;
        }

        public final String getExplainMode() {
            return explainMode;
        }

        public final void setExplainMode(String explainMode) {
            this.explainMode = explainMode;
        }

        @Override
        public final Builder explainMode(String explainMode) {
            this.explainMode = explainMode;
            return this;
        }

        @Override
        public final Builder explainMode(ExplainMode explainMode) {
            this.explainMode(explainMode == null ? null : explainMode.toString());
            return this;
        }

        public final Integer getQueryTimeoutMilliseconds() {
            return queryTimeoutMilliseconds;
        }

        public final void setQueryTimeoutMilliseconds(Integer queryTimeoutMilliseconds) {
            this.queryTimeoutMilliseconds = queryTimeoutMilliseconds;
        }

        @Override
        public final Builder queryTimeoutMilliseconds(Integer queryTimeoutMilliseconds) {
            this.queryTimeoutMilliseconds = queryTimeoutMilliseconds;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExecuteQueryRequest build() {
            return new ExecuteQueryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
