/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGraphSummaryRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<GetGraphSummaryRequest.Builder, GetGraphSummaryRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(GetGraphSummaryRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("graphIdentifier").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(GetGraphSummaryRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("mode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD,
            MODE_FIELD));

    private final String graphIdentifier;

    private final String mode;

    private GetGraphSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.mode = builder.mode;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link GraphSummaryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
     * @see GraphSummaryMode
     */
    public final GraphSummaryMode mode() {
        return GraphSummaryMode.fromValue(mode);
    }

    /**
     * <p>
     * The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link GraphSummaryMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
     * @see GraphSummaryMode
     */
    public final String modeAsString() {
        return mode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGraphSummaryRequest)) {
            return false;
        }
        GetGraphSummaryRequest other = (GetGraphSummaryRequest) obj;
        return Objects.equals(graphIdentifier(), other.graphIdentifier()) && Objects.equals(modeAsString(), other.modeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetGraphSummaryRequest").add("GraphIdentifier", graphIdentifier()).add("Mode", modeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGraphSummaryRequest, T> g) {
        return obj -> g.apply((GetGraphSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetGraphSummaryRequest> {
        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphIdentifier
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
         * </p>
         * 
         * @param mode
         *        The summary mode can take one of two values: <code>basic</code> (the default), and
         *        <code>detailed</code>.
         * @see GraphSummaryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphSummaryMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The summary mode can take one of two values: <code>basic</code> (the default), and <code>detailed</code>.
         * </p>
         * 
         * @param mode
         *        The summary mode can take one of two values: <code>basic</code> (the default), and
         *        <code>detailed</code>.
         * @see GraphSummaryMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphSummaryMode
         */
        Builder mode(GraphSummaryMode mode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphIdentifier;

        private String mode;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGraphSummaryRequest model) {
            super(model);
            graphIdentifier(model.graphIdentifier);
            mode(model.mode);
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(GraphSummaryMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGraphSummaryRequest build() {
            return new GetGraphSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
