/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphAsyncClient;
import software.amazon.awssdk.services.neptunegraph.internal.UserAgentUtils;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsRequest;
import software.amazon.awssdk.services.neptunegraph.model.ListPrivateGraphEndpointsResponse;
import software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary;

public class ListPrivateGraphEndpointsPublisher
implements SdkPublisher<ListPrivateGraphEndpointsResponse> {
    private final NeptuneGraphAsyncClient client;
    private final ListPrivateGraphEndpointsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPrivateGraphEndpointsPublisher(NeptuneGraphAsyncClient client, ListPrivateGraphEndpointsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPrivateGraphEndpointsPublisher(NeptuneGraphAsyncClient client, ListPrivateGraphEndpointsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPrivateGraphEndpointsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPrivateGraphEndpointsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PrivateGraphEndpointSummary> privateGraphEndpoints() {
        Function<ListPrivateGraphEndpointsResponse, Iterator> getIterator = response -> {
            if (response != null && response.privateGraphEndpoints() != null) {
                return response.privateGraphEndpoints().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListPrivateGraphEndpointsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListPrivateGraphEndpointsResponseFetcher
    implements AsyncPageFetcher<ListPrivateGraphEndpointsResponse> {
        private ListPrivateGraphEndpointsResponseFetcher() {
        }

        public boolean hasNextPage(ListPrivateGraphEndpointsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPrivateGraphEndpointsResponse> nextPage(ListPrivateGraphEndpointsResponse previousPage) {
            if (previousPage == null) {
                return ListPrivateGraphEndpointsPublisher.this.client.listPrivateGraphEndpoints(ListPrivateGraphEndpointsPublisher.this.firstRequest);
            }
            return ListPrivateGraphEndpointsPublisher.this.client.listPrivateGraphEndpoints((ListPrivateGraphEndpointsRequest)((Object)ListPrivateGraphEndpointsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

