/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGraphResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<CreateGraphResponse.Builder, CreateGraphResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateGraphResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGraphResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateGraphResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGraphResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CreateGraphResponse::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createTime").getter(getter(CreateGraphResponse::createTime)).setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()).build();

    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedMemory").getter(getter(CreateGraphResponse::provisionedMemory))
            .setter(setter(Builder::provisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(CreateGraphResponse::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(CreateGraphResponse::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField
            .<VectorSearchConfiguration> builder(MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration")
            .getter(getter(CreateGraphResponse::vectorSearchConfiguration)).setter(setter(Builder::vectorSearchConfiguration))
            .constructor(VectorSearchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build())
            .build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("replicaCount").getter(getter(CreateGraphResponse::replicaCount)).setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CreateGraphResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<String> SOURCE_SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceSnapshotId").getter(getter(CreateGraphResponse::sourceSnapshotId))
            .setter(setter(Builder::sourceSnapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotId").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(CreateGraphResponse::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final SdkField<String> BUILD_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildNumber").getter(getter(CreateGraphResponse::buildNumber)).setter(setter(Builder::buildNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATE_TIME_FIELD, PROVISIONED_MEMORY_FIELD, ENDPOINT_FIELD,
            PUBLIC_CONNECTIVITY_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD, KMS_KEY_IDENTIFIER_FIELD,
            SOURCE_SNAPSHOT_ID_FIELD, DELETION_PROTECTION_FIELD, BUILD_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("id", ID_FIELD);
                    put("name", NAME_FIELD);
                    put("arn", ARN_FIELD);
                    put("status", STATUS_FIELD);
                    put("statusReason", STATUS_REASON_FIELD);
                    put("createTime", CREATE_TIME_FIELD);
                    put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
                    put("endpoint", ENDPOINT_FIELD);
                    put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
                    put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
                    put("replicaCount", REPLICA_COUNT_FIELD);
                    put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
                    put("sourceSnapshotId", SOURCE_SNAPSHOT_ID_FIELD);
                    put("deletionProtection", DELETION_PROTECTION_FIELD);
                    put("buildNumber", BUILD_NUMBER_FIELD);
                }
            });

    private final String id;

    private final String name;

    private final String arn;

    private final String status;

    private final String statusReason;

    private final Instant createTime;

    private final Integer provisionedMemory;

    private final String endpoint;

    private final Boolean publicConnectivity;

    private final VectorSearchConfiguration vectorSearchConfiguration;

    private final Integer replicaCount;

    private final String kmsKeyIdentifier;

    private final String sourceSnapshotId;

    private final Boolean deletionProtection;

    private final String buildNumber;

    private CreateGraphResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createTime = builder.createTime;
        this.provisionedMemory = builder.provisionedMemory;
        this.endpoint = builder.endpoint;
        this.publicConnectivity = builder.publicConnectivity;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.sourceSnapshotId = builder.sourceSnapshotId;
        this.deletionProtection = builder.deletionProtection;
        this.buildNumber = builder.buildNumber;
    }

    /**
     * <p>
     * The ID of the graph.
     * </p>
     * 
     * @return The ID of the graph.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The graph name. For example: <code>my-graph-1</code>.
     * </p>
     * <p>
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
     * cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return The graph name. For example: <code>my-graph-1</code>.</p>
     *         <p>
     *         The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
     *         letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the graph.
     * </p>
     * 
     * @return The ARN of the graph.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The current status of the graph.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GraphStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the graph.
     * @see GraphStatus
     */
    public final GraphStatus status() {
        return GraphStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the graph.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GraphStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the graph.
     * @see GraphStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The reason the status was given.
     * </p>
     * 
     * @return The reason the status was given.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The time when the graph was created.
     * </p>
     * 
     * @return The time when the graph was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     * </p>
     * <p>
     * Min = 128
     * </p>
     * 
     * @return The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
     *         <p>
     *         Min = 128
     */
    public final Integer provisionedMemory() {
        return provisionedMemory;
    }

    /**
     * <p>
     * The graph endpoint.
     * </p>
     * 
     * @return The graph endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * </p>
     * <note>
     * <p>
     * If enabling public connectivity for the first time, there will be a delay while it is enabled.
     * </p>
     * </note>
     * 
     * @return Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
     *         authenticated.</p> <note>
     *         <p>
     *         If enabling public connectivity for the first time, there will be a delay while it is enabled.
     *         </p>
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    /**
     * <p>
     * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector index,
     * if any.
     * </p>
     * 
     * @return The vector-search configuration for the graph, which specifies the vector dimension to use in the vector
     *         index, if any.
     */
    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return vectorSearchConfiguration;
    }

    /**
     * <p>
     * The number of replicas in other AZs.
     * </p>
     * <p>
     * Default: If not specified, the default value is 1.
     * </p>
     * 
     * @return The number of replicas in other AZs.</p>
     *         <p>
     *         Default: If not specified, the default value is 1.
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    /**
     * <p>
     * Specifies the KMS key used to encrypt data in the new graph.
     * </p>
     * 
     * @return Specifies the KMS key used to encrypt data in the new graph.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * The ID of the source graph.
     * </p>
     * 
     * @return The ID of the source graph.
     */
    public final String sourceSnapshotId() {
        return sourceSnapshotId;
    }

    /**
     * <p>
     * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     * deletion protection is enabled.
     * </p>
     * 
     * @return A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     *         deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The build number of the graph software.
     * </p>
     * 
     * @return The build number of the graph software.
     */
    public final String buildNumber() {
        return buildNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sourceSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(buildNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphResponse)) {
            return false;
        }
        CreateGraphResponse other = (CreateGraphResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(createTime(), other.createTime())
                && Objects.equals(provisionedMemory(), other.provisionedMemory()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(publicConnectivity(), other.publicConnectivity())
                && Objects.equals(vectorSearchConfiguration(), other.vectorSearchConfiguration())
                && Objects.equals(replicaCount(), other.replicaCount())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(sourceSnapshotId(), other.sourceSnapshotId())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(buildNumber(), other.buildNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGraphResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("CreateTime", createTime())
                .add("ProvisionedMemory", provisionedMemory()).add("Endpoint", endpoint())
                .add("PublicConnectivity", publicConnectivity()).add("VectorSearchConfiguration", vectorSearchConfiguration())
                .add("ReplicaCount", replicaCount()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("SourceSnapshotId", sourceSnapshotId()).add("DeletionProtection", deletionProtection())
                .add("BuildNumber", buildNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "createTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "provisionedMemory":
            return Optional.ofNullable(clazz.cast(provisionedMemory()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        case "vectorSearchConfiguration":
            return Optional.ofNullable(clazz.cast(vectorSearchConfiguration()));
        case "replicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "sourceSnapshotId":
            return Optional.ofNullable(clazz.cast(sourceSnapshotId()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "buildNumber":
            return Optional.ofNullable(clazz.cast(buildNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphResponse, T> g) {
        return obj -> g.apply((CreateGraphResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGraphResponse> {
        /**
         * <p>
         * The ID of the graph.
         * </p>
         * 
         * @param id
         *        The ID of the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The graph name. For example: <code>my-graph-1</code>.
         * </p>
         * <p>
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
         * cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param name
         *        The graph name. For example: <code>my-graph-1</code>.</p>
         *        <p>
         *        The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
         *        letter. It cannot end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the graph.
         * </p>
         * 
         * @param arn
         *        The ARN of the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The current status of the graph.
         * </p>
         * 
         * @param status
         *        The current status of the graph.
         * @see GraphStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the graph.
         * </p>
         * 
         * @param status
         *        The current status of the graph.
         * @see GraphStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphStatus
         */
        Builder status(GraphStatus status);

        /**
         * <p>
         * The reason the status was given.
         * </p>
         * 
         * @param statusReason
         *        The reason the status was given.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The time when the graph was created.
         * </p>
         * 
         * @param createTime
         *        The time when the graph was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         * </p>
         * <p>
         * Min = 128
         * </p>
         * 
         * @param provisionedMemory
         *        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
         *        <p>
         *        Min = 128
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedMemory(Integer provisionedMemory);

        /**
         * <p>
         * The graph endpoint.
         * </p>
         * 
         * @param endpoint
         *        The graph endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         * authenticated.
         * </p>
         * <note>
         * <p>
         * If enabling public connectivity for the first time, there will be a delay while it is enabled.
         * </p>
         * </note>
         * 
         * @param publicConnectivity
         *        Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         *        authenticated.</p> <note>
         *        <p>
         *        If enabling public connectivity for the first time, there will be a delay while it is enabled.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        /**
         * <p>
         * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector
         * index, if any.
         * </p>
         * 
         * @param vectorSearchConfiguration
         *        The vector-search configuration for the graph, which specifies the vector dimension to use in the
         *        vector index, if any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration);

        /**
         * <p>
         * The vector-search configuration for the graph, which specifies the vector dimension to use in the vector
         * index, if any.
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorSearchConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorSearchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vectorSearchConfiguration(VectorSearchConfiguration)}.
         * 
         * @param vectorSearchConfiguration
         *        a consumer that will call methods on {@link VectorSearchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorSearchConfiguration(VectorSearchConfiguration)
         */
        default Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return vectorSearchConfiguration(VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration).build());
        }

        /**
         * <p>
         * The number of replicas in other AZs.
         * </p>
         * <p>
         * Default: If not specified, the default value is 1.
         * </p>
         * 
         * @param replicaCount
         *        The number of replicas in other AZs.</p>
         *        <p>
         *        Default: If not specified, the default value is 1.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);

        /**
         * <p>
         * Specifies the KMS key used to encrypt data in the new graph.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        Specifies the KMS key used to encrypt data in the new graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * The ID of the source graph.
         * </p>
         * 
         * @param sourceSnapshotId
         *        The ID of the source graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotId(String sourceSnapshotId);

        /**
         * <p>
         * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
         * deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted
         *        when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The build number of the graph software.
         * </p>
         * 
         * @param buildNumber
         *        The build number of the graph software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder buildNumber(String buildNumber);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String status;

        private String statusReason;

        private Instant createTime;

        private Integer provisionedMemory;

        private String endpoint;

        private Boolean publicConnectivity;

        private VectorSearchConfiguration vectorSearchConfiguration;

        private Integer replicaCount;

        private String kmsKeyIdentifier;

        private String sourceSnapshotId;

        private Boolean deletionProtection;

        private String buildNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            status(model.status);
            statusReason(model.statusReason);
            createTime(model.createTime);
            provisionedMemory(model.provisionedMemory);
            endpoint(model.endpoint);
            publicConnectivity(model.publicConnectivity);
            vectorSearchConfiguration(model.vectorSearchConfiguration);
            replicaCount(model.replicaCount);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            sourceSnapshotId(model.sourceSnapshotId);
            deletionProtection(model.deletionProtection);
            buildNumber(model.buildNumber);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GraphStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return vectorSearchConfiguration != null ? vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getSourceSnapshotId() {
            return sourceSnapshotId;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getBuildNumber() {
            return buildNumber;
        }

        public final void setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
        }

        @Override
        public final Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @Override
        public CreateGraphResponse build() {
            return new CreateGraphResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
