/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about an import task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportTaskDetails.Builder, ImportTaskDetails> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImportTaskDetails::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ImportTaskDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> TIME_ELAPSED_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeElapsedSeconds").getter(getter(ImportTaskDetails::timeElapsedSeconds))
            .setter(setter(Builder::timeElapsedSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeElapsedSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRESS_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("progressPercentage").getter(getter(ImportTaskDetails::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build())
            .build();

    private static final SdkField<Integer> ERROR_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("errorCount").getter(getter(ImportTaskDetails::errorCount)).setter(setter(Builder::errorCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCount").build()).build();

    private static final SdkField<String> ERROR_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorDetails").getter(getter(ImportTaskDetails::errorDetails)).setter(setter(Builder::errorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorDetails").build()).build();

    private static final SdkField<Long> STATEMENT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("statementCount").getter(getter(ImportTaskDetails::statementCount))
            .setter(setter(Builder::statementCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementCount").build()).build();

    private static final SdkField<Long> DICTIONARY_ENTRY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("dictionaryEntryCount").getter(getter(ImportTaskDetails::dictionaryEntryCount))
            .setter(setter(Builder::dictionaryEntryCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dictionaryEntryCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            START_TIME_FIELD, TIME_ELAPSED_SECONDS_FIELD, PROGRESS_PERCENTAGE_FIELD, ERROR_COUNT_FIELD, ERROR_DETAILS_FIELD,
            STATEMENT_COUNT_FIELD, DICTIONARY_ENTRY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("status", STATUS_FIELD);
                    put("startTime", START_TIME_FIELD);
                    put("timeElapsedSeconds", TIME_ELAPSED_SECONDS_FIELD);
                    put("progressPercentage", PROGRESS_PERCENTAGE_FIELD);
                    put("errorCount", ERROR_COUNT_FIELD);
                    put("errorDetails", ERROR_DETAILS_FIELD);
                    put("statementCount", STATEMENT_COUNT_FIELD);
                    put("dictionaryEntryCount", DICTIONARY_ENTRY_COUNT_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Instant startTime;

    private final Long timeElapsedSeconds;

    private final Integer progressPercentage;

    private final Integer errorCount;

    private final String errorDetails;

    private final Long statementCount;

    private final Long dictionaryEntryCount;

    private ImportTaskDetails(BuilderImpl builder) {
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.timeElapsedSeconds = builder.timeElapsedSeconds;
        this.progressPercentage = builder.progressPercentage;
        this.errorCount = builder.errorCount;
        this.errorDetails = builder.errorDetails;
        this.statementCount = builder.statementCount;
        this.dictionaryEntryCount = builder.dictionaryEntryCount;
    }

    /**
     * <p>
     * Status of the import task.
     * </p>
     * 
     * @return Status of the import task.
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * Time at which the import task started.
     * </p>
     * 
     * @return Time at which the import task started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * Seconds elapsed since the import task started.
     * </p>
     * 
     * @return Seconds elapsed since the import task started.
     */
    public final Long timeElapsedSeconds() {
        return timeElapsedSeconds;
    }

    /**
     * <p>
     * The percentage progress so far.
     * </p>
     * 
     * @return The percentage progress so far.
     */
    public final Integer progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * The number of errors encountered so far.
     * </p>
     * 
     * @return The number of errors encountered so far.
     */
    public final Integer errorCount() {
        return errorCount;
    }

    /**
     * <p>
     * Details about the errors that have been encountered.
     * </p>
     * 
     * @return Details about the errors that have been encountered.
     */
    public final String errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * The number of statements in the import task.
     * </p>
     * 
     * @return The number of statements in the import task.
     */
    public final Long statementCount() {
        return statementCount;
    }

    /**
     * <p>
     * The number of dictionary entries in the import task.
     * </p>
     * 
     * @return The number of dictionary entries in the import task.
     */
    public final Long dictionaryEntryCount() {
        return dictionaryEntryCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeElapsedSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(errorCount());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(statementCount());
        hashCode = 31 * hashCode + Objects.hashCode(dictionaryEntryCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportTaskDetails)) {
            return false;
        }
        ImportTaskDetails other = (ImportTaskDetails) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(timeElapsedSeconds(), other.timeElapsedSeconds())
                && Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(errorCount(), other.errorCount()) && Objects.equals(errorDetails(), other.errorDetails())
                && Objects.equals(statementCount(), other.statementCount())
                && Objects.equals(dictionaryEntryCount(), other.dictionaryEntryCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportTaskDetails").add("Status", status()).add("StartTime", startTime())
                .add("TimeElapsedSeconds", timeElapsedSeconds()).add("ProgressPercentage", progressPercentage())
                .add("ErrorCount", errorCount()).add("ErrorDetails", errorDetails()).add("StatementCount", statementCount())
                .add("DictionaryEntryCount", dictionaryEntryCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "timeElapsedSeconds":
            return Optional.ofNullable(clazz.cast(timeElapsedSeconds()));
        case "progressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "errorCount":
            return Optional.ofNullable(clazz.cast(errorCount()));
        case "errorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "statementCount":
            return Optional.ofNullable(clazz.cast(statementCount()));
        case "dictionaryEntryCount":
            return Optional.ofNullable(clazz.cast(dictionaryEntryCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ImportTaskDetails, T> g) {
        return obj -> g.apply((ImportTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportTaskDetails> {
        /**
         * <p>
         * Status of the import task.
         * </p>
         * 
         * @param status
         *        Status of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * Time at which the import task started.
         * </p>
         * 
         * @param startTime
         *        Time at which the import task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * Seconds elapsed since the import task started.
         * </p>
         * 
         * @param timeElapsedSeconds
         *        Seconds elapsed since the import task started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeElapsedSeconds(Long timeElapsedSeconds);

        /**
         * <p>
         * The percentage progress so far.
         * </p>
         * 
         * @param progressPercentage
         *        The percentage progress so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Integer progressPercentage);

        /**
         * <p>
         * The number of errors encountered so far.
         * </p>
         * 
         * @param errorCount
         *        The number of errors encountered so far.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCount(Integer errorCount);

        /**
         * <p>
         * Details about the errors that have been encountered.
         * </p>
         * 
         * @param errorDetails
         *        Details about the errors that have been encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(String errorDetails);

        /**
         * <p>
         * The number of statements in the import task.
         * </p>
         * 
         * @param statementCount
         *        The number of statements in the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementCount(Long statementCount);

        /**
         * <p>
         * The number of dictionary entries in the import task.
         * </p>
         * 
         * @param dictionaryEntryCount
         *        The number of dictionary entries in the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dictionaryEntryCount(Long dictionaryEntryCount);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Instant startTime;

        private Long timeElapsedSeconds;

        private Integer progressPercentage;

        private Integer errorCount;

        private String errorDetails;

        private Long statementCount;

        private Long dictionaryEntryCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportTaskDetails model) {
            status(model.status);
            startTime(model.startTime);
            timeElapsedSeconds(model.timeElapsedSeconds);
            progressPercentage(model.progressPercentage);
            errorCount(model.errorCount);
            errorDetails(model.errorDetails);
            statementCount(model.statementCount);
            dictionaryEntryCount(model.dictionaryEntryCount);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getTimeElapsedSeconds() {
            return timeElapsedSeconds;
        }

        public final void setTimeElapsedSeconds(Long timeElapsedSeconds) {
            this.timeElapsedSeconds = timeElapsedSeconds;
        }

        @Override
        public final Builder timeElapsedSeconds(Long timeElapsedSeconds) {
            this.timeElapsedSeconds = timeElapsedSeconds;
            return this;
        }

        public final Integer getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final Integer getErrorCount() {
            return errorCount;
        }

        public final void setErrorCount(Integer errorCount) {
            this.errorCount = errorCount;
        }

        @Override
        public final Builder errorCount(Integer errorCount) {
            this.errorCount = errorCount;
            return this;
        }

        public final String getErrorDetails() {
            return errorDetails;
        }

        public final void setErrorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public final Builder errorDetails(String errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final Long getStatementCount() {
            return statementCount;
        }

        public final void setStatementCount(Long statementCount) {
            this.statementCount = statementCount;
        }

        @Override
        public final Builder statementCount(Long statementCount) {
            this.statementCount = statementCount;
            return this;
        }

        public final Long getDictionaryEntryCount() {
            return dictionaryEntryCount;
        }

        public final void setDictionaryEntryCount(Long dictionaryEntryCount) {
            this.dictionaryEntryCount = dictionaryEntryCount;
        }

        @Override
        public final Builder dictionaryEntryCount(Long dictionaryEntryCount) {
            this.dictionaryEntryCount = dictionaryEntryCount;
            return this;
        }

        @Override
        public ImportTaskDetails build() {
            return new ImportTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
