/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPrivateGraphEndpointsResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<ListPrivateGraphEndpointsResponse.Builder, ListPrivateGraphEndpointsResponse> {
    private static final SdkField<List<PrivateGraphEndpointSummary>> PRIVATE_GRAPH_ENDPOINTS_FIELD = SdkField
            .<List<PrivateGraphEndpointSummary>> builder(MarshallingType.LIST)
            .memberName("privateGraphEndpoints")
            .getter(getter(ListPrivateGraphEndpointsResponse::privateGraphEndpoints))
            .setter(setter(Builder::privateGraphEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privateGraphEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PrivateGraphEndpointSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(PrivateGraphEndpointSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPrivateGraphEndpointsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIVATE_GRAPH_ENDPOINTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("privateGraphEndpoints", PRIVATE_GRAPH_ENDPOINTS_FIELD);
                    put("nextToken", NEXT_TOKEN_FIELD);
                }
            });

    private final List<PrivateGraphEndpointSummary> privateGraphEndpoints;

    private final String nextToken;

    private ListPrivateGraphEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.privateGraphEndpoints = builder.privateGraphEndpoints;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PrivateGraphEndpoints property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPrivateGraphEndpoints() {
        return privateGraphEndpoints != null && !(privateGraphEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of private endpoints for the specified Neptune Analytics graph.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrivateGraphEndpoints} method.
     * </p>
     * 
     * @return A list of private endpoints for the specified Neptune Analytics graph.
     */
    public final List<PrivateGraphEndpointSummary> privateGraphEndpoints() {
        return privateGraphEndpoints;
    }

    /**
     * <p>
     * Pagination token used to paginate output.
     * </p>
     * <p>
     * When this value is provided as input, the service returns results from where the previous response left off. When
     * this value is present in output, it indicates that there are more results to retrieve.
     * </p>
     * 
     * @return Pagination token used to paginate output.</p>
     *         <p>
     *         When this value is provided as input, the service returns results from where the previous response left
     *         off. When this value is present in output, it indicates that there are more results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPrivateGraphEndpoints() ? privateGraphEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrivateGraphEndpointsResponse)) {
            return false;
        }
        ListPrivateGraphEndpointsResponse other = (ListPrivateGraphEndpointsResponse) obj;
        return hasPrivateGraphEndpoints() == other.hasPrivateGraphEndpoints()
                && Objects.equals(privateGraphEndpoints(), other.privateGraphEndpoints())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPrivateGraphEndpointsResponse")
                .add("PrivateGraphEndpoints", hasPrivateGraphEndpoints() ? privateGraphEndpoints() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "privateGraphEndpoints":
            return Optional.ofNullable(clazz.cast(privateGraphEndpoints()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListPrivateGraphEndpointsResponse, T> g) {
        return obj -> g.apply((ListPrivateGraphEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPrivateGraphEndpointsResponse> {
        /**
         * <p>
         * A list of private endpoints for the specified Neptune Analytics graph.
         * </p>
         * 
         * @param privateGraphEndpoints
         *        A list of private endpoints for the specified Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateGraphEndpoints(Collection<PrivateGraphEndpointSummary> privateGraphEndpoints);

        /**
         * <p>
         * A list of private endpoints for the specified Neptune Analytics graph.
         * </p>
         * 
         * @param privateGraphEndpoints
         *        A list of private endpoints for the specified Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateGraphEndpoints(PrivateGraphEndpointSummary... privateGraphEndpoints);

        /**
         * <p>
         * A list of private endpoints for the specified Neptune Analytics graph.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #privateGraphEndpoints(List<PrivateGraphEndpointSummary>)}.
         * 
         * @param privateGraphEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunegraph.model.PrivateGraphEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #privateGraphEndpoints(java.util.Collection<PrivateGraphEndpointSummary>)
         */
        Builder privateGraphEndpoints(Consumer<PrivateGraphEndpointSummary.Builder>... privateGraphEndpoints);

        /**
         * <p>
         * Pagination token used to paginate output.
         * </p>
         * <p>
         * When this value is provided as input, the service returns results from where the previous response left off.
         * When this value is present in output, it indicates that there are more results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Pagination token used to paginate output.</p>
         *        <p>
         *        When this value is provided as input, the service returns results from where the previous response
         *        left off. When this value is present in output, it indicates that there are more results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private List<PrivateGraphEndpointSummary> privateGraphEndpoints = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrivateGraphEndpointsResponse model) {
            super(model);
            privateGraphEndpoints(model.privateGraphEndpoints);
            nextToken(model.nextToken);
        }

        public final List<PrivateGraphEndpointSummary.Builder> getPrivateGraphEndpoints() {
            List<PrivateGraphEndpointSummary.Builder> result = PrivateGraphEndpointSummaryListCopier
                    .copyToBuilder(this.privateGraphEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPrivateGraphEndpoints(Collection<PrivateGraphEndpointSummary.BuilderImpl> privateGraphEndpoints) {
            this.privateGraphEndpoints = PrivateGraphEndpointSummaryListCopier.copyFromBuilder(privateGraphEndpoints);
        }

        @Override
        public final Builder privateGraphEndpoints(Collection<PrivateGraphEndpointSummary> privateGraphEndpoints) {
            this.privateGraphEndpoints = PrivateGraphEndpointSummaryListCopier.copy(privateGraphEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateGraphEndpoints(PrivateGraphEndpointSummary... privateGraphEndpoints) {
            privateGraphEndpoints(Arrays.asList(privateGraphEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder privateGraphEndpoints(Consumer<PrivateGraphEndpointSummary.Builder>... privateGraphEndpoints) {
            privateGraphEndpoints(Stream.of(privateGraphEndpoints)
                    .map(c -> PrivateGraphEndpointSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPrivateGraphEndpointsResponse build() {
            return new ListPrivateGraphEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
