/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportTaskRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<StartImportTaskRequest.Builder, StartImportTaskRequest> {
    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField
            .<ImportOptions> builder(MarshallingType.SDK_POJO).memberName("importOptions")
            .getter(getter(StartImportTaskRequest::importOptions)).setter(setter(Builder::importOptions))
            .constructor(ImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()).build();

    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnError").getter(getter(StartImportTaskRequest::failOnError)).setter(setter(Builder::failOnError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(StartImportTaskRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(StartImportTaskRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> BLANK_NODE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blankNodeHandling").getter(getter(StartImportTaskRequest::blankNodeHandlingAsString))
            .setter(setter(Builder::blankNodeHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blankNodeHandling").build()).build();

    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(StartImportTaskRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("graphIdentifier").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartImportTaskRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORT_OPTIONS_FIELD,
            FAIL_ON_ERROR_FIELD, SOURCE_FIELD, FORMAT_FIELD, BLANK_NODE_HANDLING_FIELD, GRAPH_IDENTIFIER_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("importOptions", IMPORT_OPTIONS_FIELD);
                    put("failOnError", FAIL_ON_ERROR_FIELD);
                    put("source", SOURCE_FIELD);
                    put("format", FORMAT_FIELD);
                    put("blankNodeHandling", BLANK_NODE_HANDLING_FIELD);
                    put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
                    put("roleArn", ROLE_ARN_FIELD);
                }
            });

    private final ImportOptions importOptions;

    private final Boolean failOnError;

    private final String source;

    private final String format;

    private final String blankNodeHandling;

    private final String graphIdentifier;

    private final String roleArn;

    private StartImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.importOptions = builder.importOptions;
        this.failOnError = builder.failOnError;
        this.source = builder.source;
        this.format = builder.format;
        this.blankNodeHandling = builder.blankNodeHandling;
        this.graphIdentifier = builder.graphIdentifier;
        this.roleArn = builder.roleArn;
    }

    /**
     * Returns the value of the ImportOptions property for this object.
     * 
     * @return The value of the ImportOptions property for this object.
     */
    public final ImportOptions importOptions() {
        return importOptions;
    }

    /**
     * <p>
     * If set to true, the task halts when an import error is encountered. If set to false, the task skips the data that
     * caused the error and continues if possible.
     * </p>
     * 
     * @return If set to true, the task halts when an import error is encountered. If set to false, the task skips the
     *         data that caused the error and continues if possible.
     */
    public final Boolean failOnError() {
        return failOnError;
    }

    /**
     * <p>
     * A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to a
     * Neptune database endpoint or snapshot.
     * </p>
     * 
     * @return A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to
     *         a Neptune database endpoint or snapshot.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
     * format or OPENCYPHER, which identies the openCypher load format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin
     *         CSV format or OPENCYPHER, which identies the openCypher load format.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
     * format or OPENCYPHER, which identies the openCypher load format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin
     *         CSV format or OPENCYPHER, which identies the openCypher load format.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported, meaning
     * blank nodes are converted to unique IRIs at load time. Must be provided when format is <code>ntriples</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling">Handling
     * RDF values</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blankNodeHandling}
     * will return {@link BlankNodeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blankNodeHandlingAsString}.
     * </p>
     * 
     * @return The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
     *         meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
     *         <code>ntriples</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
     *         >Handling RDF values</a>.
     * @see BlankNodeHandling
     */
    public final BlankNodeHandling blankNodeHandling() {
        return BlankNodeHandling.fromValue(blankNodeHandling);
    }

    /**
     * <p>
     * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported, meaning
     * blank nodes are converted to unique IRIs at load time. Must be provided when format is <code>ntriples</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling">Handling
     * RDF values</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blankNodeHandling}
     * will return {@link BlankNodeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blankNodeHandlingAsString}.
     * </p>
     * 
     * @return The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
     *         meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
     *         <code>ntriples</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
     *         >Handling RDF values</a>.
     * @see BlankNodeHandling
     */
    public final String blankNodeHandlingAsString() {
        return blankNodeHandling;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     * </p>
     * 
     * @return The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blankNodeHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportTaskRequest)) {
            return false;
        }
        StartImportTaskRequest other = (StartImportTaskRequest) obj;
        return Objects.equals(importOptions(), other.importOptions()) && Objects.equals(failOnError(), other.failOnError())
                && Objects.equals(source(), other.source()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(blankNodeHandlingAsString(), other.blankNodeHandlingAsString())
                && Objects.equals(graphIdentifier(), other.graphIdentifier()) && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportTaskRequest").add("ImportOptions", importOptions()).add("FailOnError", failOnError())
                .add("Source", source()).add("Format", formatAsString()).add("BlankNodeHandling", blankNodeHandlingAsString())
                .add("GraphIdentifier", graphIdentifier()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importOptions":
            return Optional.ofNullable(clazz.cast(importOptions()));
        case "failOnError":
            return Optional.ofNullable(clazz.cast(failOnError()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "blankNodeHandling":
            return Optional.ofNullable(clazz.cast(blankNodeHandlingAsString()));
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartImportTaskRequest, T> g) {
        return obj -> g.apply((StartImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartImportTaskRequest> {
        /**
         * Sets the value of the ImportOptions property for this object.
         *
         * @param importOptions
         *        The new value for the ImportOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importOptions(ImportOptions importOptions);

        /**
         * Sets the value of the ImportOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImportOptions.Builder} avoiding the need
         * to create one manually via {@link ImportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #importOptions(ImportOptions)}.
         * 
         * @param importOptions
         *        a consumer that will call methods on {@link ImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importOptions(ImportOptions)
         */
        default Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return importOptions(ImportOptions.builder().applyMutation(importOptions).build());
        }

        /**
         * <p>
         * If set to true, the task halts when an import error is encountered. If set to false, the task skips the data
         * that caused the error and continues if possible.
         * </p>
         * 
         * @param failOnError
         *        If set to true, the task halts when an import error is encountered. If set to false, the task skips
         *        the data that caused the error and continues if possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnError(Boolean failOnError);

        /**
         * <p>
         * A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to a
         * Neptune database endpoint or snapshot.
         * </p>
         * 
         * @param source
         *        A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point
         *        to a Neptune database endpoint or snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
         * format or OPENCYPHER, which identies the openCypher load format.
         * </p>
         * 
         * @param format
         *        Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the
         *        Gremlin CSV format or OPENCYPHER, which identies the openCypher load format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
         * format or OPENCYPHER, which identies the openCypher load format.
         * </p>
         * 
         * @param format
         *        Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the
         *        Gremlin CSV format or OPENCYPHER, which identies the openCypher load format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
         * meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
         * <code>ntriples</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         * >Handling RDF values</a>.
         * </p>
         * 
         * @param blankNodeHandling
         *        The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is
         *        supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format
         *        is <code>ntriples</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         *        >Handling RDF values</a>.
         * @see BlankNodeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlankNodeHandling
         */
        Builder blankNodeHandling(String blankNodeHandling);

        /**
         * <p>
         * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
         * meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
         * <code>ntriples</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         * >Handling RDF values</a>.
         * </p>
         * 
         * @param blankNodeHandling
         *        The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is
         *        supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format
         *        is <code>ntriples</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         *        >Handling RDF values</a>.
         * @see BlankNodeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlankNodeHandling
         */
        Builder blankNodeHandling(BlankNodeHandling blankNodeHandling);

        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphIdentifier
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that will allow access to the data that is to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private ImportOptions importOptions;

        private Boolean failOnError;

        private String source;

        private String format;

        private String blankNodeHandling;

        private String graphIdentifier;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportTaskRequest model) {
            super(model);
            importOptions(model.importOptions);
            failOnError(model.failOnError);
            source(model.source);
            format(model.format);
            blankNodeHandling(model.blankNodeHandling);
            graphIdentifier(model.graphIdentifier);
            roleArn(model.roleArn);
        }

        public final ImportOptions.Builder getImportOptions() {
            return importOptions != null ? importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final Boolean getFailOnError() {
            return failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getBlankNodeHandling() {
            return blankNodeHandling;
        }

        public final void setBlankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
        }

        @Override
        public final Builder blankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
            return this;
        }

        @Override
        public final Builder blankNodeHandling(BlankNodeHandling blankNodeHandling) {
            this.blankNodeHandling(blankNodeHandling == null ? null : blankNodeHandling.toString());
            return this;
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartImportTaskRequest build() {
            return new StartImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
