/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartImportTaskResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<StartImportTaskResponse.Builder, StartImportTaskResponse> {
    private static final SdkField<String> GRAPH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphId").getter(getter(StartImportTaskResponse::graphId)).setter(setter(Builder::graphId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphId").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(StartImportTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(StartImportTaskResponse::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(StartImportTaskResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartImportTaskResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartImportTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField
            .<ImportOptions> builder(MarshallingType.SDK_POJO).memberName("importOptions")
            .getter(getter(StartImportTaskResponse::importOptions)).setter(setter(Builder::importOptions))
            .constructor(ImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ID_FIELD, TASK_ID_FIELD,
            SOURCE_FIELD, FORMAT_FIELD, ROLE_ARN_FIELD, STATUS_FIELD, IMPORT_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("graphId", GRAPH_ID_FIELD);
                    put("taskId", TASK_ID_FIELD);
                    put("source", SOURCE_FIELD);
                    put("format", FORMAT_FIELD);
                    put("roleArn", ROLE_ARN_FIELD);
                    put("status", STATUS_FIELD);
                    put("importOptions", IMPORT_OPTIONS_FIELD);
                }
            });

    private final String graphId;

    private final String taskId;

    private final String source;

    private final String format;

    private final String roleArn;

    private final String status;

    private final ImportOptions importOptions;

    private StartImportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.graphId = builder.graphId;
        this.taskId = builder.taskId;
        this.source = builder.source;
        this.format = builder.format;
        this.roleArn = builder.roleArn;
        this.status = builder.status;
        this.importOptions = builder.importOptions;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphId() {
        return graphId;
    }

    /**
     * <p>
     * The unique identifier of the import task.
     * </p>
     * 
     * @return The unique identifier of the import task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to a
     * Neptune database endpoint or snapshot.
     * </p>
     * 
     * @return A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to
     *         a Neptune database endpoint or snapshot.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
     * format or OPENCYPHER, which identies the openCypher load format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin
     *         CSV format or OPENCYPHER, which identies the openCypher load format.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
     * format or OPENCYPHER, which identies the openCypher load format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin
     *         CSV format or OPENCYPHER, which identies the openCypher load format.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     * </p>
     * 
     * @return The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The status of the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import task.
     * @see ImportTaskStatus
     */
    public final ImportTaskStatus status() {
        return ImportTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ImportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the import task.
     * @see ImportTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * Returns the value of the ImportOptions property for this object.
     * 
     * @return The value of the ImportOptions property for this object.
     */
    public final ImportOptions importOptions() {
        return importOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphId());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(importOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartImportTaskResponse)) {
            return false;
        }
        StartImportTaskResponse other = (StartImportTaskResponse) obj;
        return Objects.equals(graphId(), other.graphId()) && Objects.equals(taskId(), other.taskId())
                && Objects.equals(source(), other.source()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(importOptions(), other.importOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartImportTaskResponse").add("GraphId", graphId()).add("TaskId", taskId())
                .add("Source", source()).add("Format", formatAsString()).add("RoleArn", roleArn())
                .add("Status", statusAsString()).add("ImportOptions", importOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphId":
            return Optional.ofNullable(clazz.cast(graphId()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "importOptions":
            return Optional.ofNullable(clazz.cast(importOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StartImportTaskResponse, T> g) {
        return obj -> g.apply((StartImportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartImportTaskResponse> {
        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphId
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphId(String graphId);

        /**
         * <p>
         * The unique identifier of the import task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the import task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point to a
         * Neptune database endpoint or snapshot.
         * </p>
         * 
         * @param source
         *        A URL identifying the location of the data to be imported. This can be an Amazon S3 path, or can point
         *        to a Neptune database endpoint or snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
         * format or OPENCYPHER, which identies the openCypher load format.
         * </p>
         * 
         * @param format
         *        Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the
         *        Gremlin CSV format or OPENCYPHER, which identies the openCypher load format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the Gremlin CSV
         * format or OPENCYPHER, which identies the openCypher load format.
         * </p>
         * 
         * @param format
         *        Specifies the format of Amazon S3 data to be imported. Valid values are CSV, which identifies the
         *        Gremlin CSV format or OPENCYPHER, which identies the openCypher load format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that will allow access to the data that is to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The status of the import task.
         * </p>
         * 
         * @param status
         *        The status of the import task.
         * @see ImportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the import task.
         * </p>
         * 
         * @param status
         *        The status of the import task.
         * @see ImportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ImportTaskStatus
         */
        Builder status(ImportTaskStatus status);

        /**
         * Sets the value of the ImportOptions property for this object.
         *
         * @param importOptions
         *        The new value for the ImportOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importOptions(ImportOptions importOptions);

        /**
         * Sets the value of the ImportOptions property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImportOptions.Builder} avoiding the need
         * to create one manually via {@link ImportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #importOptions(ImportOptions)}.
         * 
         * @param importOptions
         *        a consumer that will call methods on {@link ImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importOptions(ImportOptions)
         */
        default Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return importOptions(ImportOptions.builder().applyMutation(importOptions).build());
        }
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private String graphId;

        private String taskId;

        private String source;

        private String format;

        private String roleArn;

        private String status;

        private ImportOptions importOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(StartImportTaskResponse model) {
            super(model);
            graphId(model.graphId);
            taskId(model.taskId);
            source(model.source);
            format(model.format);
            roleArn(model.roleArn);
            status(model.status);
            importOptions(model.importOptions);
        }

        public final String getGraphId() {
            return graphId;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        @Override
        public final Builder graphId(String graphId) {
            this.graphId = graphId;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ImportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return importOptions != null ? importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        @Override
        public StartImportTaskResponse build() {
            return new StartImportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
