/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the number of dimensions for vector embeddings loaded into the graph. Max = 65535
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VectorSearchConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VectorSearchConfiguration.Builder, VectorSearchConfiguration> {
    private static final SdkField<Integer> DIMENSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimension").getter(getter(VectorSearchConfiguration::dimension)).setter(setter(Builder::dimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimension").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("dimension", DIMENSION_FIELD);
                }
            });

    private static final long serialVersionUID = 1L;

    private final Integer dimension;

    private VectorSearchConfiguration(BuilderImpl builder) {
        this.dimension = builder.dimension;
    }

    /**
     * <p>
     * The number of dimensions.
     * </p>
     * 
     * @return The number of dimensions.
     */
    public final Integer dimension() {
        return dimension;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimension());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VectorSearchConfiguration)) {
            return false;
        }
        VectorSearchConfiguration other = (VectorSearchConfiguration) obj;
        return Objects.equals(dimension(), other.dimension());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VectorSearchConfiguration").add("Dimension", dimension()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimension":
            return Optional.ofNullable(clazz.cast(dimension()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<VectorSearchConfiguration, T> g) {
        return obj -> g.apply((VectorSearchConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VectorSearchConfiguration> {
        /**
         * <p>
         * The number of dimensions.
         * </p>
         * 
         * @param dimension
         *        The number of dimensions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimension(Integer dimension);
    }

    static final class BuilderImpl implements Builder {
        private Integer dimension;

        private BuilderImpl() {
        }

        private BuilderImpl(VectorSearchConfiguration model) {
            dimension(model.dimension);
        }

        public final Integer getDimension() {
            return dimension;
        }

        public final void setDimension(Integer dimension) {
            this.dimension = dimension;
        }

        @Override
        public final Builder dimension(Integer dimension) {
            this.dimension = dimension;
            return this;
        }

        @Override
        public VectorSearchConfiguration build() {
            return new VectorSearchConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
