/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGraphSnapshotRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<DeleteGraphSnapshotRequest.Builder, DeleteGraphSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotIdentifier").getter(getter(DeleteGraphSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections
            .unmodifiableMap(new HashMap<String, SdkField<?>>() {
                {
                    put("snapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
                }
            });

    private final String snapshotIdentifier;

    private DeleteGraphSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
    }

    /**
     * <p>
     * ID of the graph snapshot to be deleted.
     * </p>
     * 
     * @return ID of the graph snapshot to be deleted.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGraphSnapshotRequest)) {
            return false;
        }
        DeleteGraphSnapshotRequest other = (DeleteGraphSnapshotRequest) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGraphSnapshotRequest").add("SnapshotIdentifier", snapshotIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteGraphSnapshotRequest, T> g) {
        return obj -> g.apply((DeleteGraphSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGraphSnapshotRequest> {
        /**
         * <p>
         * ID of the graph snapshot to be deleted.
         * </p>
         * 
         * @param snapshotIdentifier
         *        ID of the graph snapshot to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGraphSnapshotRequest model) {
            super(model);
            snapshotIdentifier(model.snapshotIdentifier);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGraphSnapshotRequest build() {
            return new DeleteGraphSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
