/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.neptunegraph.NeptuneGraphClient;
import software.amazon.awssdk.services.neptunegraph.model.GetExportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetExportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetGraphSnapshotResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetImportTaskResponse;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointRequest;
import software.amazon.awssdk.services.neptunegraph.model.GetPrivateGraphEndpointResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
@Immutable
public interface NeptuneGraphWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getExportTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskCancelled(GetExportTaskRequest getExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetExportTaskRequest#builder()}
     *
     * @param getExportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskCancelled(
            Consumer<GetExportTaskRequest.Builder> getExportTaskRequest) {
        return waitUntilExportTaskCancelled(GetExportTaskRequest.builder().applyMutation(getExportTaskRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getExportTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskCancelled(GetExportTaskRequest getExportTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getExportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskCancelled(
            Consumer<GetExportTaskRequest.Builder> getExportTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilExportTaskCancelled(GetExportTaskRequest.builder().applyMutation(getExportTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getExportTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskSuccessful(GetExportTaskRequest getExportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetExportTaskRequest#builder()}
     *
     * @param getExportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskSuccessful(
            Consumer<GetExportTaskRequest.Builder> getExportTaskRequest) {
        return waitUntilExportTaskSuccessful(GetExportTaskRequest.builder().applyMutation(getExportTaskRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getExportTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskSuccessful(GetExportTaskRequest getExportTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getExportTask} API until the desired condition {@code ExportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getExportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetExportTaskResponse> waitUntilExportTaskSuccessful(
            Consumer<GetExportTaskRequest.Builder> getExportTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilExportTaskSuccessful(GetExportTaskRequest.builder().applyMutation(getExportTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getGraphRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(GetGraphRequest getGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetGraphRequest#builder()}
     *
     * @param getGraphRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(Consumer<GetGraphRequest.Builder> getGraphRequest) {
        return waitUntilGraphAvailable(GetGraphRequest.builder().applyMutation(getGraphRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getGraphRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(GetGraphRequest getGraphRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphAvailable} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getGraphRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphAvailable(Consumer<GetGraphRequest.Builder> getGraphRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilGraphAvailable(GetGraphRequest.builder().applyMutation(getGraphRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphDeleted} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getGraphRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(GetGraphRequest getGraphRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphDeleted} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetGraphRequest#builder()}
     *
     * @param getGraphRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(Consumer<GetGraphRequest.Builder> getGraphRequest) {
        return waitUntilGraphDeleted(GetGraphRequest.builder().applyMutation(getGraphRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphDeleted} is met, or until
     * it is determined that the resource will never enter into the desired state
     *
     * @param getGraphRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(GetGraphRequest getGraphRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraph} API until the desired condition {@code GraphDeleted} is met, or until
     * it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getGraphRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphResponse> waitUntilGraphDeleted(Consumer<GetGraphRequest.Builder> getGraphRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilGraphDeleted(GetGraphRequest.builder().applyMutation(getGraphRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getGraphSnapshotRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(
            GetGraphSnapshotRequest getGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetGraphSnapshotRequest#builder()}
     *
     * @param getGraphSnapshotRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(
            Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) {
        return waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getGraphSnapshotRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(
            GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotAvailable}
     * is met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getGraphSnapshotRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotAvailable(
            Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilGraphSnapshotAvailable(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getGraphSnapshotRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest getGraphSnapshotRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetGraphSnapshotRequest#builder()}
     *
     * @param getGraphSnapshotRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(
            Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest) {
        return waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getGraphSnapshotRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(
            GetGraphSnapshotRequest getGraphSnapshotRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getGraphSnapshot} API until the desired condition {@code GraphSnapshotDeleted} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getGraphSnapshotRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetGraphSnapshotResponse> waitUntilGraphSnapshotDeleted(
            Consumer<GetGraphSnapshotRequest.Builder> getGraphSnapshotRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilGraphSnapshotDeleted(GetGraphSnapshotRequest.builder().applyMutation(getGraphSnapshotRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getImportTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetImportTaskRequest#builder()}
     *
     * @param getImportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(
            Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) {
        return waitUntilImportTaskCancelled(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getImportTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(GetImportTaskRequest getImportTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskCancelled} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getImportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskCancelled(
            Consumer<GetImportTaskRequest.Builder> getImportTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilImportTaskCancelled(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getImportTaskRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetImportTaskRequest#builder()}
     *
     * @param getImportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(
            Consumer<GetImportTaskRequest.Builder> getImportTaskRequest) {
        return waitUntilImportTaskSuccessful(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param getImportTaskRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(GetImportTaskRequest getImportTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getImportTask} API until the desired condition {@code ImportTaskSuccessful} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getImportTaskRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetImportTaskResponse> waitUntilImportTaskSuccessful(
            Consumer<GetImportTaskRequest.Builder> getImportTaskRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilImportTaskSuccessful(GetImportTaskRequest.builder().applyMutation(getImportTaskRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointAvailable} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getPrivateGraphEndpointRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(
            GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointAvailable} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetPrivateGraphEndpointRequest#builder()}
     *
     * @param getPrivateGraphEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) {
        return waitUntilPrivateGraphEndpointAvailable(GetPrivateGraphEndpointRequest.builder()
                .applyMutation(getPrivateGraphEndpointRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointAvailable} is met, or until it is determined that the resource will never enter into
     * the desired state
     *
     * @param getPrivateGraphEndpointRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(
            GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointAvailable} is met, or until it is determined that the resource will never enter into
     * the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getPrivateGraphEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointAvailable(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilPrivateGraphEndpointAvailable(
                GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getPrivateGraphEndpointRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(
            GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link GetPrivateGraphEndpointRequest#builder()}
     *
     * @param getPrivateGraphEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest) {
        return waitUntilPrivateGraphEndpointDeleted(GetPrivateGraphEndpointRequest.builder()
                .applyMutation(getPrivateGraphEndpointRequest).build());
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param getPrivateGraphEndpointRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(
            GetPrivateGraphEndpointRequest getPrivateGraphEndpointRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link NeptuneGraphClient#getPrivateGraphEndpoint} API until the desired condition
     * {@code PrivateGraphEndpointDeleted} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param getPrivateGraphEndpointRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<GetPrivateGraphEndpointResponse> waitUntilPrivateGraphEndpointDeleted(
            Consumer<GetPrivateGraphEndpointRequest.Builder> getPrivateGraphEndpointRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilPrivateGraphEndpointDeleted(
                GetPrivateGraphEndpointRequest.builder().applyMutation(getPrivateGraphEndpointRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link NeptuneGraphWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultNeptuneGraphWaiter.builder();
    }

    /**
     * Create an instance of {@link NeptuneGraphWaiter} with the default configuration.
     * <p>
     * <b>A default {@link NeptuneGraphClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link NeptuneGraphWaiter}
     */
    static NeptuneGraphWaiter create() {
        return DefaultNeptuneGraphWaiter.builder().build();
    }

    interface Builder {
        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link NeptuneGraphClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(NeptuneGraphClient client);

        /**
         * Builds an instance of {@link NeptuneGraphWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link NeptuneGraphWaiter}
         */
        NeptuneGraphWaiter build();
    }
}
