/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetQueryRequest
extends NeptuneGraphRequest
implements ToCopyableBuilder<Builder, GetQueryRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("graphIdentifier").getter(GetQueryRequest.getter(GetQueryRequest::graphIdentifier)).setter(GetQueryRequest.setter(Builder::graphIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("graphIdentifier").build()}).build();
    private static final SdkField<String> QUERY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queryId").getter(GetQueryRequest.getter(GetQueryRequest::queryId)).setter(GetQueryRequest.setter(Builder::queryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queryId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD, QUERY_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
            this.put("queryId", QUERY_ID_FIELD);
        }
    });
    private final String graphIdentifier;
    private final String queryId;

    private GetQueryRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.queryId = builder.queryId;
    }

    public final String graphIdentifier() {
        return this.graphIdentifier;
    }

    public final String queryId() {
        return this.queryId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetQueryRequest)) {
            return false;
        }
        GetQueryRequest other = (GetQueryRequest)((Object)obj);
        return Objects.equals(this.graphIdentifier(), other.graphIdentifier()) && Objects.equals(this.queryId(), other.queryId());
    }

    public final String toString() {
        return ToString.builder((String)"GetQueryRequest").add("GraphIdentifier", (Object)this.graphIdentifier()).add("QueryId", (Object)this.queryId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "graphIdentifier": {
                return Optional.ofNullable(clazz.cast(this.graphIdentifier()));
            }
            case "queryId": {
                return Optional.ofNullable(clazz.cast(this.queryId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetQueryRequest, T> g) {
        return obj -> g.apply((GetQueryRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphRequest.BuilderImpl
    implements Builder {
        private String graphIdentifier;
        private String queryId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetQueryRequest model) {
            super(model);
            this.graphIdentifier(model.graphIdentifier);
            this.queryId(model.queryId);
        }

        public final String getGraphIdentifier() {
            return this.graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getQueryId() {
            return this.queryId;
        }

        public final void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Override
        public final Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetQueryRequest build() {
            return new GetQueryRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends NeptuneGraphRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetQueryRequest> {
        public Builder graphIdentifier(String var1);

        public Builder queryId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

