/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGraphUsingImportTaskRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<CreateGraphUsingImportTaskRequest.Builder, CreateGraphUsingImportTaskRequest> {
    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphName").getter(getter(CreateGraphUsingImportTaskRequest::graphName))
            .setter(setter(Builder::graphName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateGraphUsingImportTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(CreateGraphUsingImportTaskRequest::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CreateGraphUsingImportTaskRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField
            .<VectorSearchConfiguration> builder(MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration")
            .getter(getter(CreateGraphUsingImportTaskRequest::vectorSearchConfiguration))
            .setter(setter(Builder::vectorSearchConfiguration)).constructor(VectorSearchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build())
            .build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("replicaCount").getter(getter(CreateGraphUsingImportTaskRequest::replicaCount))
            .setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(CreateGraphUsingImportTaskRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final SdkField<ImportOptions> IMPORT_OPTIONS_FIELD = SdkField
            .<ImportOptions> builder(MarshallingType.SDK_POJO).memberName("importOptions")
            .getter(getter(CreateGraphUsingImportTaskRequest::importOptions)).setter(setter(Builder::importOptions))
            .constructor(ImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importOptions").build()).build();

    private static final SdkField<Integer> MAX_PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxProvisionedMemory").getter(getter(CreateGraphUsingImportTaskRequest::maxProvisionedMemory))
            .setter(setter(Builder::maxProvisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxProvisionedMemory").build())
            .build();

    private static final SdkField<Integer> MIN_PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minProvisionedMemory").getter(getter(CreateGraphUsingImportTaskRequest::minProvisionedMemory))
            .setter(setter(Builder::minProvisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minProvisionedMemory").build())
            .build();

    private static final SdkField<Boolean> FAIL_ON_ERROR_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("failOnError").getter(getter(CreateGraphUsingImportTaskRequest::failOnError))
            .setter(setter(Builder::failOnError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failOnError").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source")
            .getter(getter(CreateGraphUsingImportTaskRequest::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(CreateGraphUsingImportTaskRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parquetType").getter(getter(CreateGraphUsingImportTaskRequest::parquetTypeAsString))
            .setter(setter(Builder::parquetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()).build();

    private static final SdkField<String> BLANK_NODE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("blankNodeHandling").getter(getter(CreateGraphUsingImportTaskRequest::blankNodeHandlingAsString))
            .setter(setter(Builder::blankNodeHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blankNodeHandling").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CreateGraphUsingImportTaskRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_NAME_FIELD, TAGS_FIELD,
            PUBLIC_CONNECTIVITY_FIELD, KMS_KEY_IDENTIFIER_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD,
            DELETION_PROTECTION_FIELD, IMPORT_OPTIONS_FIELD, MAX_PROVISIONED_MEMORY_FIELD, MIN_PROVISIONED_MEMORY_FIELD,
            FAIL_ON_ERROR_FIELD, SOURCE_FIELD, FORMAT_FIELD, PARQUET_TYPE_FIELD, BLANK_NODE_HANDLING_FIELD, ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphName;

    private final Map<String, String> tags;

    private final Boolean publicConnectivity;

    private final String kmsKeyIdentifier;

    private final VectorSearchConfiguration vectorSearchConfiguration;

    private final Integer replicaCount;

    private final Boolean deletionProtection;

    private final ImportOptions importOptions;

    private final Integer maxProvisionedMemory;

    private final Integer minProvisionedMemory;

    private final Boolean failOnError;

    private final String source;

    private final String format;

    private final String parquetType;

    private final String blankNodeHandling;

    private final String roleArn;

    private CreateGraphUsingImportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.graphName = builder.graphName;
        this.tags = builder.tags;
        this.publicConnectivity = builder.publicConnectivity;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.deletionProtection = builder.deletionProtection;
        this.importOptions = builder.importOptions;
        this.maxProvisionedMemory = builder.maxProvisionedMemory;
        this.minProvisionedMemory = builder.minProvisionedMemory;
        this.failOnError = builder.failOnError;
        this.source = builder.source;
        this.format = builder.format;
        this.parquetType = builder.parquetType;
        this.blankNodeHandling = builder.blankNodeHandling;
        this.roleArn = builder.roleArn;
    }

    /**
     * <p>
     * A name for the new Neptune Analytics graph to be created.
     * </p>
     * <p>
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
     * cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return A name for the new Neptune Analytics graph to be created.</p>
     *         <p>
     *         The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
     *         letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public final String graphName() {
        return graphName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a
     * Condition statement in an IAM policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used
     *         in a Condition statement in an IAM policy.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * (<code>true</code> to enable, or <code>false</code> to disable).
     * </p>
     * 
     * @return Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
     *         authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    /**
     * <p>
     * Specifies a KMS key to use to encrypt data imported into the new graph.
     * </p>
     * 
     * @return Specifies a KMS key to use to encrypt data imported into the new graph.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
     * specified as <code>dimension=</code>value. Max = 65,535
     * </p>
     * 
     * @return Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
     *         specified as <code>dimension=</code>value. Max = 65,535
     */
    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return vectorSearchConfiguration;
    }

    /**
     * <p>
     * The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0, Max = 2.
     * </p>
     * <important>
     * <p>
     * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     * </p>
     * </important>
     * 
     * @return The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0, Max
     *         = 2.</p> <important>
     *         <p>
     *         Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     *         </p>
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    /**
     * <p>
     * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion
     * protection is enabled. (<code>true</code> or <code>false</code>).
     * </p>
     * 
     * @return Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when
     *         deletion protection is enabled. (<code>true</code> or <code>false</code>).
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Contains options for controlling the import process. For example, if the <code>failOnError</code> key is set to
     * <code>false</code>, the import skips problem data and attempts to continue (whereas if set to <code>true</code>,
     * the default, or if omitted, the import operation halts immediately when an error is encountered.
     * </p>
     * 
     * @return Contains options for controlling the import process. For example, if the <code>failOnError</code> key is
     *         set to <code>false</code>, the import skips problem data and attempts to continue (whereas if set to
     *         <code>true</code>, the default, or if omitted, the import operation halts immediately when an error is
     *         encountered.
     */
    public final ImportOptions importOptions() {
        return importOptions;
    }

    /**
     * <p>
     * The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 1024, or
     * the approved upper limit for your account.
     * </p>
     * <p>
     * If both the minimum and maximum values are specified, the max of the <code>min-provisioned-memory</code> and
     * <code>max-provisioned memory</code> is used to create the graph. If neither value is specified 128 m-NCUs are
     * used.
     * </p>
     * 
     * @return The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default:
     *         1024, or the approved upper limit for your account.</p>
     *         <p>
     *         If both the minimum and maximum values are specified, the max of the <code>min-provisioned-memory</code>
     *         and <code>max-provisioned memory</code> is used to create the graph. If neither value is specified 128
     *         m-NCUs are used.
     */
    public final Integer maxProvisionedMemory() {
        return maxProvisionedMemory;
    }

    /**
     * <p>
     * The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 128
     * </p>
     * 
     * @return The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default:
     *         128
     */
    public final Integer minProvisionedMemory() {
        return minProvisionedMemory;
    }

    /**
     * <p>
     * If set to <code>true</code>, the task halts when an import error is encountered. If set to <code>false</code>,
     * the task skips the data that caused the error and continues if possible.
     * </p>
     * 
     * @return If set to <code>true</code>, the task halts when an import error is encountered. If set to
     *         <code>false</code>, the task skips the data that caused the error and continues if possible.
     */
    public final Boolean failOnError() {
        return failOnError;
    }

    /**
     * <p>
     * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to a
     * Neptune database endpoint or snapshot.
     * </p>
     * 
     * @return A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point
     *         to a Neptune database endpoint or snapshot.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>, or <code>ntriples</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF n-triples</a>
     * format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the
     *         <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">
     *         Gremlin CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
     *         >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF
     *         n-triples</a> format.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin CSV
     * format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html">openCypher
     * load format</a>, or <code>ntriples</code>, which identifies the <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF n-triples</a>
     * format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the
     *         <a href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">
     *         Gremlin CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
     *         href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
     *         >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF
     *         n-triples</a> format.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The parquet type of the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the import task.
     * @see ParquetType
     */
    public final ParquetType parquetType() {
        return ParquetType.fromValue(parquetType);
    }

    /**
     * <p>
     * The parquet type of the import task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the import task.
     * @see ParquetType
     */
    public final String parquetTypeAsString() {
        return parquetType;
    }

    /**
     * <p>
     * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported, meaning
     * blank nodes are converted to unique IRIs at load time. Must be provided when format is <code>ntriples</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling">Handling
     * RDF values</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blankNodeHandling}
     * will return {@link BlankNodeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blankNodeHandlingAsString}.
     * </p>
     * 
     * @return The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
     *         meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
     *         <code>ntriples</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
     *         >Handling RDF values</a>.
     * @see BlankNodeHandling
     */
    public final BlankNodeHandling blankNodeHandling() {
        return BlankNodeHandling.fromValue(blankNodeHandling);
    }

    /**
     * <p>
     * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported, meaning
     * blank nodes are converted to unique IRIs at load time. Must be provided when format is <code>ntriples</code>. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling">Handling
     * RDF values</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #blankNodeHandling}
     * will return {@link BlankNodeHandling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #blankNodeHandlingAsString}.
     * </p>
     * 
     * @return The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
     *         meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
     *         <code>ntriples</code>. For more information, see <a
     *         href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
     *         >Handling RDF values</a>.
     * @see BlankNodeHandling
     */
    public final String blankNodeHandlingAsString() {
        return blankNodeHandling;
    }

    /**
     * <p>
     * The ARN of the IAM role that will allow access to the data that is to be imported.
     * </p>
     * 
     * @return The ARN of the IAM role that will allow access to the data that is to be imported.
     */
    public final String roleArn() {
        return roleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(importOptions());
        hashCode = 31 * hashCode + Objects.hashCode(maxProvisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(minProvisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(failOnError());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(blankNodeHandlingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphUsingImportTaskRequest)) {
            return false;
        }
        CreateGraphUsingImportTaskRequest other = (CreateGraphUsingImportTaskRequest) obj;
        return Objects.equals(graphName(), other.graphName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(publicConnectivity(), other.publicConnectivity())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(vectorSearchConfiguration(), other.vectorSearchConfiguration())
                && Objects.equals(replicaCount(), other.replicaCount())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(importOptions(), other.importOptions())
                && Objects.equals(maxProvisionedMemory(), other.maxProvisionedMemory())
                && Objects.equals(minProvisionedMemory(), other.minProvisionedMemory())
                && Objects.equals(failOnError(), other.failOnError()) && Objects.equals(source(), other.source())
                && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(parquetTypeAsString(), other.parquetTypeAsString())
                && Objects.equals(blankNodeHandlingAsString(), other.blankNodeHandlingAsString())
                && Objects.equals(roleArn(), other.roleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGraphUsingImportTaskRequest").add("GraphName", graphName())
                .add("Tags", hasTags() ? tags() : null).add("PublicConnectivity", publicConnectivity())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).add("VectorSearchConfiguration", vectorSearchConfiguration())
                .add("ReplicaCount", replicaCount()).add("DeletionProtection", deletionProtection())
                .add("ImportOptions", importOptions()).add("MaxProvisionedMemory", maxProvisionedMemory())
                .add("MinProvisionedMemory", minProvisionedMemory()).add("FailOnError", failOnError()).add("Source", source())
                .add("Format", formatAsString()).add("ParquetType", parquetTypeAsString())
                .add("BlankNodeHandling", blankNodeHandlingAsString()).add("RoleArn", roleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphName":
            return Optional.ofNullable(clazz.cast(graphName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "vectorSearchConfiguration":
            return Optional.ofNullable(clazz.cast(vectorSearchConfiguration()));
        case "replicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "importOptions":
            return Optional.ofNullable(clazz.cast(importOptions()));
        case "maxProvisionedMemory":
            return Optional.ofNullable(clazz.cast(maxProvisionedMemory()));
        case "minProvisionedMemory":
            return Optional.ofNullable(clazz.cast(minProvisionedMemory()));
        case "failOnError":
            return Optional.ofNullable(clazz.cast(failOnError()));
        case "source":
            return Optional.ofNullable(clazz.cast(source()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "parquetType":
            return Optional.ofNullable(clazz.cast(parquetTypeAsString()));
        case "blankNodeHandling":
            return Optional.ofNullable(clazz.cast(blankNodeHandlingAsString()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("importOptions", IMPORT_OPTIONS_FIELD);
        map.put("maxProvisionedMemory", MAX_PROVISIONED_MEMORY_FIELD);
        map.put("minProvisionedMemory", MIN_PROVISIONED_MEMORY_FIELD);
        map.put("failOnError", FAIL_ON_ERROR_FIELD);
        map.put("source", SOURCE_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("blankNodeHandling", BLANK_NODE_HANDLING_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphUsingImportTaskRequest, T> g) {
        return obj -> g.apply((CreateGraphUsingImportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateGraphUsingImportTaskRequest> {
        /**
         * <p>
         * A name for the new Neptune Analytics graph to be created.
         * </p>
         * <p>
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
         * cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param graphName
         *        A name for the new Neptune Analytics graph to be created.</p>
         *        <p>
         *        The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
         *        letter. It cannot end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphName(String graphName);

        /**
         * <p>
         * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a
         * Condition statement in an IAM policy.
         * </p>
         * 
         * @param tags
         *        Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or
         *        used in a Condition statement in an IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         * authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
         * </p>
         * 
         * @param publicConnectivity
         *        Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         *        authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        /**
         * <p>
         * Specifies a KMS key to use to encrypt data imported into the new graph.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        Specifies a KMS key to use to encrypt data imported into the new graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
         * specified as <code>dimension=</code>value. Max = 65,535
         * </p>
         * 
         * @param vectorSearchConfiguration
         *        Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value
         *        is specified as <code>dimension=</code>value. Max = 65,535
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration);

        /**
         * <p>
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
         * specified as <code>dimension=</code>value. Max = 65,535
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorSearchConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorSearchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vectorSearchConfiguration(VectorSearchConfiguration)}.
         * 
         * @param vectorSearchConfiguration
         *        a consumer that will call methods on {@link VectorSearchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorSearchConfiguration(VectorSearchConfiguration)
         */
        default Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return vectorSearchConfiguration(VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration).build());
        }

        /**
         * <p>
         * The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0, Max =
         * 2.
         * </p>
         * <important>
         * <p>
         * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         * </p>
         * </important>
         * 
         * @param replicaCount
         *        The number of replicas in other AZs to provision on the new graph after import. Default = 0, Min = 0,
         *        Max = 2.</p> <important>
         *        <p>
         *        Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);

        /**
         * <p>
         * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion
         * protection is enabled. (<code>true</code> or <code>false</code>).
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when
         *        deletion protection is enabled. (<code>true</code> or <code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Contains options for controlling the import process. For example, if the <code>failOnError</code> key is set
         * to <code>false</code>, the import skips problem data and attempts to continue (whereas if set to
         * <code>true</code>, the default, or if omitted, the import operation halts immediately when an error is
         * encountered.
         * </p>
         * 
         * @param importOptions
         *        Contains options for controlling the import process. For example, if the <code>failOnError</code> key
         *        is set to <code>false</code>, the import skips problem data and attempts to continue (whereas if set
         *        to <code>true</code>, the default, or if omitted, the import operation halts immediately when an error
         *        is encountered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importOptions(ImportOptions importOptions);

        /**
         * <p>
         * Contains options for controlling the import process. For example, if the <code>failOnError</code> key is set
         * to <code>false</code>, the import skips problem data and attempts to continue (whereas if set to
         * <code>true</code>, the default, or if omitted, the import operation halts immediately when an error is
         * encountered.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImportOptions.Builder} avoiding the need
         * to create one manually via {@link ImportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImportOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #importOptions(ImportOptions)}.
         * 
         * @param importOptions
         *        a consumer that will call methods on {@link ImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #importOptions(ImportOptions)
         */
        default Builder importOptions(Consumer<ImportOptions.Builder> importOptions) {
            return importOptions(ImportOptions.builder().applyMutation(importOptions).build());
        }

        /**
         * <p>
         * The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 1024,
         * or the approved upper limit for your account.
         * </p>
         * <p>
         * If both the minimum and maximum values are specified, the max of the <code>min-provisioned-memory</code> and
         * <code>max-provisioned memory</code> is used to create the graph. If neither value is specified 128 m-NCUs are
         * used.
         * </p>
         * 
         * @param maxProvisionedMemory
         *        The maximum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         *        Default: 1024, or the approved upper limit for your account.</p>
         *        <p>
         *        If both the minimum and maximum values are specified, the max of the
         *        <code>min-provisioned-memory</code> and <code>max-provisioned memory</code> is used to create the
         *        graph. If neither value is specified 128 m-NCUs are used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxProvisionedMemory(Integer maxProvisionedMemory);

        /**
         * <p>
         * The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Default: 128
         * </p>
         * 
         * @param minProvisionedMemory
         *        The minimum provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         *        Default: 128
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minProvisionedMemory(Integer minProvisionedMemory);

        /**
         * <p>
         * If set to <code>true</code>, the task halts when an import error is encountered. If set to <code>false</code>
         * , the task skips the data that caused the error and continues if possible.
         * </p>
         * 
         * @param failOnError
         *        If set to <code>true</code>, the task halts when an import error is encountered. If set to
         *        <code>false</code>, the task skips the data that caused the error and continues if possible.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failOnError(Boolean failOnError);

        /**
         * <p>
         * A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can point to
         * a Neptune database endpoint or snapshot.
         * </p>
         * 
         * @param source
         *        A URL identifying to the location of the data to be imported. This can be an Amazon S3 path, or can
         *        point to a Neptune database endpoint or snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin
         * CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         * >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF n-triples</a>
         * format.
         * </p>
         * 
         * @param format
         *        Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies
         *        the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
         *        >Gremlin CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         *        >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF
         *        n-triples</a> format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html">Gremlin
         * CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         * >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF n-triples</a>
         * format.
         * </p>
         * 
         * @param format
         *        Specifies the format of S3 data to be imported. Valid values are <code>CSV</code>, which identifies
         *        the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-gremlin.html"
         *        >Gremlin CSV format</a>, <code>OPEN_CYPHER</code>, which identifies the <a
         *        href="https://docs.aws.amazon.com/neptune/latest/userguide/bulk-load-tutorial-format-opencypher.html"
         *        >openCypher load format</a>, or <code>ntriples</code>, which identifies the <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html">RDF
         *        n-triples</a> format.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The parquet type of the import task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the import task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(String parquetType);

        /**
         * <p>
         * The parquet type of the import task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the import task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(ParquetType parquetType);

        /**
         * <p>
         * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
         * meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
         * <code>ntriples</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         * >Handling RDF values</a>.
         * </p>
         * 
         * @param blankNodeHandling
         *        The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is
         *        supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format
         *        is <code>ntriples</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         *        >Handling RDF values</a>.
         * @see BlankNodeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlankNodeHandling
         */
        Builder blankNodeHandling(String blankNodeHandling);

        /**
         * <p>
         * The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is supported,
         * meaning blank nodes are converted to unique IRIs at load time. Must be provided when format is
         * <code>ntriples</code>. For more information, see <a
         * href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         * >Handling RDF values</a>.
         * </p>
         * 
         * @param blankNodeHandling
         *        The method to handle blank nodes in the dataset. Currently, only <code>convertToIri</code> is
         *        supported, meaning blank nodes are converted to unique IRIs at load time. Must be provided when format
         *        is <code>ntriples</code>. For more information, see <a
         *        href="https://docs.aws.amazon.com/neptune-analytics/latest/userguide/using-rdf-data.html#rdf-handling"
         *        >Handling RDF values</a>.
         * @see BlankNodeHandling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BlankNodeHandling
         */
        Builder blankNodeHandling(BlankNodeHandling blankNodeHandling);

        /**
         * <p>
         * The ARN of the IAM role that will allow access to the data that is to be imported.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that will allow access to the data that is to be imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean publicConnectivity;

        private String kmsKeyIdentifier;

        private VectorSearchConfiguration vectorSearchConfiguration;

        private Integer replicaCount;

        private Boolean deletionProtection;

        private ImportOptions importOptions;

        private Integer maxProvisionedMemory;

        private Integer minProvisionedMemory;

        private Boolean failOnError;

        private String source;

        private String format;

        private String parquetType;

        private String blankNodeHandling;

        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphUsingImportTaskRequest model) {
            super(model);
            graphName(model.graphName);
            tags(model.tags);
            publicConnectivity(model.publicConnectivity);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            vectorSearchConfiguration(model.vectorSearchConfiguration);
            replicaCount(model.replicaCount);
            deletionProtection(model.deletionProtection);
            importOptions(model.importOptions);
            maxProvisionedMemory(model.maxProvisionedMemory);
            minProvisionedMemory(model.minProvisionedMemory);
            failOnError(model.failOnError);
            source(model.source);
            format(model.format);
            parquetType(model.parquetType);
            blankNodeHandling(model.blankNodeHandling);
            roleArn(model.roleArn);
        }

        public final String getGraphName() {
            return graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return vectorSearchConfiguration != null ? vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final ImportOptions.Builder getImportOptions() {
            return importOptions != null ? importOptions.toBuilder() : null;
        }

        public final void setImportOptions(ImportOptions.BuilderImpl importOptions) {
            this.importOptions = importOptions != null ? importOptions.build() : null;
        }

        @Override
        public final Builder importOptions(ImportOptions importOptions) {
            this.importOptions = importOptions;
            return this;
        }

        public final Integer getMaxProvisionedMemory() {
            return maxProvisionedMemory;
        }

        public final void setMaxProvisionedMemory(Integer maxProvisionedMemory) {
            this.maxProvisionedMemory = maxProvisionedMemory;
        }

        @Override
        public final Builder maxProvisionedMemory(Integer maxProvisionedMemory) {
            this.maxProvisionedMemory = maxProvisionedMemory;
            return this;
        }

        public final Integer getMinProvisionedMemory() {
            return minProvisionedMemory;
        }

        public final void setMinProvisionedMemory(Integer minProvisionedMemory) {
            this.minProvisionedMemory = minProvisionedMemory;
        }

        @Override
        public final Builder minProvisionedMemory(Integer minProvisionedMemory) {
            this.minProvisionedMemory = minProvisionedMemory;
            return this;
        }

        public final Boolean getFailOnError() {
            return failOnError;
        }

        public final void setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
        }

        @Override
        public final Builder failOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getParquetType() {
            return parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final String getBlankNodeHandling() {
            return blankNodeHandling;
        }

        public final void setBlankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
        }

        @Override
        public final Builder blankNodeHandling(String blankNodeHandling) {
            this.blankNodeHandling = blankNodeHandling;
            return this;
        }

        @Override
        public final Builder blankNodeHandling(BlankNodeHandling blankNodeHandling) {
            this.blankNodeHandling(blankNodeHandling == null ? null : blankNodeHandling.toString());
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphUsingImportTaskRequest build() {
            return new CreateGraphUsingImportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
