/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportTaskRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<StartExportTaskRequest.Builder, StartExportTaskRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(StartExportTaskRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphIdentifier").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartExportTaskRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(StartExportTaskRequest::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(StartExportTaskRequest::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(StartExportTaskRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parquetType").getter(getter(StartExportTaskRequest::parquetTypeAsString))
            .setter(setter(Builder::parquetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()).build();

    private static final SdkField<ExportFilter> EXPORT_FILTER_FIELD = SdkField.<ExportFilter> builder(MarshallingType.SDK_POJO)
            .memberName("exportFilter").getter(getter(StartExportTaskRequest::exportFilter))
            .setter(setter(Builder::exportFilter)).constructor(ExportFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportFilter").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartExportTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD,
            ROLE_ARN_FIELD, FORMAT_FIELD, DESTINATION_FIELD, KMS_KEY_IDENTIFIER_FIELD, PARQUET_TYPE_FIELD, EXPORT_FILTER_FIELD,
            TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphIdentifier;

    private final String roleArn;

    private final String format;

    private final String destination;

    private final String kmsKeyIdentifier;

    private final String parquetType;

    private final ExportFilter exportFilter;

    private final Map<String, String> tags;

    private StartExportTaskRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.roleArn = builder.roleArn;
        this.format = builder.format;
        this.destination = builder.destination;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.parquetType = builder.parquetType;
        this.exportFilter = builder.exportFilter;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The source graph identifier of the export task.
     * </p>
     * 
     * @return The source graph identifier of the export task.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * The ARN of the IAM role that will allow data to be exported to the destination.
     * </p>
     * 
     * @return The ARN of the IAM role that will allow data to be exported to the destination.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The format of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the export task.
     * @see ExportFormat
     */
    public final ExportFormat format() {
        return ExportFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the export task.
     * @see ExportFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The Amazon S3 URI where data will be exported to.
     * </p>
     * 
     * @return The Amazon S3 URI where data will be exported to.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The KMS key identifier of the export task.
     * </p>
     * 
     * @return The KMS key identifier of the export task.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * The parquet type of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the export task.
     * @see ParquetType
     */
    public final ParquetType parquetType() {
        return ParquetType.fromValue(parquetType);
    }

    /**
     * <p>
     * The parquet type of the export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the export task.
     * @see ParquetType
     */
    public final String parquetTypeAsString() {
        return parquetType;
    }

    /**
     * <p>
     * The export filter of the export task.
     * </p>
     * 
     * @return The export filter of the export task.
     */
    public final ExportFilter exportFilter() {
        return exportFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags to be applied to the export task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags to be applied to the export task.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(exportFilter());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportTaskRequest)) {
            return false;
        }
        StartExportTaskRequest other = (StartExportTaskRequest) obj;
        return Objects.equals(graphIdentifier(), other.graphIdentifier()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(destination(), other.destination())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(parquetTypeAsString(), other.parquetTypeAsString())
                && Objects.equals(exportFilter(), other.exportFilter()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportTaskRequest").add("GraphIdentifier", graphIdentifier()).add("RoleArn", roleArn())
                .add("Format", formatAsString()).add("Destination", destination()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("ParquetType", parquetTypeAsString()).add("ExportFilter", exportFilter())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "parquetType":
            return Optional.ofNullable(clazz.cast(parquetTypeAsString()));
        case "exportFilter":
            return Optional.ofNullable(clazz.cast(exportFilter()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("exportFilter", EXPORT_FILTER_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExportTaskRequest, T> g) {
        return obj -> g.apply((StartExportTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartExportTaskRequest> {
        /**
         * <p>
         * The source graph identifier of the export task.
         * </p>
         * 
         * @param graphIdentifier
         *        The source graph identifier of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * The ARN of the IAM role that will allow data to be exported to the destination.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that will allow data to be exported to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The format of the export task.
         * </p>
         * 
         * @param format
         *        The format of the export task.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the export task.
         * </p>
         * 
         * @param format
         *        The format of the export task.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder format(ExportFormat format);

        /**
         * <p>
         * The Amazon S3 URI where data will be exported to.
         * </p>
         * 
         * @param destination
         *        The Amazon S3 URI where data will be exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The KMS key identifier of the export task.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The KMS key identifier of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * The parquet type of the export task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the export task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(String parquetType);

        /**
         * <p>
         * The parquet type of the export task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the export task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(ParquetType parquetType);

        /**
         * <p>
         * The export filter of the export task.
         * </p>
         * 
         * @param exportFilter
         *        The export filter of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportFilter(ExportFilter exportFilter);

        /**
         * <p>
         * The export filter of the export task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportFilter.Builder} avoiding the need
         * to create one manually via {@link ExportFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportFilter.Builder#build()} is called immediately and its
         * result is passed to {@link #exportFilter(ExportFilter)}.
         * 
         * @param exportFilter
         *        a consumer that will call methods on {@link ExportFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportFilter(ExportFilter)
         */
        default Builder exportFilter(Consumer<ExportFilter.Builder> exportFilter) {
            return exportFilter(ExportFilter.builder().applyMutation(exportFilter).build());
        }

        /**
         * <p>
         * Tags to be applied to the export task.
         * </p>
         * 
         * @param tags
         *        Tags to be applied to the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphIdentifier;

        private String roleArn;

        private String format;

        private String destination;

        private String kmsKeyIdentifier;

        private String parquetType;

        private ExportFilter exportFilter;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportTaskRequest model) {
            super(model);
            graphIdentifier(model.graphIdentifier);
            roleArn(model.roleArn);
            format(model.format);
            destination(model.destination);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            parquetType(model.parquetType);
            exportFilter(model.exportFilter);
            tags(model.tags);
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ExportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getParquetType() {
            return parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final ExportFilter.Builder getExportFilter() {
            return exportFilter != null ? exportFilter.toBuilder() : null;
        }

        public final void setExportFilter(ExportFilter.BuilderImpl exportFilter) {
            this.exportFilter = exportFilter != null ? exportFilter.build() : null;
        }

        @Override
        public final Builder exportFilter(ExportFilter exportFilter) {
            this.exportFilter = exportFilter;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartExportTaskRequest build() {
            return new StartExportTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
