/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.neptunegraph.model.NodePropertiesCopier;
import software.amazon.awssdk.services.neptunegraph.model.OutgoingEdgeLabelsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NodeStructure
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NodeStructure> {
    private static final SdkField<Long> COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("count").getter(NodeStructure.getter(NodeStructure::count)).setter(NodeStructure.setter(Builder::count)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()}).build();
    private static final SdkField<List<String>> NODE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodeProperties").getter(NodeStructure.getter(NodeStructure::nodeProperties)).setter(NodeStructure.setter(Builder::nodeProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DISTINCT_OUTGOING_EDGE_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("distinctOutgoingEdgeLabels").getter(NodeStructure.getter(NodeStructure::distinctOutgoingEdgeLabels)).setter(NodeStructure.setter(Builder::distinctOutgoingEdgeLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distinctOutgoingEdgeLabels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COUNT_FIELD, NODE_PROPERTIES_FIELD, DISTINCT_OUTGOING_EDGE_LABELS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = NodeStructure.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long count;
    private final List<String> nodeProperties;
    private final List<String> distinctOutgoingEdgeLabels;

    private NodeStructure(BuilderImpl builder) {
        this.count = builder.count;
        this.nodeProperties = builder.nodeProperties;
        this.distinctOutgoingEdgeLabels = builder.distinctOutgoingEdgeLabels;
    }

    public final Long count() {
        return this.count;
    }

    public final boolean hasNodeProperties() {
        return this.nodeProperties != null && !(this.nodeProperties instanceof SdkAutoConstructList);
    }

    public final List<String> nodeProperties() {
        return this.nodeProperties;
    }

    public final boolean hasDistinctOutgoingEdgeLabels() {
        return this.distinctOutgoingEdgeLabels != null && !(this.distinctOutgoingEdgeLabels instanceof SdkAutoConstructList);
    }

    public final List<String> distinctOutgoingEdgeLabels() {
        return this.distinctOutgoingEdgeLabels;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.count());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodeProperties() ? this.nodeProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDistinctOutgoingEdgeLabels() ? this.distinctOutgoingEdgeLabels() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeStructure)) {
            return false;
        }
        NodeStructure other = (NodeStructure)obj;
        return Objects.equals(this.count(), other.count()) && this.hasNodeProperties() == other.hasNodeProperties() && Objects.equals(this.nodeProperties(), other.nodeProperties()) && this.hasDistinctOutgoingEdgeLabels() == other.hasDistinctOutgoingEdgeLabels() && Objects.equals(this.distinctOutgoingEdgeLabels(), other.distinctOutgoingEdgeLabels());
    }

    public final String toString() {
        return ToString.builder((String)"NodeStructure").add("Count", (Object)this.count()).add("NodeProperties", this.hasNodeProperties() ? this.nodeProperties() : null).add("DistinctOutgoingEdgeLabels", this.hasDistinctOutgoingEdgeLabels() ? this.distinctOutgoingEdgeLabels() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "count": {
                return Optional.ofNullable(clazz.cast(this.count()));
            }
            case "nodeProperties": {
                return Optional.ofNullable(clazz.cast(this.nodeProperties()));
            }
            case "distinctOutgoingEdgeLabels": {
                return Optional.ofNullable(clazz.cast(this.distinctOutgoingEdgeLabels()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("count", COUNT_FIELD);
        map.put("nodeProperties", NODE_PROPERTIES_FIELD);
        map.put("distinctOutgoingEdgeLabels", DISTINCT_OUTGOING_EDGE_LABELS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NodeStructure, T> g) {
        return obj -> g.apply((NodeStructure)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long count;
        private List<String> nodeProperties = DefaultSdkAutoConstructList.getInstance();
        private List<String> distinctOutgoingEdgeLabels = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(NodeStructure model) {
            this.count(model.count);
            this.nodeProperties(model.nodeProperties);
            this.distinctOutgoingEdgeLabels(model.distinctOutgoingEdgeLabels);
        }

        public final Long getCount() {
            return this.count;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final Collection<String> getNodeProperties() {
            if (this.nodeProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nodeProperties;
        }

        public final void setNodeProperties(Collection<String> nodeProperties) {
            this.nodeProperties = NodePropertiesCopier.copy(nodeProperties);
        }

        @Override
        public final Builder nodeProperties(Collection<String> nodeProperties) {
            this.nodeProperties = NodePropertiesCopier.copy(nodeProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodeProperties(String ... nodeProperties) {
            this.nodeProperties(Arrays.asList(nodeProperties));
            return this;
        }

        public final Collection<String> getDistinctOutgoingEdgeLabels() {
            if (this.distinctOutgoingEdgeLabels instanceof SdkAutoConstructList) {
                return null;
            }
            return this.distinctOutgoingEdgeLabels;
        }

        public final void setDistinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels = OutgoingEdgeLabelsCopier.copy(distinctOutgoingEdgeLabels);
        }

        @Override
        public final Builder distinctOutgoingEdgeLabels(Collection<String> distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels = OutgoingEdgeLabelsCopier.copy(distinctOutgoingEdgeLabels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder distinctOutgoingEdgeLabels(String ... distinctOutgoingEdgeLabels) {
            this.distinctOutgoingEdgeLabels(Arrays.asList(distinctOutgoingEdgeLabels));
            return this;
        }

        public NodeStructure build() {
            return new NodeStructure(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NodeStructure> {
        public Builder count(Long var1);

        public Builder nodeProperties(Collection<String> var1);

        public Builder nodeProperties(String ... var1);

        public Builder distinctOutgoingEdgeLabels(Collection<String> var1);

        public Builder distinctOutgoingEdgeLabels(String ... var1);
    }
}

