/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGraphRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<CreateGraphRequest.Builder, CreateGraphRequest> {
    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphName").getter(getter(CreateGraphRequest::graphName)).setter(setter(Builder::graphName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateGraphRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(CreateGraphRequest::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CreateGraphRequest::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField
            .<VectorSearchConfiguration> builder(MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration")
            .getter(getter(CreateGraphRequest::vectorSearchConfiguration)).setter(setter(Builder::vectorSearchConfiguration))
            .constructor(VectorSearchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build())
            .build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("replicaCount").getter(getter(CreateGraphRequest::replicaCount)).setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(CreateGraphRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedMemory").getter(getter(CreateGraphRequest::provisionedMemory))
            .setter(setter(Builder::provisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_NAME_FIELD, TAGS_FIELD,
            PUBLIC_CONNECTIVITY_FIELD, KMS_KEY_IDENTIFIER_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD,
            DELETION_PROTECTION_FIELD, PROVISIONED_MEMORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphName;

    private final Map<String, String> tags;

    private final Boolean publicConnectivity;

    private final String kmsKeyIdentifier;

    private final VectorSearchConfiguration vectorSearchConfiguration;

    private final Integer replicaCount;

    private final Boolean deletionProtection;

    private final Integer provisionedMemory;

    private CreateGraphRequest(BuilderImpl builder) {
        super(builder);
        this.graphName = builder.graphName;
        this.tags = builder.tags;
        this.publicConnectivity = builder.publicConnectivity;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.deletionProtection = builder.deletionProtection;
        this.provisionedMemory = builder.provisionedMemory;
    }

    /**
     * <p>
     * A name for the new Neptune Analytics graph to be created.
     * </p>
     * <p>
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
     * cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return A name for the new Neptune Analytics graph to be created.</p>
     *         <p>
     *         The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
     *         letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public final String graphName() {
        return graphName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a
     * Condition statement in an IAM policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used
     *         in a Condition statement in an IAM policy.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * (<code>true</code> to enable, or <code>false</code> to disable.
     * </p>
     * 
     * @return Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
     *         authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    /**
     * <p>
     * Specifies a KMS key to use to encrypt data in the new graph.
     * </p>
     * 
     * @return Specifies a KMS key to use to encrypt data in the new graph.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
     * specified as <code>dimension=</code>value. Max = 65,535
     * </p>
     * 
     * @return Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
     *         specified as <code>dimension=</code>value. Max = 65,535
     */
    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return vectorSearchConfiguration;
    }

    /**
     * <p>
     * The number of replicas in other AZs. Min =0, Max = 2, Default = 1.
     * </p>
     * <important>
     * <p>
     * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     * </p>
     * </important>
     * 
     * @return The number of replicas in other AZs. Min =0, Max = 2, Default = 1.</p> <important>
     *         <p>
     *         Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     *         </p>
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    /**
     * <p>
     * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion
     * protection is enabled. (<code>true</code> or <code>false</code>).
     * </p>
     * 
     * @return Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when
     *         deletion protection is enabled. (<code>true</code> or <code>false</code>).
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
     * </p>
     * 
     * @return The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
     */
    public final Integer provisionedMemory() {
        return provisionedMemory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedMemory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphRequest)) {
            return false;
        }
        CreateGraphRequest other = (CreateGraphRequest) obj;
        return Objects.equals(graphName(), other.graphName()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(publicConnectivity(), other.publicConnectivity())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(vectorSearchConfiguration(), other.vectorSearchConfiguration())
                && Objects.equals(replicaCount(), other.replicaCount())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(provisionedMemory(), other.provisionedMemory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGraphRequest").add("GraphName", graphName()).add("Tags", hasTags() ? tags() : null)
                .add("PublicConnectivity", publicConnectivity()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("VectorSearchConfiguration", vectorSearchConfiguration()).add("ReplicaCount", replicaCount())
                .add("DeletionProtection", deletionProtection()).add("ProvisionedMemory", provisionedMemory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphName":
            return Optional.ofNullable(clazz.cast(graphName()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "vectorSearchConfiguration":
            return Optional.ofNullable(clazz.cast(vectorSearchConfiguration()));
        case "replicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "provisionedMemory":
            return Optional.ofNullable(clazz.cast(provisionedMemory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphRequest, T> g) {
        return obj -> g.apply((CreateGraphRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateGraphRequest> {
        /**
         * <p>
         * A name for the new Neptune Analytics graph to be created.
         * </p>
         * <p>
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
         * cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param graphName
         *        A name for the new Neptune Analytics graph to be created.</p>
         *        <p>
         *        The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
         *        letter. It cannot end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphName(String graphName);

        /**
         * <p>
         * Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or used in a
         * Condition statement in an IAM policy.
         * </p>
         * 
         * @param tags
         *        Adds metadata tags to the new graph. These tags can also be used with cost allocation reporting, or
         *        used in a Condition statement in an IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         * authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
         * </p>
         * 
         * @param publicConnectivity
         *        Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         *        authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        /**
         * <p>
         * Specifies a KMS key to use to encrypt data in the new graph.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        Specifies a KMS key to use to encrypt data in the new graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
         * specified as <code>dimension=</code>value. Max = 65,535
         * </p>
         * 
         * @param vectorSearchConfiguration
         *        Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value
         *        is specified as <code>dimension=</code>value. Max = 65,535
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration);

        /**
         * <p>
         * Specifies the number of dimensions for vector embeddings that will be loaded into the graph. The value is
         * specified as <code>dimension=</code>value. Max = 65,535
         * </p>
         * This is a convenience method that creates an instance of the {@link VectorSearchConfiguration.Builder}
         * avoiding the need to create one manually via {@link VectorSearchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorSearchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #vectorSearchConfiguration(VectorSearchConfiguration)}.
         * 
         * @param vectorSearchConfiguration
         *        a consumer that will call methods on {@link VectorSearchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorSearchConfiguration(VectorSearchConfiguration)
         */
        default Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return vectorSearchConfiguration(VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration).build());
        }

        /**
         * <p>
         * The number of replicas in other AZs. Min =0, Max = 2, Default = 1.
         * </p>
         * <important>
         * <p>
         * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         * </p>
         * </important>
         * 
         * @param replicaCount
         *        The number of replicas in other AZs. Min =0, Max = 2, Default = 1.</p> <important>
         *        <p>
         *        Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);

        /**
         * <p>
         * Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when deletion
         * protection is enabled. (<code>true</code> or <code>false</code>).
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether or not to enable deletion protection on the graph. The graph can’t be deleted when
         *        deletion protection is enabled. (<code>true</code> or <code>false</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
         * </p>
         * 
         * @param provisionedMemory
         *        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph. Min = 128
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedMemory(Integer provisionedMemory);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphName;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean publicConnectivity;

        private String kmsKeyIdentifier;

        private VectorSearchConfiguration vectorSearchConfiguration;

        private Integer replicaCount;

        private Boolean deletionProtection;

        private Integer provisionedMemory;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphRequest model) {
            super(model);
            graphName(model.graphName);
            tags(model.tags);
            publicConnectivity(model.publicConnectivity);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            vectorSearchConfiguration(model.vectorSearchConfiguration);
            replicaCount(model.replicaCount);
            deletionProtection(model.deletionProtection);
            provisionedMemory(model.provisionedMemory);
        }

        public final String getGraphName() {
            return graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return vectorSearchConfiguration != null ? vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGraphRequest build() {
            return new CreateGraphRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
