/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure representing a property's attributes. It is a map object of outputType, sourcePropertyName and
 * multiValueHandling.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportFilterPropertyAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportFilterPropertyAttributes.Builder, ExportFilterPropertyAttributes> {
    private static final SdkField<String> OUTPUT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputType").getter(getter(ExportFilterPropertyAttributes::outputType))
            .setter(setter(Builder::outputType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputType").build()).build();

    private static final SdkField<String> SOURCE_PROPERTY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourcePropertyName").getter(getter(ExportFilterPropertyAttributes::sourcePropertyName))
            .setter(setter(Builder::sourcePropertyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePropertyName").build())
            .build();

    private static final SdkField<String> MULTI_VALUE_HANDLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("multiValueHandling").getter(getter(ExportFilterPropertyAttributes::multiValueHandlingAsString))
            .setter(setter(Builder::multiValueHandling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiValueHandling").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_TYPE_FIELD,
            SOURCE_PROPERTY_NAME_FIELD, MULTI_VALUE_HANDLING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputType;

    private final String sourcePropertyName;

    private final String multiValueHandling;

    private ExportFilterPropertyAttributes(BuilderImpl builder) {
        this.outputType = builder.outputType;
        this.sourcePropertyName = builder.sourcePropertyName;
        this.multiValueHandling = builder.multiValueHandling;
    }

    /**
     * <p>
     * Specifies the data type to use for the property in the exported data (e.g. "String", "Int", "Float"). If a type
     * is not provided, the export process will determine the type. If a given property is present as multiple types
     * (e.g. one vertex has "height" stored as a double, and another edge has it stored as a string), the type will be
     * of Any type, otherwise, it will be the type of the property as present in vertices.
     * </p>
     * 
     * @return Specifies the data type to use for the property in the exported data (e.g. "String", "Int", "Float"). If
     *         a type is not provided, the export process will determine the type. If a given property is present as
     *         multiple types (e.g. one vertex has "height" stored as a double, and another edge has it stored as a
     *         string), the type will be of Any type, otherwise, it will be the type of the property as present in
     *         vertices.
     */
    public final String outputType() {
        return outputType;
    }

    /**
     * <p>
     * The name of the property as it exists in the original graph data. If not provided, it is assumed that the key
     * matches the desired sourcePropertyName.
     * </p>
     * 
     * @return The name of the property as it exists in the original graph data. If not provided, it is assumed that the
     *         key matches the desired sourcePropertyName.
     */
    public final String sourcePropertyName() {
        return sourcePropertyName;
    }

    /**
     * <p>
     * Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to export all
     * values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not specified, the default
     * value is <code>PICK_FIRST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #multiValueHandling} will return {@link MultiValueHandlingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #multiValueHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to
     *         export all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not
     *         specified, the default value is <code>PICK_FIRST</code>.
     * @see MultiValueHandlingType
     */
    public final MultiValueHandlingType multiValueHandling() {
        return MultiValueHandlingType.fromValue(multiValueHandling);
    }

    /**
     * <p>
     * Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to export all
     * values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not specified, the default
     * value is <code>PICK_FIRST</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #multiValueHandling} will return {@link MultiValueHandlingType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #multiValueHandlingAsString}.
     * </p>
     * 
     * @return Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to
     *         export all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not
     *         specified, the default value is <code>PICK_FIRST</code>.
     * @see MultiValueHandlingType
     */
    public final String multiValueHandlingAsString() {
        return multiValueHandling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputType());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePropertyName());
        hashCode = 31 * hashCode + Objects.hashCode(multiValueHandlingAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportFilterPropertyAttributes)) {
            return false;
        }
        ExportFilterPropertyAttributes other = (ExportFilterPropertyAttributes) obj;
        return Objects.equals(outputType(), other.outputType())
                && Objects.equals(sourcePropertyName(), other.sourcePropertyName())
                && Objects.equals(multiValueHandlingAsString(), other.multiValueHandlingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportFilterPropertyAttributes").add("OutputType", outputType())
                .add("SourcePropertyName", sourcePropertyName()).add("MultiValueHandling", multiValueHandlingAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputType":
            return Optional.ofNullable(clazz.cast(outputType()));
        case "sourcePropertyName":
            return Optional.ofNullable(clazz.cast(sourcePropertyName()));
        case "multiValueHandling":
            return Optional.ofNullable(clazz.cast(multiValueHandlingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputType", OUTPUT_TYPE_FIELD);
        map.put("sourcePropertyName", SOURCE_PROPERTY_NAME_FIELD);
        map.put("multiValueHandling", MULTI_VALUE_HANDLING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportFilterPropertyAttributes, T> g) {
        return obj -> g.apply((ExportFilterPropertyAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportFilterPropertyAttributes> {
        /**
         * <p>
         * Specifies the data type to use for the property in the exported data (e.g. "String", "Int", "Float"). If a
         * type is not provided, the export process will determine the type. If a given property is present as multiple
         * types (e.g. one vertex has "height" stored as a double, and another edge has it stored as a string), the type
         * will be of Any type, otherwise, it will be the type of the property as present in vertices.
         * </p>
         * 
         * @param outputType
         *        Specifies the data type to use for the property in the exported data (e.g. "String", "Int", "Float").
         *        If a type is not provided, the export process will determine the type. If a given property is present
         *        as multiple types (e.g. one vertex has "height" stored as a double, and another edge has it stored as
         *        a string), the type will be of Any type, otherwise, it will be the type of the property as present in
         *        vertices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputType(String outputType);

        /**
         * <p>
         * The name of the property as it exists in the original graph data. If not provided, it is assumed that the key
         * matches the desired sourcePropertyName.
         * </p>
         * 
         * @param sourcePropertyName
         *        The name of the property as it exists in the original graph data. If not provided, it is assumed that
         *        the key matches the desired sourcePropertyName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePropertyName(String sourcePropertyName);

        /**
         * <p>
         * Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to export
         * all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not specified, the
         * default value is <code>PICK_FIRST</code>.
         * </p>
         * 
         * @param multiValueHandling
         *        Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to
         *        export all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not
         *        specified, the default value is <code>PICK_FIRST</code>.
         * @see MultiValueHandlingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiValueHandlingType
         */
        Builder multiValueHandling(String multiValueHandling);

        /**
         * <p>
         * Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to export
         * all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not specified, the
         * default value is <code>PICK_FIRST</code>.
         * </p>
         * 
         * @param multiValueHandling
         *        Specifies how to handle properties that have multiple values. Can be either <code>TO_LIST</code> to
         *        export all values as a list, or <code>PICK_FIRST</code> to export the first value encountered. If not
         *        specified, the default value is <code>PICK_FIRST</code>.
         * @see MultiValueHandlingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MultiValueHandlingType
         */
        Builder multiValueHandling(MultiValueHandlingType multiValueHandling);
    }

    static final class BuilderImpl implements Builder {
        private String outputType;

        private String sourcePropertyName;

        private String multiValueHandling;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportFilterPropertyAttributes model) {
            outputType(model.outputType);
            sourcePropertyName(model.sourcePropertyName);
            multiValueHandling(model.multiValueHandling);
        }

        public final String getOutputType() {
            return outputType;
        }

        public final void setOutputType(String outputType) {
            this.outputType = outputType;
        }

        @Override
        public final Builder outputType(String outputType) {
            this.outputType = outputType;
            return this;
        }

        public final String getSourcePropertyName() {
            return sourcePropertyName;
        }

        public final void setSourcePropertyName(String sourcePropertyName) {
            this.sourcePropertyName = sourcePropertyName;
        }

        @Override
        public final Builder sourcePropertyName(String sourcePropertyName) {
            this.sourcePropertyName = sourcePropertyName;
            return this;
        }

        public final String getMultiValueHandling() {
            return multiValueHandling;
        }

        public final void setMultiValueHandling(String multiValueHandling) {
            this.multiValueHandling = multiValueHandling;
        }

        @Override
        public final Builder multiValueHandling(String multiValueHandling) {
            this.multiValueHandling = multiValueHandling;
            return this;
        }

        @Override
        public final Builder multiValueHandling(MultiValueHandlingType multiValueHandling) {
            this.multiValueHandling(multiValueHandling == null ? null : multiValueHandling.toString());
            return this;
        }

        @Override
        public ExportFilterPropertyAttributes build() {
            return new ExportFilterPropertyAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
