/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreGraphFromSnapshotRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<RestoreGraphFromSnapshotRequest.Builder, RestoreGraphFromSnapshotRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("snapshotIdentifier").getter(getter(RestoreGraphFromSnapshotRequest::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotIdentifier").build()).build();

    private static final SdkField<String> GRAPH_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphName").getter(getter(RestoreGraphFromSnapshotRequest::graphName))
            .setter(setter(Builder::graphName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphName").build()).build();

    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedMemory").getter(getter(RestoreGraphFromSnapshotRequest::provisionedMemory))
            .setter(setter(Builder::provisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(RestoreGraphFromSnapshotRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(RestoreGraphFromSnapshotRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("replicaCount").getter(getter(RestoreGraphFromSnapshotRequest::replicaCount))
            .setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(RestoreGraphFromSnapshotRequest::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            GRAPH_NAME_FIELD, PROVISIONED_MEMORY_FIELD, DELETION_PROTECTION_FIELD, TAGS_FIELD, REPLICA_COUNT_FIELD,
            PUBLIC_CONNECTIVITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String snapshotIdentifier;

    private final String graphName;

    private final Integer provisionedMemory;

    private final Boolean deletionProtection;

    private final Map<String, String> tags;

    private final Integer replicaCount;

    private final Boolean publicConnectivity;

    private RestoreGraphFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.graphName = builder.graphName;
        this.provisionedMemory = builder.provisionedMemory;
        this.deletionProtection = builder.deletionProtection;
        this.tags = builder.tags;
        this.replicaCount = builder.replicaCount;
        this.publicConnectivity = builder.publicConnectivity;
    }

    /**
     * <p>
     * The ID of the snapshot in question.
     * </p>
     * 
     * @return The ID of the snapshot in question.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * A name for the new Neptune Analytics graph to be created from the snapshot.
     * </p>
     * <p>
     * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
     * cannot end with a hyphen or contain two consecutive hyphens.
     * </p>
     * 
     * @return A name for the new Neptune Analytics graph to be created from the snapshot.</p>
     *         <p>
     *         The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
     *         letter. It cannot end with a hyphen or contain two consecutive hyphens.
     */
    public final String graphName() {
        return graphName;
    }

    /**
     * <p>
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     * </p>
     * <p>
     * Min = 128
     * </p>
     * 
     * @return The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
     *         <p>
     *         Min = 128
     */
    public final Integer provisionedMemory() {
        return provisionedMemory;
    }

    /**
     * <p>
     * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     * deletion protection is enabled.
     * </p>
     * 
     * @return A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     *         deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or used in a
     * Condition statement in an IAM policy.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or used
     *         in a Condition statement in an IAM policy.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of replicas in other AZs. Min =0, Max = 2, Default =1
     * </p>
     * <important>
     * <p>
     * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     * </p>
     * </important>
     * 
     * @return The number of replicas in other AZs. Min =0, Max = 2, Default =1</p> <important>
     *         <p>
     *         Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
     *         </p>
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    /**
     * <p>
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * (<code>true</code> to enable, or <code>false</code> to disable).
     * </p>
     * 
     * @return Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
     *         authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(graphName());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreGraphFromSnapshotRequest)) {
            return false;
        }
        RestoreGraphFromSnapshotRequest other = (RestoreGraphFromSnapshotRequest) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(graphName(), other.graphName())
                && Objects.equals(provisionedMemory(), other.provisionedMemory())
                && Objects.equals(deletionProtection(), other.deletionProtection()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(replicaCount(), other.replicaCount())
                && Objects.equals(publicConnectivity(), other.publicConnectivity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreGraphFromSnapshotRequest").add("SnapshotIdentifier", snapshotIdentifier())
                .add("GraphName", graphName()).add("ProvisionedMemory", provisionedMemory())
                .add("DeletionProtection", deletionProtection()).add("Tags", hasTags() ? tags() : null)
                .add("ReplicaCount", replicaCount()).add("PublicConnectivity", publicConnectivity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "snapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "graphName":
            return Optional.ofNullable(clazz.cast(graphName()));
        case "provisionedMemory":
            return Optional.ofNullable(clazz.cast(provisionedMemory()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "replicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("snapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("graphName", GRAPH_NAME_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreGraphFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreGraphFromSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RestoreGraphFromSnapshotRequest> {
        /**
         * <p>
         * The ID of the snapshot in question.
         * </p>
         * 
         * @param snapshotIdentifier
         *        The ID of the snapshot in question.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * A name for the new Neptune Analytics graph to be created from the snapshot.
         * </p>
         * <p>
         * The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a letter. It
         * cannot end with a hyphen or contain two consecutive hyphens.
         * </p>
         * 
         * @param graphName
         *        A name for the new Neptune Analytics graph to be created from the snapshot.</p>
         *        <p>
         *        The name must contain from 1 to 63 letters, numbers, or hyphens, and its first character must be a
         *        letter. It cannot end with a hyphen or contain two consecutive hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphName(String graphName);

        /**
         * <p>
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         * </p>
         * <p>
         * Min = 128
         * </p>
         * 
         * @param provisionedMemory
         *        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
         *        <p>
         *        Min = 128
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedMemory(Integer provisionedMemory);

        /**
         * <p>
         * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
         * deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted
         *        when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or used in a
         * Condition statement in an IAM policy.
         * </p>
         * 
         * @param tags
         *        Adds metadata tags to the snapshot. These tags can also be used with cost allocation reporting, or
         *        used in a Condition statement in an IAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The number of replicas in other AZs. Min =0, Max = 2, Default =1
         * </p>
         * <important>
         * <p>
         * Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         * </p>
         * </important>
         * 
         * @param replicaCount
         *        The number of replicas in other AZs. Min =0, Max = 2, Default =1</p> <important>
         *        <p>
         *        Additional charges equivalent to the m-NCUs selected for the graph apply for each replica.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);

        /**
         * <p>
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         * authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
         * </p>
         * 
         * @param publicConnectivity
         *        Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         *        authenticated. (<code>true</code> to enable, or <code>false</code> to disable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String graphName;

        private Integer provisionedMemory;

        private Boolean deletionProtection;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Integer replicaCount;

        private Boolean publicConnectivity;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreGraphFromSnapshotRequest model) {
            super(model);
            snapshotIdentifier(model.snapshotIdentifier);
            graphName(model.graphName);
            provisionedMemory(model.provisionedMemory);
            deletionProtection(model.deletionProtection);
            tags(model.tags);
            replicaCount(model.replicaCount);
            publicConnectivity(model.publicConnectivity);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getGraphName() {
            return graphName;
        }

        public final void setGraphName(String graphName) {
            this.graphName = graphName;
        }

        @Override
        public final Builder graphName(String graphName) {
            this.graphName = graphName;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreGraphFromSnapshotRequest build() {
            return new RestoreGraphFromSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
