/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.neptunegraph.endpoints.NeptuneGraphEndpointParams;
import software.amazon.awssdk.services.neptunegraph.endpoints.NeptuneGraphEndpointProvider;
import software.amazon.awssdk.services.neptunegraph.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.HostnameValidator;

@SdkInternalApi
public final class NeptuneGraphResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        NeptuneGraphEndpointProvider provider = (NeptuneGraphEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            NeptuneGraphEndpointParams endpointParams = NeptuneGraphResolveEndpointInterceptor.ruleParams(result, executionAttributes);
            Endpoint endpoint = provider.resolveEndpoint(endpointParams).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = NeptuneGraphResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static NeptuneGraphEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        NeptuneGraphEndpointParams.Builder builder = NeptuneGraphEndpointParams.builder();
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.useDualStack(AwsEndpointProviderUtils.dualStackEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        NeptuneGraphResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        NeptuneGraphResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        NeptuneGraphResolveEndpointInterceptor.setOperationContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        return builder.build();
    }

    private static void setContextParams(NeptuneGraphEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(NeptuneGraphEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            case "CancelExportTask": {
                NeptuneGraphResolveEndpointInterceptor.cancelExportTaskStaticContextParams(params);
                break;
            }
            case "CancelImportTask": {
                NeptuneGraphResolveEndpointInterceptor.cancelImportTaskStaticContextParams(params);
                break;
            }
            case "CancelQuery": {
                NeptuneGraphResolveEndpointInterceptor.cancelQueryStaticContextParams(params);
                break;
            }
            case "CreateGraph": {
                NeptuneGraphResolveEndpointInterceptor.createGraphStaticContextParams(params);
                break;
            }
            case "CreateGraphSnapshot": {
                NeptuneGraphResolveEndpointInterceptor.createGraphSnapshotStaticContextParams(params);
                break;
            }
            case "CreateGraphUsingImportTask": {
                NeptuneGraphResolveEndpointInterceptor.createGraphUsingImportTaskStaticContextParams(params);
                break;
            }
            case "CreatePrivateGraphEndpoint": {
                NeptuneGraphResolveEndpointInterceptor.createPrivateGraphEndpointStaticContextParams(params);
                break;
            }
            case "DeleteGraph": {
                NeptuneGraphResolveEndpointInterceptor.deleteGraphStaticContextParams(params);
                break;
            }
            case "DeleteGraphSnapshot": {
                NeptuneGraphResolveEndpointInterceptor.deleteGraphSnapshotStaticContextParams(params);
                break;
            }
            case "DeletePrivateGraphEndpoint": {
                NeptuneGraphResolveEndpointInterceptor.deletePrivateGraphEndpointStaticContextParams(params);
                break;
            }
            case "ExecuteQuery": {
                NeptuneGraphResolveEndpointInterceptor.executeQueryStaticContextParams(params);
                break;
            }
            case "GetExportTask": {
                NeptuneGraphResolveEndpointInterceptor.getExportTaskStaticContextParams(params);
                break;
            }
            case "GetGraph": {
                NeptuneGraphResolveEndpointInterceptor.getGraphStaticContextParams(params);
                break;
            }
            case "GetGraphSnapshot": {
                NeptuneGraphResolveEndpointInterceptor.getGraphSnapshotStaticContextParams(params);
                break;
            }
            case "GetGraphSummary": {
                NeptuneGraphResolveEndpointInterceptor.getGraphSummaryStaticContextParams(params);
                break;
            }
            case "GetImportTask": {
                NeptuneGraphResolveEndpointInterceptor.getImportTaskStaticContextParams(params);
                break;
            }
            case "GetPrivateGraphEndpoint": {
                NeptuneGraphResolveEndpointInterceptor.getPrivateGraphEndpointStaticContextParams(params);
                break;
            }
            case "GetQuery": {
                NeptuneGraphResolveEndpointInterceptor.getQueryStaticContextParams(params);
                break;
            }
            case "ListExportTasks": {
                NeptuneGraphResolveEndpointInterceptor.listExportTasksStaticContextParams(params);
                break;
            }
            case "ListGraphSnapshots": {
                NeptuneGraphResolveEndpointInterceptor.listGraphSnapshotsStaticContextParams(params);
                break;
            }
            case "ListGraphs": {
                NeptuneGraphResolveEndpointInterceptor.listGraphsStaticContextParams(params);
                break;
            }
            case "ListImportTasks": {
                NeptuneGraphResolveEndpointInterceptor.listImportTasksStaticContextParams(params);
                break;
            }
            case "ListPrivateGraphEndpoints": {
                NeptuneGraphResolveEndpointInterceptor.listPrivateGraphEndpointsStaticContextParams(params);
                break;
            }
            case "ListQueries": {
                NeptuneGraphResolveEndpointInterceptor.listQueriesStaticContextParams(params);
                break;
            }
            case "ListTagsForResource": {
                NeptuneGraphResolveEndpointInterceptor.listTagsForResourceStaticContextParams(params);
                break;
            }
            case "ResetGraph": {
                NeptuneGraphResolveEndpointInterceptor.resetGraphStaticContextParams(params);
                break;
            }
            case "RestoreGraphFromSnapshot": {
                NeptuneGraphResolveEndpointInterceptor.restoreGraphFromSnapshotStaticContextParams(params);
                break;
            }
            case "StartExportTask": {
                NeptuneGraphResolveEndpointInterceptor.startExportTaskStaticContextParams(params);
                break;
            }
            case "StartImportTask": {
                NeptuneGraphResolveEndpointInterceptor.startImportTaskStaticContextParams(params);
                break;
            }
            case "TagResource": {
                NeptuneGraphResolveEndpointInterceptor.tagResourceStaticContextParams(params);
                break;
            }
            case "UntagResource": {
                NeptuneGraphResolveEndpointInterceptor.untagResourceStaticContextParams(params);
                break;
            }
            case "UpdateGraph": {
                NeptuneGraphResolveEndpointInterceptor.updateGraphStaticContextParams(params);
                break;
            }
        }
    }

    private static void cancelExportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void cancelImportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void cancelQueryStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("DataPlane");
    }

    private static void createGraphStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void createGraphSnapshotStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void createGraphUsingImportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void createPrivateGraphEndpointStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void deleteGraphStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void deleteGraphSnapshotStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void deletePrivateGraphEndpointStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void executeQueryStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("DataPlane");
    }

    private static void getExportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void getGraphStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void getGraphSnapshotStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void getGraphSummaryStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("DataPlane");
    }

    private static void getImportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void getPrivateGraphEndpointStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void getQueryStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("DataPlane");
    }

    private static void listExportTasksStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void listGraphSnapshotsStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void listGraphsStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void listImportTasksStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void listPrivateGraphEndpointsStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void listQueriesStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("DataPlane");
    }

    private static void listTagsForResourceStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void resetGraphStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void restoreGraphFromSnapshotStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void startExportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void startImportTaskStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void tagResourceStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void untagResourceStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private static void updateGraphStaticContextParams(NeptuneGraphEndpointParams.Builder params) {
        params.apiType("ControlPlane");
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (!CollectionUtils.isNullOrEmpty((Collection)v4aAuthScheme.signingRegionSet())) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setOperationContextParams(NeptuneGraphEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        switch (operationName) {
            case "CancelQuery": {
                HostnameValidator.validateHostnameCompliant((String)request.getValueForField("graphIdentifier", String.class).orElse(null), (String)"graphIdentifier", (String)"cancelQueryRequest");
                return Optional.of(String.format("%s.", request.getValueForField("graphIdentifier", String.class).get()));
            }
            case "ExecuteQuery": {
                HostnameValidator.validateHostnameCompliant((String)request.getValueForField("graphIdentifier", String.class).orElse(null), (String)"graphIdentifier", (String)"executeQueryRequest");
                return Optional.of(String.format("%s.", request.getValueForField("graphIdentifier", String.class).get()));
            }
            case "GetGraphSummary": {
                HostnameValidator.validateHostnameCompliant((String)request.getValueForField("graphIdentifier", String.class).orElse(null), (String)"graphIdentifier", (String)"getGraphSummaryRequest");
                return Optional.of(String.format("%s.", request.getValueForField("graphIdentifier", String.class).get()));
            }
            case "GetQuery": {
                HostnameValidator.validateHostnameCompliant((String)request.getValueForField("graphIdentifier", String.class).orElse(null), (String)"graphIdentifier", (String)"getQueryRequest");
                return Optional.of(String.format("%s.", request.getValueForField("graphIdentifier", String.class).get()));
            }
            case "ListQueries": {
                HostnameValidator.validateHostnameCompliant((String)request.getValueForField("graphIdentifier", String.class).orElse(null), (String)"graphIdentifier", (String)"listQueriesRequest");
                return Optional.of(String.format("%s.", request.getValueForField("graphIdentifier", String.class).get()));
            }
        }
        return Optional.empty();
    }
}

