/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.neptunegraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.neptunegraph.model.GraphStatus;
import software.amazon.awssdk.services.neptunegraph.model.NeptuneGraphResponse;
import software.amazon.awssdk.services.neptunegraph.model.VectorSearchConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGraphResponse
extends NeptuneGraphResponse
implements ToCopyableBuilder<Builder, GetGraphResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetGraphResponse.getter(GetGraphResponse::id)).setter(GetGraphResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetGraphResponse.getter(GetGraphResponse::name)).setter(GetGraphResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetGraphResponse.getter(GetGraphResponse::arn)).setter(GetGraphResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetGraphResponse.getter(GetGraphResponse::statusAsString)).setter(GetGraphResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(GetGraphResponse.getter(GetGraphResponse::statusReason)).setter(GetGraphResponse.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createTime").getter(GetGraphResponse.getter(GetGraphResponse::createTime)).setter(GetGraphResponse.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createTime").build()}).build();
    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionedMemory").getter(GetGraphResponse.getter(GetGraphResponse::provisionedMemory)).setter(GetGraphResponse.setter(Builder::provisionedMemory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("endpoint").getter(GetGraphResponse.getter(GetGraphResponse::endpoint)).setter(GetGraphResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()}).build();
    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publicConnectivity").getter(GetGraphResponse.getter(GetGraphResponse::publicConnectivity)).setter(GetGraphResponse.setter(Builder::publicConnectivity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build()}).build();
    private static final SdkField<VectorSearchConfiguration> VECTOR_SEARCH_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorSearchConfiguration").getter(GetGraphResponse.getter(GetGraphResponse::vectorSearchConfiguration)).setter(GetGraphResponse.setter(Builder::vectorSearchConfiguration)).constructor(VectorSearchConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorSearchConfiguration").build()}).build();
    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("replicaCount").getter(GetGraphResponse.getter(GetGraphResponse::replicaCount)).setter(GetGraphResponse.setter(Builder::replicaCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()}).build();
    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyIdentifier").getter(GetGraphResponse.getter(GetGraphResponse::kmsKeyIdentifier)).setter(GetGraphResponse.setter(Builder::kmsKeyIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()}).build();
    private static final SdkField<String> SOURCE_SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceSnapshotId").getter(GetGraphResponse.getter(GetGraphResponse::sourceSnapshotId)).setter(GetGraphResponse.setter(Builder::sourceSnapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceSnapshotId").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("deletionProtection").getter(GetGraphResponse.getter(GetGraphResponse::deletionProtection)).setter(GetGraphResponse.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build()}).build();
    private static final SdkField<String> BUILD_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildNumber").getter(GetGraphResponse.getter(GetGraphResponse::buildNumber)).setter(GetGraphResponse.setter(Builder::buildNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CREATE_TIME_FIELD, PROVISIONED_MEMORY_FIELD, ENDPOINT_FIELD, PUBLIC_CONNECTIVITY_FIELD, VECTOR_SEARCH_CONFIGURATION_FIELD, REPLICA_COUNT_FIELD, KMS_KEY_IDENTIFIER_FIELD, SOURCE_SNAPSHOT_ID_FIELD, DELETION_PROTECTION_FIELD, BUILD_NUMBER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetGraphResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String arn;
    private final String status;
    private final String statusReason;
    private final Instant createTime;
    private final Integer provisionedMemory;
    private final String endpoint;
    private final Boolean publicConnectivity;
    private final VectorSearchConfiguration vectorSearchConfiguration;
    private final Integer replicaCount;
    private final String kmsKeyIdentifier;
    private final String sourceSnapshotId;
    private final Boolean deletionProtection;
    private final String buildNumber;

    private GetGraphResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.createTime = builder.createTime;
        this.provisionedMemory = builder.provisionedMemory;
        this.endpoint = builder.endpoint;
        this.publicConnectivity = builder.publicConnectivity;
        this.vectorSearchConfiguration = builder.vectorSearchConfiguration;
        this.replicaCount = builder.replicaCount;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.sourceSnapshotId = builder.sourceSnapshotId;
        this.deletionProtection = builder.deletionProtection;
        this.buildNumber = builder.buildNumber;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String arn() {
        return this.arn;
    }

    public final GraphStatus status() {
        return GraphStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final Integer provisionedMemory() {
        return this.provisionedMemory;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final Boolean publicConnectivity() {
        return this.publicConnectivity;
    }

    public final VectorSearchConfiguration vectorSearchConfiguration() {
        return this.vectorSearchConfiguration;
    }

    public final Integer replicaCount() {
        return this.replicaCount;
    }

    public final String kmsKeyIdentifier() {
        return this.kmsKeyIdentifier;
    }

    public final String sourceSnapshotId() {
        return this.sourceSnapshotId;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final String buildNumber() {
        return this.buildNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorSearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceSnapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.buildNumber());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGraphResponse)) {
            return false;
        }
        GetGraphResponse other = (GetGraphResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.provisionedMemory(), other.provisionedMemory()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.publicConnectivity(), other.publicConnectivity()) && Objects.equals(this.vectorSearchConfiguration(), other.vectorSearchConfiguration()) && Objects.equals(this.replicaCount(), other.replicaCount()) && Objects.equals(this.kmsKeyIdentifier(), other.kmsKeyIdentifier()) && Objects.equals(this.sourceSnapshotId(), other.sourceSnapshotId()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.buildNumber(), other.buildNumber());
    }

    public final String toString() {
        return ToString.builder((String)"GetGraphResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CreateTime", (Object)this.createTime()).add("ProvisionedMemory", (Object)this.provisionedMemory()).add("Endpoint", (Object)this.endpoint()).add("PublicConnectivity", (Object)this.publicConnectivity()).add("VectorSearchConfiguration", (Object)this.vectorSearchConfiguration()).add("ReplicaCount", (Object)this.replicaCount()).add("KmsKeyIdentifier", (Object)this.kmsKeyIdentifier()).add("SourceSnapshotId", (Object)this.sourceSnapshotId()).add("DeletionProtection", (Object)this.deletionProtection()).add("BuildNumber", (Object)this.buildNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "createTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "provisionedMemory": {
                return Optional.ofNullable(clazz.cast(this.provisionedMemory()));
            }
            case "endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "publicConnectivity": {
                return Optional.ofNullable(clazz.cast(this.publicConnectivity()));
            }
            case "vectorSearchConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorSearchConfiguration()));
            }
            case "replicaCount": {
                return Optional.ofNullable(clazz.cast(this.replicaCount()));
            }
            case "kmsKeyIdentifier": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyIdentifier()));
            }
            case "sourceSnapshotId": {
                return Optional.ofNullable(clazz.cast(this.sourceSnapshotId()));
            }
            case "deletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "buildNumber": {
                return Optional.ofNullable(clazz.cast(this.buildNumber()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("createTime", CREATE_TIME_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("vectorSearchConfiguration", VECTOR_SEARCH_CONFIGURATION_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("sourceSnapshotId", SOURCE_SNAPSHOT_ID_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        map.put("buildNumber", BUILD_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetGraphResponse, T> g) {
        return obj -> g.apply((GetGraphResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NeptuneGraphResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String arn;
        private String status;
        private String statusReason;
        private Instant createTime;
        private Integer provisionedMemory;
        private String endpoint;
        private Boolean publicConnectivity;
        private VectorSearchConfiguration vectorSearchConfiguration;
        private Integer replicaCount;
        private String kmsKeyIdentifier;
        private String sourceSnapshotId;
        private Boolean deletionProtection;
        private String buildNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGraphResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.arn(model.arn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.createTime(model.createTime);
            this.provisionedMemory(model.provisionedMemory);
            this.endpoint(model.endpoint);
            this.publicConnectivity(model.publicConnectivity);
            this.vectorSearchConfiguration(model.vectorSearchConfiguration);
            this.replicaCount(model.replicaCount);
            this.kmsKeyIdentifier(model.kmsKeyIdentifier);
            this.sourceSnapshotId(model.sourceSnapshotId);
            this.deletionProtection(model.deletionProtection);
            this.buildNumber(model.buildNumber);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GraphStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return this.provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return this.publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final VectorSearchConfiguration.Builder getVectorSearchConfiguration() {
            return this.vectorSearchConfiguration != null ? this.vectorSearchConfiguration.toBuilder() : null;
        }

        public final void setVectorSearchConfiguration(VectorSearchConfiguration.BuilderImpl vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration != null ? vectorSearchConfiguration.build() : null;
        }

        @Override
        public final Builder vectorSearchConfiguration(VectorSearchConfiguration vectorSearchConfiguration) {
            this.vectorSearchConfiguration = vectorSearchConfiguration;
            return this;
        }

        public final Integer getReplicaCount() {
            return this.replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return this.kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getSourceSnapshotId() {
            return this.sourceSnapshotId;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getBuildNumber() {
            return this.buildNumber;
        }

        public final void setBuildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
        }

        @Override
        public final Builder buildNumber(String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @Override
        public GetGraphResponse build() {
            return new GetGraphResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NeptuneGraphResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGraphResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder status(String var1);

        public Builder status(GraphStatus var1);

        public Builder statusReason(String var1);

        public Builder createTime(Instant var1);

        public Builder provisionedMemory(Integer var1);

        public Builder endpoint(String var1);

        public Builder publicConnectivity(Boolean var1);

        public Builder vectorSearchConfiguration(VectorSearchConfiguration var1);

        default public Builder vectorSearchConfiguration(Consumer<VectorSearchConfiguration.Builder> vectorSearchConfiguration) {
            return this.vectorSearchConfiguration((VectorSearchConfiguration)((VectorSearchConfiguration.Builder)VectorSearchConfiguration.builder().applyMutation(vectorSearchConfiguration)).build());
        }

        public Builder replicaCount(Integer var1);

        public Builder kmsKeyIdentifier(String var1);

        public Builder sourceSnapshotId(String var1);

        public Builder deletionProtection(Boolean var1);

        public Builder buildNumber(String var1);
    }
}

