/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateGraphSnapshotResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<CreateGraphSnapshotResponse.Builder, CreateGraphSnapshotResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateGraphSnapshotResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateGraphSnapshotResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateGraphSnapshotResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> SOURCE_GRAPH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceGraphId").getter(getter(CreateGraphSnapshotResponse::sourceGraphId))
            .setter(setter(Builder::sourceGraphId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceGraphId").build()).build();

    private static final SdkField<Instant> SNAPSHOT_CREATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("snapshotCreateTime").getter(getter(CreateGraphSnapshotResponse::snapshotCreateTime))
            .setter(setter(Builder::snapshotCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotCreateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateGraphSnapshotResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CreateGraphSnapshotResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, SOURCE_GRAPH_ID_FIELD, SNAPSHOT_CREATE_TIME_FIELD, STATUS_FIELD, KMS_KEY_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String arn;

    private final String sourceGraphId;

    private final Instant snapshotCreateTime;

    private final String status;

    private final String kmsKeyIdentifier;

    private CreateGraphSnapshotResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.sourceGraphId = builder.sourceGraphId;
        this.snapshotCreateTime = builder.snapshotCreateTime;
        this.status = builder.status;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
    }

    /**
     * <p>
     * The ID of the snapshot created.
     * </p>
     * 
     * @return The ID of the snapshot created.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the snapshot created.
     * </p>
     * 
     * @return The name of the snapshot created.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN of the snapshot created.
     * </p>
     * 
     * @return The ARN of the snapshot created.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Id of the Neptune Analytics graph from which the snapshot is created.
     * </p>
     * 
     * @return The Id of the Neptune Analytics graph from which the snapshot is created.
     */
    public final String sourceGraphId() {
        return sourceGraphId;
    }

    /**
     * <p>
     * The snapshot creation time
     * </p>
     * 
     * @return The snapshot creation time
     */
    public final Instant snapshotCreateTime() {
        return snapshotCreateTime;
    }

    /**
     * <p>
     * The current state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the snapshot.
     * @see SnapshotStatus
     */
    public final SnapshotStatus status() {
        return SnapshotStatus.fromValue(status);
    }

    /**
     * <p>
     * The current state of the snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SnapshotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current state of the snapshot.
     * @see SnapshotStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt and decrypt graph data.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt and decrypt graph data.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceGraphId());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGraphSnapshotResponse)) {
            return false;
        }
        CreateGraphSnapshotResponse other = (CreateGraphSnapshotResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(sourceGraphId(), other.sourceGraphId())
                && Objects.equals(snapshotCreateTime(), other.snapshotCreateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateGraphSnapshotResponse").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("SourceGraphId", sourceGraphId()).add("SnapshotCreateTime", snapshotCreateTime())
                .add("Status", statusAsString()).add("KmsKeyIdentifier", kmsKeyIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "sourceGraphId":
            return Optional.ofNullable(clazz.cast(sourceGraphId()));
        case "snapshotCreateTime":
            return Optional.ofNullable(clazz.cast(snapshotCreateTime()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("sourceGraphId", SOURCE_GRAPH_ID_FIELD);
        map.put("snapshotCreateTime", SNAPSHOT_CREATE_TIME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateGraphSnapshotResponse, T> g) {
        return obj -> g.apply((CreateGraphSnapshotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateGraphSnapshotResponse> {
        /**
         * <p>
         * The ID of the snapshot created.
         * </p>
         * 
         * @param id
         *        The ID of the snapshot created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the snapshot created.
         * </p>
         * 
         * @param name
         *        The name of the snapshot created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN of the snapshot created.
         * </p>
         * 
         * @param arn
         *        The ARN of the snapshot created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Id of the Neptune Analytics graph from which the snapshot is created.
         * </p>
         * 
         * @param sourceGraphId
         *        The Id of the Neptune Analytics graph from which the snapshot is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceGraphId(String sourceGraphId);

        /**
         * <p>
         * The snapshot creation time
         * </p>
         * 
         * @param snapshotCreateTime
         *        The snapshot creation time
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCreateTime(Instant snapshotCreateTime);

        /**
         * <p>
         * The current state of the snapshot.
         * </p>
         * 
         * @param status
         *        The current state of the snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current state of the snapshot.
         * </p>
         * 
         * @param status
         *        The current state of the snapshot.
         * @see SnapshotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotStatus
         */
        Builder status(SnapshotStatus status);

        /**
         * <p>
         * The ID of the KMS key used to encrypt and decrypt graph data.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The ID of the KMS key used to encrypt and decrypt graph data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String sourceGraphId;

        private Instant snapshotCreateTime;

        private String status;

        private String kmsKeyIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGraphSnapshotResponse model) {
            super(model);
            id(model.id);
            name(model.name);
            arn(model.arn);
            sourceGraphId(model.sourceGraphId);
            snapshotCreateTime(model.snapshotCreateTime);
            status(model.status);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSourceGraphId() {
            return sourceGraphId;
        }

        public final void setSourceGraphId(String sourceGraphId) {
            this.sourceGraphId = sourceGraphId;
        }

        @Override
        public final Builder sourceGraphId(String sourceGraphId) {
            this.sourceGraphId = sourceGraphId;
            return this;
        }

        public final Instant getSnapshotCreateTime() {
            return snapshotCreateTime;
        }

        public final void setSnapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
        }

        @Override
        public final Builder snapshotCreateTime(Instant snapshotCreateTime) {
            this.snapshotCreateTime = snapshotCreateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SnapshotStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        @Override
        public CreateGraphSnapshotResponse build() {
            return new CreateGraphSnapshotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
