/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the specified export task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportTaskDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ExportTaskDetails.Builder, ExportTaskDetails> {
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(ExportTaskDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Long> TIME_ELAPSED_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("timeElapsedSeconds").getter(getter(ExportTaskDetails::timeElapsedSeconds))
            .setter(setter(Builder::timeElapsedSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeElapsedSeconds").build())
            .build();

    private static final SdkField<Integer> PROGRESS_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("progressPercentage").getter(getter(ExportTaskDetails::progressPercentage))
            .setter(setter(Builder::progressPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressPercentage").build())
            .build();

    private static final SdkField<Long> NUM_VERTICES_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numVerticesWritten").getter(getter(ExportTaskDetails::numVerticesWritten))
            .setter(setter(Builder::numVerticesWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numVerticesWritten").build())
            .build();

    private static final SdkField<Long> NUM_EDGES_WRITTEN_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("numEdgesWritten").getter(getter(ExportTaskDetails::numEdgesWritten))
            .setter(setter(Builder::numEdgesWritten))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numEdgesWritten").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(START_TIME_FIELD,
            TIME_ELAPSED_SECONDS_FIELD, PROGRESS_PERCENTAGE_FIELD, NUM_VERTICES_WRITTEN_FIELD, NUM_EDGES_WRITTEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant startTime;

    private final Long timeElapsedSeconds;

    private final Integer progressPercentage;

    private final Long numVerticesWritten;

    private final Long numEdgesWritten;

    private ExportTaskDetails(BuilderImpl builder) {
        this.startTime = builder.startTime;
        this.timeElapsedSeconds = builder.timeElapsedSeconds;
        this.progressPercentage = builder.progressPercentage;
        this.numVerticesWritten = builder.numVerticesWritten;
        this.numEdgesWritten = builder.numEdgesWritten;
    }

    /**
     * <p>
     * The start time of the export task.
     * </p>
     * 
     * @return The start time of the export task.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time elapsed, in seconds, since the start time of the export task.
     * </p>
     * 
     * @return The time elapsed, in seconds, since the start time of the export task.
     */
    public final Long timeElapsedSeconds() {
        return timeElapsedSeconds;
    }

    /**
     * <p>
     * The number of progress percentage of the export task.
     * </p>
     * 
     * @return The number of progress percentage of the export task.
     */
    public final Integer progressPercentage() {
        return progressPercentage;
    }

    /**
     * <p>
     * The number of exported vertices.
     * </p>
     * 
     * @return The number of exported vertices.
     */
    public final Long numVerticesWritten() {
        return numVerticesWritten;
    }

    /**
     * <p>
     * The number of exported edges.
     * </p>
     * 
     * @return The number of exported edges.
     */
    public final Long numEdgesWritten() {
        return numEdgesWritten;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(timeElapsedSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(progressPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(numVerticesWritten());
        hashCode = 31 * hashCode + Objects.hashCode(numEdgesWritten());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTaskDetails)) {
            return false;
        }
        ExportTaskDetails other = (ExportTaskDetails) obj;
        return Objects.equals(startTime(), other.startTime()) && Objects.equals(timeElapsedSeconds(), other.timeElapsedSeconds())
                && Objects.equals(progressPercentage(), other.progressPercentage())
                && Objects.equals(numVerticesWritten(), other.numVerticesWritten())
                && Objects.equals(numEdgesWritten(), other.numEdgesWritten());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportTaskDetails").add("StartTime", startTime())
                .add("TimeElapsedSeconds", timeElapsedSeconds()).add("ProgressPercentage", progressPercentage())
                .add("NumVerticesWritten", numVerticesWritten()).add("NumEdgesWritten", numEdgesWritten()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "timeElapsedSeconds":
            return Optional.ofNullable(clazz.cast(timeElapsedSeconds()));
        case "progressPercentage":
            return Optional.ofNullable(clazz.cast(progressPercentage()));
        case "numVerticesWritten":
            return Optional.ofNullable(clazz.cast(numVerticesWritten()));
        case "numEdgesWritten":
            return Optional.ofNullable(clazz.cast(numEdgesWritten()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("startTime", START_TIME_FIELD);
        map.put("timeElapsedSeconds", TIME_ELAPSED_SECONDS_FIELD);
        map.put("progressPercentage", PROGRESS_PERCENTAGE_FIELD);
        map.put("numVerticesWritten", NUM_VERTICES_WRITTEN_FIELD);
        map.put("numEdgesWritten", NUM_EDGES_WRITTEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportTaskDetails, T> g) {
        return obj -> g.apply((ExportTaskDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportTaskDetails> {
        /**
         * <p>
         * The start time of the export task.
         * </p>
         * 
         * @param startTime
         *        The start time of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time elapsed, in seconds, since the start time of the export task.
         * </p>
         * 
         * @param timeElapsedSeconds
         *        The time elapsed, in seconds, since the start time of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeElapsedSeconds(Long timeElapsedSeconds);

        /**
         * <p>
         * The number of progress percentage of the export task.
         * </p>
         * 
         * @param progressPercentage
         *        The number of progress percentage of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercentage(Integer progressPercentage);

        /**
         * <p>
         * The number of exported vertices.
         * </p>
         * 
         * @param numVerticesWritten
         *        The number of exported vertices.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numVerticesWritten(Long numVerticesWritten);

        /**
         * <p>
         * The number of exported edges.
         * </p>
         * 
         * @param numEdgesWritten
         *        The number of exported edges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numEdgesWritten(Long numEdgesWritten);
    }

    static final class BuilderImpl implements Builder {
        private Instant startTime;

        private Long timeElapsedSeconds;

        private Integer progressPercentage;

        private Long numVerticesWritten;

        private Long numEdgesWritten;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportTaskDetails model) {
            startTime(model.startTime);
            timeElapsedSeconds(model.timeElapsedSeconds);
            progressPercentage(model.progressPercentage);
            numVerticesWritten(model.numVerticesWritten);
            numEdgesWritten(model.numEdgesWritten);
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Long getTimeElapsedSeconds() {
            return timeElapsedSeconds;
        }

        public final void setTimeElapsedSeconds(Long timeElapsedSeconds) {
            this.timeElapsedSeconds = timeElapsedSeconds;
        }

        @Override
        public final Builder timeElapsedSeconds(Long timeElapsedSeconds) {
            this.timeElapsedSeconds = timeElapsedSeconds;
            return this;
        }

        public final Integer getProgressPercentage() {
            return progressPercentage;
        }

        public final void setProgressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
        }

        @Override
        public final Builder progressPercentage(Integer progressPercentage) {
            this.progressPercentage = progressPercentage;
            return this;
        }

        public final Long getNumVerticesWritten() {
            return numVerticesWritten;
        }

        public final void setNumVerticesWritten(Long numVerticesWritten) {
            this.numVerticesWritten = numVerticesWritten;
        }

        @Override
        public final Builder numVerticesWritten(Long numVerticesWritten) {
            this.numVerticesWritten = numVerticesWritten;
            return this;
        }

        public final Long getNumEdgesWritten() {
            return numEdgesWritten;
        }

        public final void setNumEdgesWritten(Long numEdgesWritten) {
            this.numEdgesWritten = numEdgesWritten;
        }

        @Override
        public final Builder numEdgesWritten(Long numEdgesWritten) {
            this.numEdgesWritten = numEdgesWritten;
            return this;
        }

        @Override
        public ExportTaskDetails build() {
            return new ExportTaskDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
