/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary details about a graph.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphSummary implements SdkPojo, Serializable, ToCopyableBuilder<GraphSummary.Builder, GraphSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GraphSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GraphSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GraphSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GraphSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedMemory").getter(getter(GraphSummary::provisionedMemory))
            .setter(setter(Builder::provisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(GraphSummary::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(GraphSummary::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<Integer> REPLICA_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("replicaCount").getter(getter(GraphSummary::replicaCount)).setter(setter(Builder::replicaCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaCount").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(GraphSummary::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(GraphSummary::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            ARN_FIELD, STATUS_FIELD, PROVISIONED_MEMORY_FIELD, PUBLIC_CONNECTIVITY_FIELD, ENDPOINT_FIELD, REPLICA_COUNT_FIELD,
            KMS_KEY_IDENTIFIER_FIELD, DELETION_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String arn;

    private final String status;

    private final Integer provisionedMemory;

    private final Boolean publicConnectivity;

    private final String endpoint;

    private final Integer replicaCount;

    private final String kmsKeyIdentifier;

    private final Boolean deletionProtection;

    private GraphSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.arn = builder.arn;
        this.status = builder.status;
        this.provisionedMemory = builder.provisionedMemory;
        this.publicConnectivity = builder.publicConnectivity;
        this.endpoint = builder.endpoint;
        this.replicaCount = builder.replicaCount;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The unique identifier of the graph.
     * </p>
     * 
     * @return The unique identifier of the graph.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the graph.
     * </p>
     * 
     * @return The name of the graph.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ARN associated with the graph.
     * </p>
     * 
     * @return The ARN associated with the graph.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The status of the graph.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GraphStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the graph.
     * @see GraphStatus
     */
    public final GraphStatus status() {
        return GraphStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the graph.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link GraphStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the graph.
     * @see GraphStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
     * </p>
     * 
     * @return The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
     */
    public final Integer provisionedMemory() {
        return provisionedMemory;
    }

    /**
     * <p>
     * If <code>true</code>, the graph has a public endpoint, otherwise not.
     * </p>
     * 
     * @return If <code>true</code>, the graph has a public endpoint, otherwise not.
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    /**
     * <p>
     * The graph endpoint.
     * </p>
     * 
     * @return The graph endpoint.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The number of replicas for the graph.
     * </p>
     * 
     * @return The number of replicas for the graph.
     */
    public final Integer replicaCount() {
        return replicaCount;
    }

    /**
     * <p>
     * The ID of the KMS key used to encrypt and decrypt graph data.
     * </p>
     * 
     * @return The ID of the KMS key used to encrypt and decrypt graph data.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * If <code>true</code>, deletion protection is enabled for the graph.
     * </p>
     * 
     * @return If <code>true</code>, deletion protection is enabled for the graph.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(replicaCount());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphSummary)) {
            return false;
        }
        GraphSummary other = (GraphSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name()) && Objects.equals(arn(), other.arn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(provisionedMemory(), other.provisionedMemory())
                && Objects.equals(publicConnectivity(), other.publicConnectivity())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(replicaCount(), other.replicaCount())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GraphSummary").add("Id", id()).add("Name", name()).add("Arn", arn())
                .add("Status", statusAsString()).add("ProvisionedMemory", provisionedMemory())
                .add("PublicConnectivity", publicConnectivity()).add("Endpoint", endpoint()).add("ReplicaCount", replicaCount())
                .add("KmsKeyIdentifier", kmsKeyIdentifier()).add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "provisionedMemory":
            return Optional.ofNullable(clazz.cast(provisionedMemory()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "replicaCount":
            return Optional.ofNullable(clazz.cast(replicaCount()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("replicaCount", REPLICA_COUNT_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraphSummary, T> g) {
        return obj -> g.apply((GraphSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphSummary> {
        /**
         * <p>
         * The unique identifier of the graph.
         * </p>
         * 
         * @param id
         *        The unique identifier of the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the graph.
         * </p>
         * 
         * @param name
         *        The name of the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ARN associated with the graph.
         * </p>
         * 
         * @param arn
         *        The ARN associated with the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The status of the graph.
         * </p>
         * 
         * @param status
         *        The status of the graph.
         * @see GraphStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the graph.
         * </p>
         * 
         * @param status
         *        The status of the graph.
         * @see GraphStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GraphStatus
         */
        Builder status(GraphStatus status);

        /**
         * <p>
         * The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
         * </p>
         * 
         * @param provisionedMemory
         *        The number of memory-optimized Neptune Capacity Units (m-NCUs) allocated to the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedMemory(Integer provisionedMemory);

        /**
         * <p>
         * If <code>true</code>, the graph has a public endpoint, otherwise not.
         * </p>
         * 
         * @param publicConnectivity
         *        If <code>true</code>, the graph has a public endpoint, otherwise not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        /**
         * <p>
         * The graph endpoint.
         * </p>
         * 
         * @param endpoint
         *        The graph endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The number of replicas for the graph.
         * </p>
         * 
         * @param replicaCount
         *        The number of replicas for the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaCount(Integer replicaCount);

        /**
         * <p>
         * The ID of the KMS key used to encrypt and decrypt graph data.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The ID of the KMS key used to encrypt and decrypt graph data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * If <code>true</code>, deletion protection is enabled for the graph.
         * </p>
         * 
         * @param deletionProtection
         *        If <code>true</code>, deletion protection is enabled for the graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String arn;

        private String status;

        private Integer provisionedMemory;

        private Boolean publicConnectivity;

        private String endpoint;

        private Integer replicaCount;

        private String kmsKeyIdentifier;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphSummary model) {
            id(model.id);
            name(model.name);
            arn(model.arn);
            status(model.status);
            provisionedMemory(model.provisionedMemory);
            publicConnectivity(model.publicConnectivity);
            endpoint(model.endpoint);
            replicaCount(model.replicaCount);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            deletionProtection(model.deletionProtection);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(GraphStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Integer getProvisionedMemory() {
            return provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Integer getReplicaCount() {
            return replicaCount;
        }

        public final void setReplicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
        }

        @Override
        public final Builder replicaCount(Integer replicaCount) {
            this.replicaCount = replicaCount;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public GraphSummary build() {
            return new GraphSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
