/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for how to perform an import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportOptions implements SdkPojo, Serializable, ToCopyableBuilder<ImportOptions.Builder, ImportOptions> {
    private static final SdkField<NeptuneImportOptions> NEPTUNE_FIELD = SdkField
            .<NeptuneImportOptions> builder(MarshallingType.SDK_POJO).memberName("neptune")
            .getter(getter(ImportOptions::neptune)).setter(setter(Builder::neptune)).constructor(NeptuneImportOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("neptune").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEPTUNE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final NeptuneImportOptions neptune;

    private final Type type;

    private ImportOptions(BuilderImpl builder) {
        this.neptune = builder.neptune;
        this.type = builder.type;
    }

    /**
     * <p>
     * Options for importing data from a Neptune database.
     * </p>
     * 
     * @return Options for importing data from a Neptune database.
     */
    public final NeptuneImportOptions neptune() {
        return neptune;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(neptune());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportOptions)) {
            return false;
        }
        ImportOptions other = (ImportOptions) obj;
        return Objects.equals(neptune(), other.neptune());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportOptions").add("Neptune", neptune()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "neptune":
            return Optional.ofNullable(clazz.cast(neptune()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #neptune()} initialized to the given value.
     *
     * <p>
     * Options for importing data from a Neptune database.
     * </p>
     * 
     * @param neptune
     *        Options for importing data from a Neptune database.
     */
    public static ImportOptions fromNeptune(NeptuneImportOptions neptune) {
        return builder().neptune(neptune).build();
    }

    /**
     * Create an instance of this class with {@link #neptune()} initialized to the given value.
     *
     * <p>
     * Options for importing data from a Neptune database.
     * </p>
     * 
     * @param neptune
     *        Options for importing data from a Neptune database.
     */
    public static ImportOptions fromNeptune(Consumer<NeptuneImportOptions.Builder> neptune) {
        NeptuneImportOptions.Builder builder = NeptuneImportOptions.builder();
        neptune.accept(builder);
        return fromNeptune(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("neptune", NEPTUNE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportOptions, T> g) {
        return obj -> g.apply((ImportOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportOptions> {
        /**
         * <p>
         * Options for importing data from a Neptune database.
         * </p>
         * 
         * @param neptune
         *        Options for importing data from a Neptune database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder neptune(NeptuneImportOptions neptune);

        /**
         * <p>
         * Options for importing data from a Neptune database.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeptuneImportOptions.Builder} avoiding
         * the need to create one manually via {@link NeptuneImportOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeptuneImportOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #neptune(NeptuneImportOptions)}.
         * 
         * @param neptune
         *        a consumer that will call methods on {@link NeptuneImportOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #neptune(NeptuneImportOptions)
         */
        default Builder neptune(Consumer<NeptuneImportOptions.Builder> neptune) {
            return neptune(NeptuneImportOptions.builder().applyMutation(neptune).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NeptuneImportOptions neptune;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ImportOptions model) {
            neptune(model.neptune);
        }

        public final NeptuneImportOptions.Builder getNeptune() {
            return neptune != null ? neptune.toBuilder() : null;
        }

        public final void setNeptune(NeptuneImportOptions.BuilderImpl neptune) {
            Object oldValue = this.neptune;
            this.neptune = neptune != null ? neptune.build() : null;
            handleUnionValueChange(Type.NEPTUNE, oldValue, this.neptune);
        }

        @Override
        public final Builder neptune(NeptuneImportOptions neptune) {
            Object oldValue = this.neptune;
            this.neptune = neptune;
            handleUnionValueChange(Type.NEPTUNE, oldValue, this.neptune);
            return this;
        }

        @Override
        public ImportOptions build() {
            return new ImportOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ImportOptions#type()
     */
    public enum Type {
        NEPTUNE,

        UNKNOWN_TO_SDK_VERSION
    }
}
