/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelExportTaskResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<CancelExportTaskResponse.Builder, CancelExportTaskResponse> {
    private static final SdkField<String> GRAPH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphId").getter(getter(CancelExportTaskResponse::graphId)).setter(setter(Builder::graphId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(CancelExportTaskResponse::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("taskId")
            .getter(getter(CancelExportTaskResponse::taskId)).setter(setter(Builder::taskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CancelExportTaskResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(CancelExportTaskResponse::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<String> DESTINATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destination").getter(getter(CancelExportTaskResponse::destination)).setter(setter(Builder::destination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destination").build()).build();

    private static final SdkField<String> KMS_KEY_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsKeyIdentifier").getter(getter(CancelExportTaskResponse::kmsKeyIdentifier))
            .setter(setter(Builder::kmsKeyIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyIdentifier").build()).build();

    private static final SdkField<String> PARQUET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parquetType").getter(getter(CancelExportTaskResponse::parquetTypeAsString))
            .setter(setter(Builder::parquetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parquetType").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(CancelExportTaskResponse::statusReason))
            .setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_ID_FIELD,
            ROLE_ARN_FIELD, TASK_ID_FIELD, STATUS_FIELD, FORMAT_FIELD, DESTINATION_FIELD, KMS_KEY_IDENTIFIER_FIELD,
            PARQUET_TYPE_FIELD, STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphId;

    private final String roleArn;

    private final String taskId;

    private final String status;

    private final String format;

    private final String destination;

    private final String kmsKeyIdentifier;

    private final String parquetType;

    private final String statusReason;

    private CancelExportTaskResponse(BuilderImpl builder) {
        super(builder);
        this.graphId = builder.graphId;
        this.roleArn = builder.roleArn;
        this.taskId = builder.taskId;
        this.status = builder.status;
        this.format = builder.format;
        this.destination = builder.destination;
        this.kmsKeyIdentifier = builder.kmsKeyIdentifier;
        this.parquetType = builder.parquetType;
        this.statusReason = builder.statusReason;
    }

    /**
     * <p>
     * The source graph identifier of the cancelled export task.
     * </p>
     * 
     * @return The source graph identifier of the cancelled export task.
     */
    public final String graphId() {
        return graphId;
    }

    /**
     * <p>
     * The ARN of the IAM role that will allow the exporting of data to the destination.
     * </p>
     * 
     * @return The ARN of the IAM role that will allow the exporting of data to the destination.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The unique identifier of the export task.
     * </p>
     * 
     * @return The unique identifier of the export task.
     */
    public final String taskId() {
        return taskId;
    }

    /**
     * <p>
     * The current status of the export task. The status is <code>CANCELLING</code> when the export task is cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the export task. The status is <code>CANCELLING</code> when the export task is
     *         cancelled.
     * @see ExportTaskStatus
     */
    public final ExportTaskStatus status() {
        return ExportTaskStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the export task. The status is <code>CANCELLING</code> when the export task is cancelled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ExportTaskStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the export task. The status is <code>CANCELLING</code> when the export task is
     *         cancelled.
     * @see ExportTaskStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The format of the cancelled export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the cancelled export task.
     * @see ExportFormat
     */
    public final ExportFormat format() {
        return ExportFormat.fromValue(format);
    }

    /**
     * <p>
     * The format of the cancelled export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link ExportFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the cancelled export task.
     * @see ExportFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The Amazon S3 URI of the cancelled export task where data will be exported to.
     * </p>
     * 
     * @return The Amazon S3 URI of the cancelled export task where data will be exported to.
     */
    public final String destination() {
        return destination;
    }

    /**
     * <p>
     * The KMS key identifier of the cancelled export task.
     * </p>
     * 
     * @return The KMS key identifier of the cancelled export task.
     */
    public final String kmsKeyIdentifier() {
        return kmsKeyIdentifier;
    }

    /**
     * <p>
     * The parquet type of the cancelled export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the cancelled export task.
     * @see ParquetType
     */
    public final ParquetType parquetType() {
        return ParquetType.fromValue(parquetType);
    }

    /**
     * <p>
     * The parquet type of the cancelled export task.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parquetType} will
     * return {@link ParquetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parquetTypeAsString}.
     * </p>
     * 
     * @return The parquet type of the cancelled export task.
     * @see ParquetType
     */
    public final String parquetTypeAsString() {
        return parquetType;
    }

    /**
     * <p>
     * The reason that the export task has this status value.
     * </p>
     * 
     * @return The reason that the export task has this status value.
     */
    public final String statusReason() {
        return statusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(destination());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(parquetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelExportTaskResponse)) {
            return false;
        }
        CancelExportTaskResponse other = (CancelExportTaskResponse) obj;
        return Objects.equals(graphId(), other.graphId()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(taskId(), other.taskId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(destination(), other.destination())
                && Objects.equals(kmsKeyIdentifier(), other.kmsKeyIdentifier())
                && Objects.equals(parquetTypeAsString(), other.parquetTypeAsString())
                && Objects.equals(statusReason(), other.statusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CancelExportTaskResponse").add("GraphId", graphId()).add("RoleArn", roleArn())
                .add("TaskId", taskId()).add("Status", statusAsString()).add("Format", formatAsString())
                .add("Destination", destination()).add("KmsKeyIdentifier", kmsKeyIdentifier())
                .add("ParquetType", parquetTypeAsString()).add("StatusReason", statusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphId":
            return Optional.ofNullable(clazz.cast(graphId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "taskId":
            return Optional.ofNullable(clazz.cast(taskId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "destination":
            return Optional.ofNullable(clazz.cast(destination()));
        case "kmsKeyIdentifier":
            return Optional.ofNullable(clazz.cast(kmsKeyIdentifier()));
        case "parquetType":
            return Optional.ofNullable(clazz.cast(parquetTypeAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphId", GRAPH_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("taskId", TASK_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("destination", DESTINATION_FIELD);
        map.put("kmsKeyIdentifier", KMS_KEY_IDENTIFIER_FIELD);
        map.put("parquetType", PARQUET_TYPE_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelExportTaskResponse, T> g) {
        return obj -> g.apply((CancelExportTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, CancelExportTaskResponse> {
        /**
         * <p>
         * The source graph identifier of the cancelled export task.
         * </p>
         * 
         * @param graphId
         *        The source graph identifier of the cancelled export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphId(String graphId);

        /**
         * <p>
         * The ARN of the IAM role that will allow the exporting of data to the destination.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that will allow the exporting of data to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The unique identifier of the export task.
         * </p>
         * 
         * @param taskId
         *        The unique identifier of the export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskId(String taskId);

        /**
         * <p>
         * The current status of the export task. The status is <code>CANCELLING</code> when the export task is
         * cancelled.
         * </p>
         * 
         * @param status
         *        The current status of the export task. The status is <code>CANCELLING</code> when the export task is
         *        cancelled.
         * @see ExportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the export task. The status is <code>CANCELLING</code> when the export task is
         * cancelled.
         * </p>
         * 
         * @param status
         *        The current status of the export task. The status is <code>CANCELLING</code> when the export task is
         *        cancelled.
         * @see ExportTaskStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportTaskStatus
         */
        Builder status(ExportTaskStatus status);

        /**
         * <p>
         * The format of the cancelled export task.
         * </p>
         * 
         * @param format
         *        The format of the cancelled export task.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the cancelled export task.
         * </p>
         * 
         * @param format
         *        The format of the cancelled export task.
         * @see ExportFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportFormat
         */
        Builder format(ExportFormat format);

        /**
         * <p>
         * The Amazon S3 URI of the cancelled export task where data will be exported to.
         * </p>
         * 
         * @param destination
         *        The Amazon S3 URI of the cancelled export task where data will be exported to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destination(String destination);

        /**
         * <p>
         * The KMS key identifier of the cancelled export task.
         * </p>
         * 
         * @param kmsKeyIdentifier
         *        The KMS key identifier of the cancelled export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyIdentifier(String kmsKeyIdentifier);

        /**
         * <p>
         * The parquet type of the cancelled export task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the cancelled export task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(String parquetType);

        /**
         * <p>
         * The parquet type of the cancelled export task.
         * </p>
         * 
         * @param parquetType
         *        The parquet type of the cancelled export task.
         * @see ParquetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParquetType
         */
        Builder parquetType(ParquetType parquetType);

        /**
         * <p>
         * The reason that the export task has this status value.
         * </p>
         * 
         * @param statusReason
         *        The reason that the export task has this status value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private String graphId;

        private String roleArn;

        private String taskId;

        private String status;

        private String format;

        private String destination;

        private String kmsKeyIdentifier;

        private String parquetType;

        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelExportTaskResponse model) {
            super(model);
            graphId(model.graphId);
            roleArn(model.roleArn);
            taskId(model.taskId);
            status(model.status);
            format(model.format);
            destination(model.destination);
            kmsKeyIdentifier(model.kmsKeyIdentifier);
            parquetType(model.parquetType);
            statusReason(model.statusReason);
        }

        public final String getGraphId() {
            return graphId;
        }

        public final void setGraphId(String graphId) {
            this.graphId = graphId;
        }

        @Override
        public final Builder graphId(String graphId) {
            this.graphId = graphId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getTaskId() {
            return taskId;
        }

        public final void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        @Override
        public final Builder taskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ExportTaskStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(ExportFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final String getDestination() {
            return destination;
        }

        public final void setDestination(String destination) {
            this.destination = destination;
        }

        @Override
        public final Builder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public final String getKmsKeyIdentifier() {
            return kmsKeyIdentifier;
        }

        public final void setKmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
        }

        @Override
        public final Builder kmsKeyIdentifier(String kmsKeyIdentifier) {
            this.kmsKeyIdentifier = kmsKeyIdentifier;
            return this;
        }

        public final String getParquetType() {
            return parquetType;
        }

        public final void setParquetType(String parquetType) {
            this.parquetType = parquetType;
        }

        @Override
        public final Builder parquetType(String parquetType) {
            this.parquetType = parquetType;
            return this;
        }

        @Override
        public final Builder parquetType(ParquetType parquetType) {
            this.parquetType(parquetType == null ? null : parquetType.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        @Override
        public CancelExportTaskResponse build() {
            return new CancelExportTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
