/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteGraphRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<DeleteGraphRequest.Builder, DeleteGraphRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(DeleteGraphRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("graphIdentifier").build()).build();

    private static final SdkField<Boolean> SKIP_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("skipSnapshot").getter(getter(DeleteGraphRequest::skipSnapshot)).setter(setter(Builder::skipSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("skipSnapshot").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD,
            SKIP_SNAPSHOT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphIdentifier;

    private final Boolean skipSnapshot;

    private DeleteGraphRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.skipSnapshot = builder.skipSnapshot;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * Determines whether a final graph snapshot is created before the graph is deleted. If <code>true</code> is
     * specified, no graph snapshot is created. If <code>false</code> is specified, a graph snapshot is created before
     * the graph is deleted.
     * </p>
     * 
     * @return Determines whether a final graph snapshot is created before the graph is deleted. If <code>true</code> is
     *         specified, no graph snapshot is created. If <code>false</code> is specified, a graph snapshot is created
     *         before the graph is deleted.
     */
    public final Boolean skipSnapshot() {
        return skipSnapshot;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(skipSnapshot());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteGraphRequest)) {
            return false;
        }
        DeleteGraphRequest other = (DeleteGraphRequest) obj;
        return Objects.equals(graphIdentifier(), other.graphIdentifier()) && Objects.equals(skipSnapshot(), other.skipSnapshot());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteGraphRequest").add("GraphIdentifier", graphIdentifier())
                .add("SkipSnapshot", skipSnapshot()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "skipSnapshot":
            return Optional.ofNullable(clazz.cast(skipSnapshot()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("skipSnapshot", SKIP_SNAPSHOT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteGraphRequest, T> g) {
        return obj -> g.apply((DeleteGraphRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteGraphRequest> {
        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphIdentifier
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * Determines whether a final graph snapshot is created before the graph is deleted. If <code>true</code> is
         * specified, no graph snapshot is created. If <code>false</code> is specified, a graph snapshot is created
         * before the graph is deleted.
         * </p>
         * 
         * @param skipSnapshot
         *        Determines whether a final graph snapshot is created before the graph is deleted. If <code>true</code>
         *        is specified, no graph snapshot is created. If <code>false</code> is specified, a graph snapshot is
         *        created before the graph is deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder skipSnapshot(Boolean skipSnapshot);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphIdentifier;

        private Boolean skipSnapshot;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteGraphRequest model) {
            super(model);
            graphIdentifier(model.graphIdentifier);
            skipSnapshot(model.skipSnapshot);
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final Boolean getSkipSnapshot() {
            return skipSnapshot;
        }

        public final void setSkipSnapshot(Boolean skipSnapshot) {
            this.skipSnapshot = skipSnapshot;
        }

        @Override
        public final Builder skipSnapshot(Boolean skipSnapshot) {
            this.skipSnapshot = skipSnapshot;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteGraphRequest build() {
            return new DeleteGraphRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
