/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is the top-level field for specifying vertex or edge filters. If the ExportFilter is not provided, then all
 * properties for all labels will be exported. If the ExportFilter is provided but is an empty object, then no data will
 * be exported.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExportFilter implements SdkPojo, Serializable, ToCopyableBuilder<ExportFilter.Builder, ExportFilter> {
    private static final SdkField<Map<String, ExportFilterElement>> VERTEX_FILTER_FIELD = SdkField
            .<Map<String, ExportFilterElement>> builder(MarshallingType.MAP)
            .memberName("vertexFilter")
            .getter(getter(ExportFilter::vertexFilter))
            .setter(setter(Builder::vertexFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vertexFilter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExportFilterElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportFilterElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, ExportFilterElement>> EDGE_FILTER_FIELD = SdkField
            .<Map<String, ExportFilterElement>> builder(MarshallingType.MAP)
            .memberName("edgeFilter")
            .getter(getter(ExportFilter::edgeFilter))
            .setter(setter(Builder::edgeFilter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("edgeFilter").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ExportFilterElement> builder(MarshallingType.SDK_POJO)
                                            .constructor(ExportFilterElement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERTEX_FILTER_FIELD,
            EDGE_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, ExportFilterElement> vertexFilter;

    private final Map<String, ExportFilterElement> edgeFilter;

    private ExportFilter(BuilderImpl builder) {
        this.vertexFilter = builder.vertexFilter;
        this.edgeFilter = builder.edgeFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the VertexFilter property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVertexFilter() {
        return vertexFilter != null && !(vertexFilter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Used to specify filters on a per-label basis for vertices. This allows you to control which vertex labels and
     * properties are included in the export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVertexFilter} method.
     * </p>
     * 
     * @return Used to specify filters on a per-label basis for vertices. This allows you to control which vertex labels
     *         and properties are included in the export.
     */
    public final Map<String, ExportFilterElement> vertexFilter() {
        return vertexFilter;
    }

    /**
     * For responses, this returns true if the service returned a value for the EdgeFilter property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasEdgeFilter() {
        return edgeFilter != null && !(edgeFilter instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Used to specify filters on a per-label basis for edges. This allows you to control which edge labels and
     * properties are included in the export.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEdgeFilter} method.
     * </p>
     * 
     * @return Used to specify filters on a per-label basis for edges. This allows you to control which edge labels and
     *         properties are included in the export.
     */
    public final Map<String, ExportFilterElement> edgeFilter() {
        return edgeFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasVertexFilter() ? vertexFilter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEdgeFilter() ? edgeFilter() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportFilter)) {
            return false;
        }
        ExportFilter other = (ExportFilter) obj;
        return hasVertexFilter() == other.hasVertexFilter() && Objects.equals(vertexFilter(), other.vertexFilter())
                && hasEdgeFilter() == other.hasEdgeFilter() && Objects.equals(edgeFilter(), other.edgeFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExportFilter").add("VertexFilter", hasVertexFilter() ? vertexFilter() : null)
                .add("EdgeFilter", hasEdgeFilter() ? edgeFilter() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vertexFilter":
            return Optional.ofNullable(clazz.cast(vertexFilter()));
        case "edgeFilter":
            return Optional.ofNullable(clazz.cast(edgeFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vertexFilter", VERTEX_FILTER_FIELD);
        map.put("edgeFilter", EDGE_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportFilter, T> g) {
        return obj -> g.apply((ExportFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExportFilter> {
        /**
         * <p>
         * Used to specify filters on a per-label basis for vertices. This allows you to control which vertex labels and
         * properties are included in the export.
         * </p>
         * 
         * @param vertexFilter
         *        Used to specify filters on a per-label basis for vertices. This allows you to control which vertex
         *        labels and properties are included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vertexFilter(Map<String, ExportFilterElement> vertexFilter);

        /**
         * <p>
         * Used to specify filters on a per-label basis for edges. This allows you to control which edge labels and
         * properties are included in the export.
         * </p>
         * 
         * @param edgeFilter
         *        Used to specify filters on a per-label basis for edges. This allows you to control which edge labels
         *        and properties are included in the export.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeFilter(Map<String, ExportFilterElement> edgeFilter);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, ExportFilterElement> vertexFilter = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, ExportFilterElement> edgeFilter = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExportFilter model) {
            vertexFilter(model.vertexFilter);
            edgeFilter(model.edgeFilter);
        }

        public final Map<String, ExportFilterElement.Builder> getVertexFilter() {
            Map<String, ExportFilterElement.Builder> result = ExportFilterPerLabelMapCopier.copyToBuilder(this.vertexFilter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setVertexFilter(Map<String, ExportFilterElement.BuilderImpl> vertexFilter) {
            this.vertexFilter = ExportFilterPerLabelMapCopier.copyFromBuilder(vertexFilter);
        }

        @Override
        public final Builder vertexFilter(Map<String, ExportFilterElement> vertexFilter) {
            this.vertexFilter = ExportFilterPerLabelMapCopier.copy(vertexFilter);
            return this;
        }

        public final Map<String, ExportFilterElement.Builder> getEdgeFilter() {
            Map<String, ExportFilterElement.Builder> result = ExportFilterPerLabelMapCopier.copyToBuilder(this.edgeFilter);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setEdgeFilter(Map<String, ExportFilterElement.BuilderImpl> edgeFilter) {
            this.edgeFilter = ExportFilterPerLabelMapCopier.copyFromBuilder(edgeFilter);
        }

        @Override
        public final Builder edgeFilter(Map<String, ExportFilterElement> edgeFilter) {
            this.edgeFilter = ExportFilterPerLabelMapCopier.copy(edgeFilter);
            return this;
        }

        @Override
        public ExportFilter build() {
            return new ExportFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
