/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListGraphsResponse extends NeptuneGraphResponse implements
        ToCopyableBuilder<ListGraphsResponse.Builder, ListGraphsResponse> {
    private static final SdkField<List<GraphSummary>> GRAPHS_FIELD = SdkField
            .<List<GraphSummary>> builder(MarshallingType.LIST)
            .memberName("graphs")
            .getter(getter(ListGraphsResponse::graphs))
            .setter(setter(Builder::graphs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GraphSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GraphSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListGraphsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(GRAPHS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<GraphSummary> graphs;

    private final String nextToken;

    private ListGraphsResponse(BuilderImpl builder) {
        super(builder);
        this.graphs = builder.graphs;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Graphs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGraphs() {
        return graphs != null && !(graphs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the graphs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGraphs} method.
     * </p>
     * 
     * @return A list of the graphs.
     */
    public final List<GraphSummary> graphs() {
        return graphs;
    }

    /**
     * <p>
     * Pagination token used to paginate output.
     * </p>
     * <p>
     * When this value is provided as input, the service returns results from where the previous response left off. When
     * this value is present in output, it indicates that there are more results to retrieve.
     * </p>
     * 
     * @return Pagination token used to paginate output.</p>
     *         <p>
     *         When this value is provided as input, the service returns results from where the previous response left
     *         off. When this value is present in output, it indicates that there are more results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasGraphs() ? graphs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGraphsResponse)) {
            return false;
        }
        ListGraphsResponse other = (ListGraphsResponse) obj;
        return hasGraphs() == other.hasGraphs() && Objects.equals(graphs(), other.graphs())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListGraphsResponse").add("Graphs", hasGraphs() ? graphs() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphs":
            return Optional.ofNullable(clazz.cast(graphs()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphs", GRAPHS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGraphsResponse, T> g) {
        return obj -> g.apply((ListGraphsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListGraphsResponse> {
        /**
         * <p>
         * A list of the graphs.
         * </p>
         * 
         * @param graphs
         *        A list of the graphs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphs(Collection<GraphSummary> graphs);

        /**
         * <p>
         * A list of the graphs.
         * </p>
         * 
         * @param graphs
         *        A list of the graphs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphs(GraphSummary... graphs);

        /**
         * <p>
         * A list of the graphs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.neptunegraph.model.GraphSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.neptunegraph.model.GraphSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.neptunegraph.model.GraphSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #graphs(List<GraphSummary>)}.
         * 
         * @param graphs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.neptunegraph.model.GraphSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #graphs(java.util.Collection<GraphSummary>)
         */
        Builder graphs(Consumer<GraphSummary.Builder>... graphs);

        /**
         * <p>
         * Pagination token used to paginate output.
         * </p>
         * <p>
         * When this value is provided as input, the service returns results from where the previous response left off.
         * When this value is present in output, it indicates that there are more results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        Pagination token used to paginate output.</p>
         *        <p>
         *        When this value is provided as input, the service returns results from where the previous response
         *        left off. When this value is present in output, it indicates that there are more results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends NeptuneGraphResponse.BuilderImpl implements Builder {
        private List<GraphSummary> graphs = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGraphsResponse model) {
            super(model);
            graphs(model.graphs);
            nextToken(model.nextToken);
        }

        public final List<GraphSummary.Builder> getGraphs() {
            List<GraphSummary.Builder> result = GraphSummaryListCopier.copyToBuilder(this.graphs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGraphs(Collection<GraphSummary.BuilderImpl> graphs) {
            this.graphs = GraphSummaryListCopier.copyFromBuilder(graphs);
        }

        @Override
        public final Builder graphs(Collection<GraphSummary> graphs) {
            this.graphs = GraphSummaryListCopier.copy(graphs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphs(GraphSummary... graphs) {
            graphs(Arrays.asList(graphs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder graphs(Consumer<GraphSummary.Builder>... graphs) {
            graphs(Stream.of(graphs).map(c -> GraphSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListGraphsResponse build() {
            return new ListGraphsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
