/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for how to import Neptune data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NeptuneImportOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<NeptuneImportOptions.Builder, NeptuneImportOptions> {
    private static final SdkField<String> S3_EXPORT_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ExportPath").getter(getter(NeptuneImportOptions::s3ExportPath)).setter(setter(Builder::s3ExportPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportPath").build()).build();

    private static final SdkField<String> S3_EXPORT_KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3ExportKmsKeyId").getter(getter(NeptuneImportOptions::s3ExportKmsKeyId))
            .setter(setter(Builder::s3ExportKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportKmsKeyId").build()).build();

    private static final SdkField<Boolean> PRESERVE_DEFAULT_VERTEX_LABELS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preserveDefaultVertexLabels")
            .getter(getter(NeptuneImportOptions::preserveDefaultVertexLabels))
            .setter(setter(Builder::preserveDefaultVertexLabels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveDefaultVertexLabels")
                    .build()).build();

    private static final SdkField<Boolean> PRESERVE_EDGE_IDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("preserveEdgeIds").getter(getter(NeptuneImportOptions::preserveEdgeIds))
            .setter(setter(Builder::preserveEdgeIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("preserveEdgeIds").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_EXPORT_PATH_FIELD,
            S3_EXPORT_KMS_KEY_ID_FIELD, PRESERVE_DEFAULT_VERTEX_LABELS_FIELD, PRESERVE_EDGE_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String s3ExportPath;

    private final String s3ExportKmsKeyId;

    private final Boolean preserveDefaultVertexLabels;

    private final Boolean preserveEdgeIds;

    private NeptuneImportOptions(BuilderImpl builder) {
        this.s3ExportPath = builder.s3ExportPath;
        this.s3ExportKmsKeyId = builder.s3ExportKmsKeyId;
        this.preserveDefaultVertexLabels = builder.preserveDefaultVertexLabels;
        this.preserveEdgeIds = builder.preserveEdgeIds;
    }

    /**
     * <p>
     * The path to an S3 bucket from which to import data.
     * </p>
     * 
     * @return The path to an S3 bucket from which to import data.
     */
    public final String s3ExportPath() {
        return s3ExportPath;
    }

    /**
     * <p>
     * The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
     * </p>
     * 
     * @return The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
     */
    public final String s3ExportKmsKeyId() {
        return s3ExportKmsKeyId;
    }

    /**
     * <p>
     * Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly provided.
     * Neptune assigns default labels when none is explicitly provided. When importing the data into Neptune Analytics,
     * the default vertex labels can be omitted by setting <i>preserveDefaultVertexLabels</i> to false. Note that if the
     * vertex only has default labels, and has no other properties or edges, then the vertex will effectively not get
     * imported into Neptune Analytics when preserveDefaultVertexLabels is set to false.
     * </p>
     * 
     * @return Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly
     *         provided. Neptune assigns default labels when none is explicitly provided. When importing the data into
     *         Neptune Analytics, the default vertex labels can be omitted by setting <i>preserveDefaultVertexLabels</i>
     *         to false. Note that if the vertex only has default labels, and has no other properties or edges, then the
     *         vertex will effectively not get imported into Neptune Analytics when preserveDefaultVertexLabels is set
     *         to false.
     */
    public final Boolean preserveDefaultVertexLabels() {
        return preserveDefaultVertexLabels;
    }

    /**
     * <p>
     * Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by default.
     * They are imported if <i>preserveEdgeIds</i> is set to true, and ids are stored as properties on the relationships
     * with the property name <i>neptuneEdgeId</i>.
     * </p>
     * 
     * @return Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by
     *         default. They are imported if <i>preserveEdgeIds</i> is set to true, and ids are stored as properties on
     *         the relationships with the property name <i>neptuneEdgeId</i>.
     */
    public final Boolean preserveEdgeIds() {
        return preserveEdgeIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportPath());
        hashCode = 31 * hashCode + Objects.hashCode(s3ExportKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preserveDefaultVertexLabels());
        hashCode = 31 * hashCode + Objects.hashCode(preserveEdgeIds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NeptuneImportOptions)) {
            return false;
        }
        NeptuneImportOptions other = (NeptuneImportOptions) obj;
        return Objects.equals(s3ExportPath(), other.s3ExportPath())
                && Objects.equals(s3ExportKmsKeyId(), other.s3ExportKmsKeyId())
                && Objects.equals(preserveDefaultVertexLabels(), other.preserveDefaultVertexLabels())
                && Objects.equals(preserveEdgeIds(), other.preserveEdgeIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NeptuneImportOptions").add("S3ExportPath", s3ExportPath())
                .add("S3ExportKmsKeyId", s3ExportKmsKeyId()).add("PreserveDefaultVertexLabels", preserveDefaultVertexLabels())
                .add("PreserveEdgeIds", preserveEdgeIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3ExportPath":
            return Optional.ofNullable(clazz.cast(s3ExportPath()));
        case "s3ExportKmsKeyId":
            return Optional.ofNullable(clazz.cast(s3ExportKmsKeyId()));
        case "preserveDefaultVertexLabels":
            return Optional.ofNullable(clazz.cast(preserveDefaultVertexLabels()));
        case "preserveEdgeIds":
            return Optional.ofNullable(clazz.cast(preserveEdgeIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3ExportPath", S3_EXPORT_PATH_FIELD);
        map.put("s3ExportKmsKeyId", S3_EXPORT_KMS_KEY_ID_FIELD);
        map.put("preserveDefaultVertexLabels", PRESERVE_DEFAULT_VERTEX_LABELS_FIELD);
        map.put("preserveEdgeIds", PRESERVE_EDGE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NeptuneImportOptions, T> g) {
        return obj -> g.apply((NeptuneImportOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NeptuneImportOptions> {
        /**
         * <p>
         * The path to an S3 bucket from which to import data.
         * </p>
         * 
         * @param s3ExportPath
         *        The path to an S3 bucket from which to import data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportPath(String s3ExportPath);

        /**
         * <p>
         * The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
         * </p>
         * 
         * @param s3ExportKmsKeyId
         *        The KMS key to use to encrypt data in the S3 bucket where the graph data is exported
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3ExportKmsKeyId(String s3ExportKmsKeyId);

        /**
         * <p>
         * Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly provided.
         * Neptune assigns default labels when none is explicitly provided. When importing the data into Neptune
         * Analytics, the default vertex labels can be omitted by setting <i>preserveDefaultVertexLabels</i> to false.
         * Note that if the vertex only has default labels, and has no other properties or edges, then the vertex will
         * effectively not get imported into Neptune Analytics when preserveDefaultVertexLabels is set to false.
         * </p>
         * 
         * @param preserveDefaultVertexLabels
         *        Neptune Analytics supports label-less vertices and no labels are assigned unless one is explicitly
         *        provided. Neptune assigns default labels when none is explicitly provided. When importing the data
         *        into Neptune Analytics, the default vertex labels can be omitted by setting
         *        <i>preserveDefaultVertexLabels</i> to false. Note that if the vertex only has default labels, and has
         *        no other properties or edges, then the vertex will effectively not get imported into Neptune Analytics
         *        when preserveDefaultVertexLabels is set to false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveDefaultVertexLabels(Boolean preserveDefaultVertexLabels);

        /**
         * <p>
         * Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by default.
         * They are imported if <i>preserveEdgeIds</i> is set to true, and ids are stored as properties on the
         * relationships with the property name <i>neptuneEdgeId</i>.
         * </p>
         * 
         * @param preserveEdgeIds
         *        Neptune Analytics currently does not support user defined edge ids. The edge ids are not imported by
         *        default. They are imported if <i>preserveEdgeIds</i> is set to true, and ids are stored as properties
         *        on the relationships with the property name <i>neptuneEdgeId</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preserveEdgeIds(Boolean preserveEdgeIds);
    }

    static final class BuilderImpl implements Builder {
        private String s3ExportPath;

        private String s3ExportKmsKeyId;

        private Boolean preserveDefaultVertexLabels;

        private Boolean preserveEdgeIds;

        private BuilderImpl() {
        }

        private BuilderImpl(NeptuneImportOptions model) {
            s3ExportPath(model.s3ExportPath);
            s3ExportKmsKeyId(model.s3ExportKmsKeyId);
            preserveDefaultVertexLabels(model.preserveDefaultVertexLabels);
            preserveEdgeIds(model.preserveEdgeIds);
        }

        public final String getS3ExportPath() {
            return s3ExportPath;
        }

        public final void setS3ExportPath(String s3ExportPath) {
            this.s3ExportPath = s3ExportPath;
        }

        @Override
        public final Builder s3ExportPath(String s3ExportPath) {
            this.s3ExportPath = s3ExportPath;
            return this;
        }

        public final String getS3ExportKmsKeyId() {
            return s3ExportKmsKeyId;
        }

        public final void setS3ExportKmsKeyId(String s3ExportKmsKeyId) {
            this.s3ExportKmsKeyId = s3ExportKmsKeyId;
        }

        @Override
        public final Builder s3ExportKmsKeyId(String s3ExportKmsKeyId) {
            this.s3ExportKmsKeyId = s3ExportKmsKeyId;
            return this;
        }

        public final Boolean getPreserveDefaultVertexLabels() {
            return preserveDefaultVertexLabels;
        }

        public final void setPreserveDefaultVertexLabels(Boolean preserveDefaultVertexLabels) {
            this.preserveDefaultVertexLabels = preserveDefaultVertexLabels;
        }

        @Override
        public final Builder preserveDefaultVertexLabels(Boolean preserveDefaultVertexLabels) {
            this.preserveDefaultVertexLabels = preserveDefaultVertexLabels;
            return this;
        }

        public final Boolean getPreserveEdgeIds() {
            return preserveEdgeIds;
        }

        public final void setPreserveEdgeIds(Boolean preserveEdgeIds) {
            this.preserveEdgeIds = preserveEdgeIds;
        }

        @Override
        public final Builder preserveEdgeIds(Boolean preserveEdgeIds) {
            this.preserveEdgeIds = preserveEdgeIds;
            return this;
        }

        @Override
        public NeptuneImportOptions build() {
            return new NeptuneImportOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
