/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of the query listed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySummary implements SdkPojo, Serializable, ToCopyableBuilder<QuerySummary.Builder, QuerySummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(QuerySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> QUERY_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryString").getter(getter(QuerySummary::queryString)).setter(setter(Builder::queryString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryString").build()).build();

    private static final SdkField<Integer> WAITED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("waited").getter(getter(QuerySummary::waited)).setter(setter(Builder::waited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waited").build()).build();

    private static final SdkField<Integer> ELAPSED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("elapsed").getter(getter(QuerySummary::elapsed)).setter(setter(Builder::elapsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("elapsed").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("state")
            .getter(getter(QuerySummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, QUERY_STRING_FIELD,
            WAITED_FIELD, ELAPSED_FIELD, STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String queryString;

    private final Integer waited;

    private final Integer elapsed;

    private final String state;

    private QuerySummary(BuilderImpl builder) {
        this.id = builder.id;
        this.queryString = builder.queryString;
        this.waited = builder.waited;
        this.elapsed = builder.elapsed;
        this.state = builder.state;
    }

    /**
     * <p>
     * A string representation of the id of the query.
     * </p>
     * 
     * @return A string representation of the id of the query.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The actual query text. The <code>queryString</code> may be truncated if the actual query string is too long.
     * </p>
     * 
     * @return The actual query text. The <code>queryString</code> may be truncated if the actual query string is too
     *         long.
     */
    public final String queryString() {
        return queryString;
    }

    /**
     * <p>
     * The amount of time, in milliseconds, the query has waited in the queue before being picked up by a worker thread.
     * </p>
     * 
     * @return The amount of time, in milliseconds, the query has waited in the queue before being picked up by a worker
     *         thread.
     */
    public final Integer waited() {
        return waited;
    }

    /**
     * <p>
     * The running time of the query, in milliseconds.
     * </p>
     * 
     * @return The running time of the query, in milliseconds.
     */
    public final Integer elapsed() {
        return elapsed;
    }

    /**
     * <p>
     * State of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the query.
     * @see QueryState
     */
    public final QueryState state() {
        return QueryState.fromValue(state);
    }

    /**
     * <p>
     * State of the query.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link QueryState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return State of the query.
     * @see QueryState
     */
    public final String stateAsString() {
        return state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(queryString());
        hashCode = 31 * hashCode + Objects.hashCode(waited());
        hashCode = 31 * hashCode + Objects.hashCode(elapsed());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySummary)) {
            return false;
        }
        QuerySummary other = (QuerySummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(queryString(), other.queryString())
                && Objects.equals(waited(), other.waited()) && Objects.equals(elapsed(), other.elapsed())
                && Objects.equals(stateAsString(), other.stateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuerySummary").add("Id", id()).add("QueryString", queryString()).add("Waited", waited())
                .add("Elapsed", elapsed()).add("State", stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "queryString":
            return Optional.ofNullable(clazz.cast(queryString()));
        case "waited":
            return Optional.ofNullable(clazz.cast(waited()));
        case "elapsed":
            return Optional.ofNullable(clazz.cast(elapsed()));
        case "state":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("queryString", QUERY_STRING_FIELD);
        map.put("waited", WAITED_FIELD);
        map.put("elapsed", ELAPSED_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuerySummary, T> g) {
        return obj -> g.apply((QuerySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QuerySummary> {
        /**
         * <p>
         * A string representation of the id of the query.
         * </p>
         * 
         * @param id
         *        A string representation of the id of the query.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The actual query text. The <code>queryString</code> may be truncated if the actual query string is too long.
         * </p>
         * 
         * @param queryString
         *        The actual query text. The <code>queryString</code> may be truncated if the actual query string is too
         *        long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryString(String queryString);

        /**
         * <p>
         * The amount of time, in milliseconds, the query has waited in the queue before being picked up by a worker
         * thread.
         * </p>
         * 
         * @param waited
         *        The amount of time, in milliseconds, the query has waited in the queue before being picked up by a
         *        worker thread.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waited(Integer waited);

        /**
         * <p>
         * The running time of the query, in milliseconds.
         * </p>
         * 
         * @param elapsed
         *        The running time of the query, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsed(Integer elapsed);

        /**
         * <p>
         * State of the query.
         * </p>
         * 
         * @param state
         *        State of the query.
         * @see QueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryState
         */
        Builder state(String state);

        /**
         * <p>
         * State of the query.
         * </p>
         * 
         * @param state
         *        State of the query.
         * @see QueryState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryState
         */
        Builder state(QueryState state);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String queryString;

        private Integer waited;

        private Integer elapsed;

        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySummary model) {
            id(model.id);
            queryString(model.queryString);
            waited(model.waited);
            elapsed(model.elapsed);
            state(model.state);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getQueryString() {
            return queryString;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final Integer getWaited() {
            return waited;
        }

        public final void setWaited(Integer waited) {
            this.waited = waited;
        }

        @Override
        public final Builder waited(Integer waited) {
            this.waited = waited;
            return this;
        }

        public final Integer getElapsed() {
            return elapsed;
        }

        public final void setElapsed(Integer elapsed) {
            this.elapsed = elapsed;
        }

        @Override
        public final Builder elapsed(Integer elapsed) {
            this.elapsed = elapsed;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(QueryState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public QuerySummary build() {
            return new QuerySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
