/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptunegraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGraphRequest extends NeptuneGraphRequest implements
        ToCopyableBuilder<UpdateGraphRequest.Builder, UpdateGraphRequest> {
    private static final SdkField<String> GRAPH_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("graphIdentifier").getter(getter(UpdateGraphRequest::graphIdentifier))
            .setter(setter(Builder::graphIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("graphIdentifier").build()).build();

    private static final SdkField<Boolean> PUBLIC_CONNECTIVITY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("publicConnectivity").getter(getter(UpdateGraphRequest::publicConnectivity))
            .setter(setter(Builder::publicConnectivity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publicConnectivity").build())
            .build();

    private static final SdkField<Integer> PROVISIONED_MEMORY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("provisionedMemory").getter(getter(UpdateGraphRequest::provisionedMemory))
            .setter(setter(Builder::provisionedMemory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedMemory").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("deletionProtection").getter(getter(UpdateGraphRequest::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletionProtection").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPH_IDENTIFIER_FIELD,
            PUBLIC_CONNECTIVITY_FIELD, PROVISIONED_MEMORY_FIELD, DELETION_PROTECTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String graphIdentifier;

    private final Boolean publicConnectivity;

    private final Integer provisionedMemory;

    private final Boolean deletionProtection;

    private UpdateGraphRequest(BuilderImpl builder) {
        super(builder);
        this.graphIdentifier = builder.graphIdentifier;
        this.publicConnectivity = builder.publicConnectivity;
        this.provisionedMemory = builder.provisionedMemory;
        this.deletionProtection = builder.deletionProtection;
    }

    /**
     * <p>
     * The unique identifier of the Neptune Analytics graph.
     * </p>
     * 
     * @return The unique identifier of the Neptune Analytics graph.
     */
    public final String graphIdentifier() {
        return graphIdentifier;
    }

    /**
     * <p>
     * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM authenticated.
     * (<code>true</code> to enable, or <code>false</code> to disable.
     * </p>
     * 
     * @return Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
     *         authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
     */
    public final Boolean publicConnectivity() {
        return publicConnectivity;
    }

    /**
     * <p>
     * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
     * </p>
     * <p>
     * Min = 16
     * </p>
     * 
     * @return The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
     *         <p>
     *         Min = 16
     */
    public final Integer provisionedMemory() {
        return provisionedMemory;
    }

    /**
     * <p>
     * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     * deletion protection is enabled.
     * </p>
     * 
     * @return A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
     *         deletion protection is enabled.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(publicConnectivity());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedMemory());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGraphRequest)) {
            return false;
        }
        UpdateGraphRequest other = (UpdateGraphRequest) obj;
        return Objects.equals(graphIdentifier(), other.graphIdentifier())
                && Objects.equals(publicConnectivity(), other.publicConnectivity())
                && Objects.equals(provisionedMemory(), other.provisionedMemory())
                && Objects.equals(deletionProtection(), other.deletionProtection());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGraphRequest").add("GraphIdentifier", graphIdentifier())
                .add("PublicConnectivity", publicConnectivity()).add("ProvisionedMemory", provisionedMemory())
                .add("DeletionProtection", deletionProtection()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphIdentifier":
            return Optional.ofNullable(clazz.cast(graphIdentifier()));
        case "publicConnectivity":
            return Optional.ofNullable(clazz.cast(publicConnectivity()));
        case "provisionedMemory":
            return Optional.ofNullable(clazz.cast(provisionedMemory()));
        case "deletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("graphIdentifier", GRAPH_IDENTIFIER_FIELD);
        map.put("publicConnectivity", PUBLIC_CONNECTIVITY_FIELD);
        map.put("provisionedMemory", PROVISIONED_MEMORY_FIELD);
        map.put("deletionProtection", DELETION_PROTECTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateGraphRequest, T> g) {
        return obj -> g.apply((UpdateGraphRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends NeptuneGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGraphRequest> {
        /**
         * <p>
         * The unique identifier of the Neptune Analytics graph.
         * </p>
         * 
         * @param graphIdentifier
         *        The unique identifier of the Neptune Analytics graph.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphIdentifier(String graphIdentifier);

        /**
         * <p>
         * Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         * authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
         * </p>
         * 
         * @param publicConnectivity
         *        Specifies whether or not the graph can be reachable over the internet. All access to graphs is IAM
         *        authenticated. (<code>true</code> to enable, or <code>false</code> to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicConnectivity(Boolean publicConnectivity);

        /**
         * <p>
         * The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.
         * </p>
         * <p>
         * Min = 16
         * </p>
         * 
         * @param provisionedMemory
         *        The provisioned memory-optimized Neptune Capacity Units (m-NCUs) to use for the graph.</p>
         *        <p>
         *        Min = 16
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedMemory(Integer provisionedMemory);

        /**
         * <p>
         * A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted when
         * deletion protection is enabled.
         * </p>
         * 
         * @param deletionProtection
         *        A value that indicates whether the graph has deletion protection enabled. The graph can't be deleted
         *        when deletion protection is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends NeptuneGraphRequest.BuilderImpl implements Builder {
        private String graphIdentifier;

        private Boolean publicConnectivity;

        private Integer provisionedMemory;

        private Boolean deletionProtection;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGraphRequest model) {
            super(model);
            graphIdentifier(model.graphIdentifier);
            publicConnectivity(model.publicConnectivity);
            provisionedMemory(model.provisionedMemory);
            deletionProtection(model.deletionProtection);
        }

        public final String getGraphIdentifier() {
            return graphIdentifier;
        }

        public final void setGraphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
        }

        @Override
        public final Builder graphIdentifier(String graphIdentifier) {
            this.graphIdentifier = graphIdentifier;
            return this;
        }

        public final Boolean getPublicConnectivity() {
            return publicConnectivity;
        }

        public final void setPublicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
        }

        @Override
        public final Builder publicConnectivity(Boolean publicConnectivity) {
            this.publicConnectivity = publicConnectivity;
            return this;
        }

        public final Integer getProvisionedMemory() {
            return provisionedMemory;
        }

        public final void setProvisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
        }

        @Override
        public final Builder provisionedMemory(Integer provisionedMemory) {
            this.provisionedMemory = provisionedMemory;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateGraphRequest build() {
            return new UpdateGraphRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
