/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.pool.ChannelHealthChecker;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkRequestContext;
import software.amazon.awssdk.http.async.AbortableRunnable;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkHttpRequestProvider;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.http.nio.netty.EventLoopGroupFactory;
import software.amazon.awssdk.http.nio.netty.NettySdkHttpClientFactory;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.NonManagedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.RequestAdapter;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.RunnableRequest;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.SharedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.utils.SocketChannelResolver;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.FunctionalUtils;

@SdkInternalApi
final class NettyNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private final EventLoopGroup group;
    private final RequestAdapter requestAdapter = new RequestAdapter();
    private final ChannelPoolMap<URI, ChannelPool> pools;
    private final NettyConfiguration configuration;

    NettyNioAsyncHttpClient(NettySdkHttpClientFactory factory, AttributeMap serviceDefaultsMap) {
        this.configuration = new NettyConfiguration(serviceDefaultsMap, factory);
        this.group = factory.eventLoopGroupConfiguration().toEither().map(e -> (EventLoopGroup)e.map(NonManagedEventLoopGroup::new, EventLoopGroupFactory::create)).orElseGet(SharedEventLoopGroup::get);
        this.pools = this.createChannelPoolMap();
    }

    private ChannelPoolMap<URI, ChannelPool> createChannelPoolMap() {
        return new SdkChannelPoolMap<URI, ChannelPool>(){

            @Override
            protected ChannelPool newPool(URI key) {
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NettyNioAsyncHttpClient.this.group)).channel(SocketChannelResolver.resolveSocketChannelClass(NettyNioAsyncHttpClient.this.group))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)NettyNioAsyncHttpClient.this.configuration.connectionTimeout())).option(ChannelOption.TCP_NODELAY, (Object)true)).remoteAddress(key.getHost(), key.getPort());
                SslContext sslContext = NettyNioAsyncHttpClient.this.sslContext(key.getScheme());
                return new FixedChannelPool(bootstrap, (ChannelPoolHandler)new ChannelPipelineInitializer(sslContext), ChannelHealthChecker.ACTIVE, FixedChannelPool.AcquireTimeoutAction.FAIL, (long)NettyNioAsyncHttpClient.this.configuration.connectionAcquisitionTimeout(), NettyNioAsyncHttpClient.this.configuration.maxConnectionsPerEndpoint(), NettyNioAsyncHttpClient.this.configuration.maxPendingAcquires());
            }
        };
    }

    public AbortableRunnable prepareRequest(SdkHttpRequest sdkRequest, SdkRequestContext requestContext, SdkHttpRequestProvider requestProvider, SdkHttpResponseHandler handler) {
        RequestContext context = new RequestContext(this.pools.get((Object)NettyNioAsyncHttpClient.poolKey(sdkRequest)), sdkRequest, requestProvider, this.requestAdapter.adapt(sdkRequest), handler, this.configuration);
        return new RunnableRequest(context);
    }

    public <T> Optional<T> getConfigurationValue(SdkHttpConfigurationOption<T> key) {
        return this.configuration.getConfigurationValue(key);
    }

    public void close() {
        this.group.shutdownGracefully();
    }

    private static URI poolKey(SdkHttpRequest sdkRequest) {
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    private SslContext sslContext(String scheme) {
        if (scheme.equalsIgnoreCase("https")) {
            SslContextBuilder builder = SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider());
            if (this.configuration.trustAllCertificates()) {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            }
            return (SslContext)FunctionalUtils.invokeSafely(() -> ((SslContextBuilder)builder).build());
        }
        return null;
    }
}

