/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import com.typesafe.netty.HandlerPublisher;
import io.netty.util.concurrent.EventExecutor;
import java.nio.ByteBuffer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;

class CompletingHandlerPublisher
extends HandlerPublisher<ByteBuffer> {
    private final SdkHttpResponseHandler responseHandler;

    CompletingHandlerPublisher(EventExecutor executor, SdkHttpResponseHandler responseHandler) {
        super(executor, ByteBuffer.class);
        this.responseHandler = responseHandler;
    }

    public void subscribe(final Subscriber<? super ByteBuffer> subscriber) {
        super.subscribe((Subscriber)new Subscriber<ByteBuffer>(){

            public void onSubscribe(Subscription s) {
                subscriber.onSubscribe(s);
            }

            public void onNext(ByteBuffer byteBuffer) {
                subscriber.onNext((Object)byteBuffer);
            }

            public void onError(Throwable t) {
                subscriber.onError(t);
                CompletingHandlerPublisher.this.responseHandler.exceptionOccurred(t);
            }

            public void onComplete() {
                subscriber.onComplete();
                CompletingHandlerPublisher.this.responseHandler.complete();
            }
        });
    }
}

