/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import software.amazon.awssdk.http.nio.netty.EventLoopGroupFactory;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DefaultEventLoopGroupFactory
implements ToCopyableBuilder<Builder, DefaultEventLoopGroupFactory>,
EventLoopGroupFactory {
    private final Integer numberOfThreads;
    private final ThreadFactory threadFactory;

    private DefaultEventLoopGroupFactory(DefaultBuilder builder) {
        this.numberOfThreads = builder.numberOfThreads;
        this.threadFactory = builder.threadFactory;
    }

    public Optional<Integer> numberOfThreads() {
        return Optional.ofNullable(this.numberOfThreads);
    }

    public Optional<ThreadFactory> threadFactory() {
        return Optional.ofNullable(this.threadFactory);
    }

    @Override
    public EventLoopGroup create() {
        int numThreads = this.numberOfThreads == null ? 0 : this.numberOfThreads;
        return new NioEventLoopGroup(numThreads, this.resolveThreadFactory());
    }

    private ThreadFactory resolveThreadFactory() {
        return this.threadFactory != null ? this.threadFactory : new ThreadFactoryBuilder().threadNamePrefix("aws-java-sdk-NettyEventLoop").build();
    }

    public Builder toBuilder() {
        return DefaultEventLoopGroupFactory.builder().threadFactory(this.threadFactory).numberOfThreads(this.numberOfThreads);
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private static final class DefaultBuilder
    implements Builder {
        private Integer numberOfThreads;
        private ThreadFactory threadFactory;

        private DefaultBuilder() {
        }

        @Override
        public Builder numberOfThreads(Integer numberOfThreads) {
            this.numberOfThreads = numberOfThreads;
            return this;
        }

        public void setNumberOfThreads(Integer numberOfThreads) {
            this.numberOfThreads(numberOfThreads);
        }

        @Override
        public Builder threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public void setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory(threadFactory);
        }

        public DefaultEventLoopGroupFactory build() {
            return new DefaultEventLoopGroupFactory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultEventLoopGroupFactory> {
        public Builder numberOfThreads(Integer var1);

        public Builder threadFactory(ThreadFactory var1);
    }
}

