/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Immutable;
import software.amazon.awssdk.annotations.ReviewBeforeRelease;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpClientFactory;
import software.amazon.awssdk.http.nio.netty.EventLoopGroupConfiguration;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@Immutable
public final class NettySdkHttpClientFactory
implements SdkAsyncHttpClientFactory,
ToCopyableBuilder<Builder, NettySdkHttpClientFactory> {
    private final AttributeMap standardOptions;
    private final Optional<Boolean> trustAllCertificates;
    private final EventLoopGroupConfiguration eventLoopGroupConfiguration;
    private final Duration readTimeout;
    private final Duration writeTimeout;
    private final Duration connectionAquisitionTimeout;

    private NettySdkHttpClientFactory(DefaultBuilder builder) {
        this.standardOptions = builder.standardOptions.build();
        this.trustAllCertificates = Optional.ofNullable(builder.trustAllCertificates);
        this.eventLoopGroupConfiguration = builder.eventLoopGroupConfiguration;
        this.readTimeout = this.validateIsWholeSecond(builder.readTimeout, "readTimeout");
        this.writeTimeout = this.validateIsWholeSecond(builder.writeTimeout, "writeTimeout");
        this.connectionAquisitionTimeout = builder.connectionAcquisitionTimeout;
    }

    public Optional<Integer> maxConnectionsPerEndpoint() {
        return Optional.ofNullable(this.standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS));
    }

    public Optional<Duration> writeTimeout() {
        return Optional.ofNullable(this.writeTimeout);
    }

    public Optional<Duration> readTimeout() {
        return Optional.ofNullable(this.readTimeout);
    }

    public Optional<Duration> connectionTimeout() {
        return Optional.ofNullable(this.standardOptions.get((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT));
    }

    public Optional<Duration> connectionAquisitionTimeout() {
        return Optional.ofNullable(this.connectionAquisitionTimeout);
    }

    public Optional<Boolean> trustAllCertificates() {
        return this.trustAllCertificates;
    }

    public EventLoopGroupConfiguration eventLoopGroupConfiguration() {
        return this.eventLoopGroupConfiguration;
    }

    public SdkAsyncHttpClient createHttpClient() {
        return this.createHttpClientWithDefaults(AttributeMap.empty());
    }

    public SdkAsyncHttpClient createHttpClientWithDefaults(AttributeMap serviceDefaults) {
        return new NettyNioAsyncHttpClient(this, this.standardOptions.merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
    }

    public Builder toBuilder() {
        return new DefaultBuilder(this.standardOptions.toBuilder()).trustAllCertificates(this.trustAllCertificates.orElse(null));
    }

    public static Builder builder() {
        return new DefaultBuilder(AttributeMap.builder());
    }

    private Duration validateIsWholeSecond(Duration duration, String param) {
        if (duration != null && duration.toMillis() % 1000L != 0L) {
            throw new IllegalArgumentException(param + "must be a whole second, got: " + duration);
        }
        return duration;
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions;
        private Boolean trustAllCertificates;
        private EventLoopGroupConfiguration eventLoopGroupConfiguration = (EventLoopGroupConfiguration)EventLoopGroupConfiguration.builder().build();
        private Duration readTimeout;
        private Duration writeTimeout;
        private Duration connectionAcquisitionTimeout;

        private DefaultBuilder(AttributeMap.Builder standardOptions) {
            this.standardOptions = standardOptions;
        }

        @Override
        public Builder maxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConnectionsPerEndpoint);
            return this;
        }

        @Override
        public Builder readTimeout(Duration timeout) {
            this.readTimeout = timeout;
            return this;
        }

        @Override
        public Builder writeTimeout(Duration timeout) {
            this.writeTimeout = timeout;
            return this;
        }

        public void setMaxConnectionsPerEndpoint(Integer maxConnectionsPerEndpoint) {
            this.maxConnectionsPerEndpoint(maxConnectionsPerEndpoint);
        }

        @Override
        public Builder connectionTimeout(Duration timeout) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)timeout);
            return this;
        }

        @Override
        public Builder connectionAcquisitionTimeout(Duration timeout) {
            this.connectionAcquisitionTimeout = timeout;
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder trustAllCertificates(Boolean trustAllCertificates) {
            this.trustAllCertificates = trustAllCertificates;
            return this;
        }

        public void setTrustAllCertificates(Boolean trustAllCertificates) {
            this.trustAllCertificates(trustAllCertificates);
        }

        @Override
        public DefaultBuilder eventLoopGroupConfiguration(EventLoopGroupConfiguration eventLoopGroupConfiguration) {
            this.eventLoopGroupConfiguration = eventLoopGroupConfiguration;
            return this;
        }

        public void setEventLoopGroupConfiguration(EventLoopGroupConfiguration eventLoopGroupConfiguration) {
            this.eventLoopGroupConfiguration(eventLoopGroupConfiguration);
        }

        public NettySdkHttpClientFactory build() {
            return new NettySdkHttpClientFactory(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, NettySdkHttpClientFactory> {
        public Builder maxConnectionsPerEndpoint(Integer var1);

        public Builder readTimeout(Duration var1);

        public Builder writeTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        @ReviewBeforeRelease(value="Does it make sense to separate 'connection acquisition' timeout from 'socket connection' timeout?")
        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder trustAllCertificates(Boolean var1);

        public Builder eventLoopGroupConfiguration(EventLoopGroupConfiguration var1);

        default public Builder eventLoopGroupConfiguration(Consumer<EventLoopGroupConfiguration.Builder> eventLoopGroupConfiguration) {
            return this.eventLoopGroupConfiguration((EventLoopGroupConfiguration)((EventLoopGroupConfiguration.Builder)EventLoopGroupConfiguration.builder().apply(eventLoopGroupConfiguration)).build());
        }
    }
}

