/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.http2.MultiplexedChannelRecord;

@SdkInternalApi
public final class ChannelAttributeKey {
    public static final AttributeKey<CompletableFuture<Protocol>> PROTOCOL_FUTURE = AttributeKey.newInstance((String)"protocolFuture");
    public static final AttributeKey<MultiplexedChannelRecord> CHANNEL_POOL_RECORD = AttributeKey.newInstance((String)"channelPoolRecord");
    public static final AttributeKey<Long> MAX_CONCURRENT_STREAMS = AttributeKey.newInstance((String)"maxConcurrentStreams");
    static final AttributeKey<RequestContext> REQUEST_CONTEXT_KEY = AttributeKey.newInstance((String)"requestContext");
    static final AttributeKey<Subscriber<? super ByteBuffer>> SUBSCRIBER_KEY = AttributeKey.newInstance((String)"subscriber");
    static final AttributeKey<Boolean> RESPONSE_COMPLETE_KEY = AttributeKey.newInstance((String)"responseComplete");

    private ChannelAttributeKey() {
    }

    static Protocol getProtocolNow(Channel channel) {
        return (Protocol)((CompletableFuture)(channel.parent() == null ? channel : channel.parent()).attr(PROTOCOL_FUTURE).get()).join();
    }
}

