/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelOption;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.Protocol;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.nio.netty.SdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.ChannelPipelineInitializer;
import software.amazon.awssdk.http.nio.netty.internal.HandlerRemovingChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.NettyConfiguration;
import software.amazon.awssdk.http.nio.netty.internal.NettyRequestExecutor;
import software.amazon.awssdk.http.nio.netty.internal.NonManagedEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.ReleaseOnceChannelPool;
import software.amazon.awssdk.http.nio.netty.internal.RequestContext;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelOptions;
import software.amazon.awssdk.http.nio.netty.internal.SdkChannelPoolMap;
import software.amazon.awssdk.http.nio.netty.internal.SharedSdkEventLoopGroup;
import software.amazon.awssdk.http.nio.netty.internal.http2.HttpOrHttp2ChannelPool;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.Either;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.Validate;

@SdkPublicApi
public final class NettyNioAsyncHttpClient
implements SdkAsyncHttpClient {
    private final SdkEventLoopGroup sdkEventLoopGroup;
    private final ChannelPoolMap<URI, ChannelPool> pools;
    private final SdkChannelOptions sdkChannelOptions;
    private final NettyConfiguration configuration;
    private final long maxStreams;
    private Protocol protocol;

    NettyNioAsyncHttpClient(DefaultBuilder builder, AttributeMap serviceDefaultsMap) {
        this.configuration = new NettyConfiguration(serviceDefaultsMap);
        this.protocol = (Protocol)serviceDefaultsMap.get((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL);
        this.maxStreams = builder.maxHttp2Streams == null ? Integer.MAX_VALUE : (long)builder.maxHttp2Streams.intValue();
        this.sdkEventLoopGroup = this.eventLoopGroup(builder);
        this.pools = this.createChannelPoolMap();
        this.sdkChannelOptions = this.channelOptions(builder);
    }

    private SdkChannelOptions channelOptions(DefaultBuilder builder) {
        return builder.sdkChannelOptions;
    }

    public CompletableFuture<Void> execute(AsyncExecuteRequest request) {
        RequestContext ctx = this.createRequestContext(request);
        return new NettyRequestExecutor(ctx).execute();
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    private RequestContext createRequestContext(AsyncExecuteRequest request) {
        ChannelPool pool = this.pools.get((Object)NettyNioAsyncHttpClient.poolKey(request.request()));
        return new RequestContext(pool, request, this.configuration);
    }

    private SdkEventLoopGroup eventLoopGroup(DefaultBuilder builder) {
        Validate.isTrue((builder.eventLoopGroup == null || builder.eventLoopGroupBuilder == null ? 1 : 0) != 0, (String)"The eventLoopGroup and the eventLoopGroupFactory can't both be configured.", (Object[])new Object[0]);
        return Either.fromNullable((Object)builder.eventLoopGroup, (Object)builder.eventLoopGroupBuilder).map(e -> (SdkEventLoopGroup)e.map(this::nonManagedEventLoopGroup, SdkEventLoopGroup.Builder::build)).orElseGet(SharedSdkEventLoopGroup::get);
    }

    private static URI poolKey(SdkHttpRequest sdkRequest) {
        return (URI)FunctionalUtils.invokeSafely(() -> new URI(sdkRequest.protocol(), null, sdkRequest.host(), sdkRequest.port(), null, null, null));
    }

    private SslContext sslContext(String protocol) {
        if (!protocol.equalsIgnoreCase("https")) {
            return null;
        }
        try {
            return SslContextBuilder.forClient().sslProvider(SslContext.defaultClientProvider()).ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE).trustManager(this.getTrustManager()).build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private TrustManagerFactory getTrustManager() {
        return this.configuration.trustAllCertificates() ? InsecureTrustManagerFactory.INSTANCE : null;
    }

    private ChannelPoolMap<URI, ChannelPool> createChannelPoolMap() {
        return new SdkChannelPoolMap<URI, ChannelPool>(){

            @Override
            protected ChannelPool newPool(URI key) {
                SslContext sslContext = NettyNioAsyncHttpClient.this.sslContext(key.getScheme());
                Bootstrap bootstrap = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.eventLoopGroup())).channelFactory(NettyNioAsyncHttpClient.this.sdkEventLoopGroup.channelFactory())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)NettyNioAsyncHttpClient.this.configuration.connectTimeoutMillis())).remoteAddress(key.getHost(), key.getPort());
                NettyNioAsyncHttpClient.this.sdkChannelOptions.channelOptions().forEach((arg_0, arg_1) -> ((Bootstrap)bootstrap).option(arg_0, arg_1));
                AtomicReference<ChannelPool> channelPoolRef = new AtomicReference<ChannelPool>();
                ChannelPipelineInitializer handler = new ChannelPipelineInitializer(NettyNioAsyncHttpClient.this.protocol, sslContext, NettyNioAsyncHttpClient.this.maxStreams, channelPoolRef);
                channelPoolRef.set(new ReleaseOnceChannelPool(new HandlerRemovingChannelPool(new HttpOrHttp2ChannelPool(bootstrap, (ChannelPoolHandler)handler, NettyNioAsyncHttpClient.this.configuration.maxConnections(), NettyNioAsyncHttpClient.this.configuration))));
                return channelPoolRef.get();
            }
        };
    }

    private SdkEventLoopGroup nonManagedEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
        return SdkEventLoopGroup.create(new NonManagedEventLoopGroup(eventLoopGroup.eventLoopGroup()), eventLoopGroup.channelFactory());
    }

    public void close() {
        this.sdkEventLoopGroup.eventLoopGroup().shutdownGracefully();
    }

    private static final class DefaultBuilder
    implements Builder {
        private final AttributeMap.Builder standardOptions = AttributeMap.builder();
        private SdkChannelOptions sdkChannelOptions = new SdkChannelOptions();
        private SdkEventLoopGroup eventLoopGroup;
        private SdkEventLoopGroup.Builder eventLoopGroupBuilder;
        private Integer maxHttp2Streams;

        private DefaultBuilder() {
        }

        @Override
        public Builder maxConcurrency(Integer maxConcurrency) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_CONNECTIONS, (Object)maxConcurrency);
            return this;
        }

        public void setMaxConcurrency(Integer maxConnectionsPerEndpoint) {
            this.maxConcurrency(maxConnectionsPerEndpoint);
        }

        @Override
        public Builder maxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.MAX_PENDING_CONNECTION_ACQUIRES, (Object)maxPendingAcquires);
            return this;
        }

        public void setMaxPendingConnectionAcquires(Integer maxPendingAcquires) {
            this.maxPendingConnectionAcquires(maxPendingAcquires);
        }

        @Override
        public Builder readTimeout(Duration readTimeout) {
            Validate.isPositive((Duration)readTimeout, (String)"readTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.READ_TIMEOUT, (Object)readTimeout);
            return this;
        }

        public void setReadTimeout(Duration readTimeout) {
            this.readTimeout(readTimeout);
        }

        @Override
        public Builder writeTimeout(Duration writeTimeout) {
            Validate.isPositive((Duration)writeTimeout, (String)"writeTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.WRITE_TIMEOUT, (Object)writeTimeout);
            return this;
        }

        public void setWriteTimeout(Duration writeTimeout) {
            this.writeTimeout(writeTimeout);
        }

        @Override
        public Builder connectionTimeout(Duration timeout) {
            Validate.isPositive((Duration)timeout, (String)"connectionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_TIMEOUT, (Object)timeout);
            return this;
        }

        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout(connectionTimeout);
        }

        @Override
        public Builder connectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            Validate.isPositive((Duration)connectionAcquisitionTimeout, (String)"connectionAcquisitionTimeout");
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.CONNECTION_ACQUIRE_TIMEOUT, (Object)connectionAcquisitionTimeout);
            return this;
        }

        public void setConnectionAcquisitionTimeout(Duration connectionAcquisitionTimeout) {
            this.connectionAcquisitionTimeout(connectionAcquisitionTimeout);
        }

        @Override
        public Builder eventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = eventLoopGroup;
            return this;
        }

        public void setEventLoopGroup(SdkEventLoopGroup eventLoopGroup) {
            this.eventLoopGroup(eventLoopGroup);
        }

        @Override
        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder = eventLoopGroupBuilder;
            return this;
        }

        public void setEventLoopGroupBuilder(SdkEventLoopGroup.Builder eventLoopGroupBuilder) {
            this.eventLoopGroupBuilder(eventLoopGroupBuilder);
        }

        @Override
        public Builder protocol(Protocol protocol) {
            this.standardOptions.put((AttributeMap.Key)SdkHttpConfigurationOption.PROTOCOL, (Object)protocol);
            return this;
        }

        public void setProtocol(Protocol protocol) {
            this.protocol(protocol);
        }

        @Override
        public Builder putChannelOption(ChannelOption channelOption, Object value) {
            this.sdkChannelOptions.putOption(channelOption, value);
            return this;
        }

        @Override
        public Builder maxHttp2Streams(Integer maxHttp2Streams) {
            this.maxHttp2Streams = maxHttp2Streams;
            return this;
        }

        public void setMaxHttp2Streams(Integer maxHttp2Streams) {
            this.maxHttp2Streams(maxHttp2Streams);
        }

        public SdkAsyncHttpClient buildWithDefaults(AttributeMap serviceDefaults) {
            return new NettyNioAsyncHttpClient(this, this.standardOptions.build().merge(serviceDefaults).merge(SdkHttpConfigurationOption.GLOBAL_HTTP_DEFAULTS));
        }
    }

    public static interface Builder
    extends SdkAsyncHttpClient.Builder<Builder> {
        public Builder maxConcurrency(Integer var1);

        public Builder maxPendingConnectionAcquires(Integer var1);

        public Builder readTimeout(Duration var1);

        public Builder writeTimeout(Duration var1);

        public Builder connectionTimeout(Duration var1);

        public Builder connectionAcquisitionTimeout(Duration var1);

        public Builder eventLoopGroup(SdkEventLoopGroup var1);

        public Builder eventLoopGroupBuilder(SdkEventLoopGroup.Builder var1);

        public Builder protocol(Protocol var1);

        public Builder putChannelOption(ChannelOption var1, Object var2);

        public Builder maxHttp2Streams(Integer var1);
    }
}

